/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2TouchFeature
implements Touch<BaseB2Response> {
    private Write<BaseB2Response> writer;

    public B2TouchFeature(B2Session session) {
        this.writer = new B2WriteFeature(session);
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum(file).compute((InputStream)new NullInputStream(0L), status));
        }
        status.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
        new DefaultStreamCloser().close((OutputStream)out);
        return new Path(file.getParent(), file.getName(), file.getType(), new PathAttributes(file.attributes()).withVersionId(((B2FileResponse)out.getStatus()).getFileId()));
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public B2TouchFeature withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return this;
    }
}

