/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2TouchFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.TransferBackgroundActionState;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.B2FinishLargeFileResponse;
import synapticloop.b2.response.B2GetUploadUrlResponse;
import synapticloop.b2.response.B2StartLargeFileResponse;
import synapticloop.b2.response.B2UploadPartResponse;

public class B2LargeUploadWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(B2LargeUploadWriteFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final Find finder;
    private final AttributesFinder attributes;

    public B2LargeUploadWriteFeature(B2Session session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public B2LargeUploadWriteFeature(B2Session session, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public StatusOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        final LargeUploadOutputStream proxy = new LargeUploadOutputStream(file, status);
        return new HttpResponseOutputStream<VersionId>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("b2.upload.largeobject.size.minimum")))){

            public VersionId getStatus() throws BackgroundException {
                return proxy.getFileId();
            }
        };
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }

    private final class LargeUploadOutputStream
    extends OutputStream {
        final List<B2UploadPartResponse> completed = new ArrayList<B2UploadPartResponse>();
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private VersionId version;
        private int partNumber;

        public LargeUploadOutputStream(Path file, TransferStatus status) {
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] content, final int off, final int len) throws IOException {
            try {
                if (0 == this.partNumber && len < PreferencesFactory.get().getInteger("b2.upload.largeobject.size.minimum")) {
                    B2GetUploadUrlResponse uploadUrl = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).getUploadUrl(new B2FileidProvider(B2LargeUploadWriteFeature.this.session).getFileid(B2LargeUploadWriteFeature.this.containerService.getContainer(this.file), (ListProgressListener)new DisabledListProgressListener()));
                    Checksum checksum = this.overall.getChecksum();
                    B2FileResponse response = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).uploadFile(uploadUrl, B2LargeUploadWriteFeature.this.containerService.getKey(this.file), (HttpEntity)new ByteArrayEntity(content, off, len), Checksum.NONE == checksum ? "do_not_verify" : checksum.hash, this.overall.getMime(), this.overall.getMetadata());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Upload finished for %s with response %s", this.file, response));
                    }
                    this.version = new VersionId(response.getFileId());
                } else {
                    if (0 == this.partNumber) {
                        HashMap<String, String> fileinfo = new HashMap<String, String>(this.overall.getMetadata());
                        if (null != this.overall.getTimestamp()) {
                            fileinfo.put("src_last_modified_millis", String.valueOf(this.overall.getTimestamp()));
                        }
                        B2StartLargeFileResponse response = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).startLargeFileUpload(new B2FileidProvider(B2LargeUploadWriteFeature.this.session).getFileid(B2LargeUploadWriteFeature.this.containerService.getContainer(this.file), (ListProgressListener)new DisabledListProgressListener()), B2LargeUploadWriteFeature.this.containerService.getKey(this.file), this.overall.getMime(), fileinfo);
                        this.version = new VersionId(response.getFileId());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Multipart upload started for %s with ID %s", this.file, this.version));
                        }
                    }
                    final int segment = ++this.partNumber;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Write segment %d for upload %s", segment, this.version));
                    }
                    this.completed.add((B2UploadPartResponse)new DefaultRetryCallable((BackgroundExceptionCallable)new BackgroundExceptionCallable<B2UploadPartResponse>(){

                        public B2UploadPartResponse call() throws BackgroundException {
                            TransferStatus status = new TransferStatus().length((long)len);
                            ByteArrayEntity entity = new ByteArrayEntity(content, off, len);
                            Checksum checksum = ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha1).compute((InputStream)new ByteArrayInputStream(content, off, len), status);
                            try {
                                return ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).uploadLargeFilePart(((LargeUploadOutputStream)LargeUploadOutputStream.this).version.id, segment, (HttpEntity)entity, checksum.hash);
                            }
                            catch (B2ApiException e) {
                                throw new B2ExceptionMappingService().map("Upload {0} failed", e, LargeUploadOutputStream.this.file);
                            }
                            catch (IOException e) {
                                throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, LargeUploadOutputStream.this.file);
                            }
                        }
                    }, (ProgressListener)new DisabledProgressListener(), (BackgroundActionState)new TransferBackgroundActionState(this.overall)).call());
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (B2ApiException e) {
                throw new IOException(new B2ExceptionMappingService().map("Upload {0} failed", e, this.file));
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (this.completed.isEmpty()) {
                    if (null == this.version) {
                        this.version = new VersionId(new B2TouchFeature(B2LargeUploadWriteFeature.this.session).touch(this.file, new TransferStatus()).attributes().getVersionId());
                    }
                } else {
                    this.completed.sort(new Comparator<B2UploadPartResponse>(){

                        @Override
                        public int compare(B2UploadPartResponse o1, B2UploadPartResponse o2) {
                            return o1.getPartNumber().compareTo(o2.getPartNumber());
                        }
                    });
                    ArrayList<String> checksums = new ArrayList<String>();
                    for (B2UploadPartResponse part : this.completed) {
                        checksums.add(part.getContentSha1());
                    }
                    B2FinishLargeFileResponse response = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).finishLargeFileUpload(this.version.id, checksums.toArray(new String[checksums.size()]));
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Finished large file upload %s with %d parts", this.file, this.completed.size()));
                    }
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            catch (B2ApiException e) {
                throw new IOException(new B2ExceptionMappingService().map("Upload {0} failed", e, this.file));
            }
            finally {
                this.close.set(true);
            }
        }

        public VersionId getFileId() {
            return this.version;
        }
    }
}

