/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.worker.SessionListWorker;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class MountWorker
extends Worker<Path> {
    private static final Logger log = Logger.getLogger(MountWorker.class);
    private final Host bookmark;
    private final Cache<Path> cache;
    private final ListProgressListener listener;

    public MountWorker(Host bookmark, Cache<Path> cache, ListProgressListener listener) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.listener = listener;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Object list;
        Path home;
        try {
            home = session.getFeature(Home.class).find();
            this.cache.invalidate(home);
            list = new SessionListWorker(this.cache, home, this.listener).run((Session)session);
        }
        catch (NotfoundException e) {
            log.warn((Object)String.format("Mount failed with %s", e.getMessage()));
            home = new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
            this.cache.invalidate(home);
            list = new SessionListWorker(this.cache, home, this.listener).run((Session)session);
        }
        this.cache.put(home, (AttributedList<Path>)list);
        return home;
    }

    @Override
    public void cleanup(Path workdir) {
        if (null != workdir) {
            FolderBookmarkCollection bookmarks;
            HistoryCollection history = HistoryCollection.defaultCollection();
            if (history.isLoaded()) {
                history.add(this.bookmark);
            }
            if ((bookmarks = FolderBookmarkCollection.favoritesCollection()).isLoaded() && bookmarks.contains(this.bookmark)) {
                ((Collection)bookmarks).collectionItemChanged(this.bookmark);
            }
        }
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Mounting {0}", "Status"), this.bookmark.getHostname());
    }

    @Override
    public Path initialize() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MountWorker that = (MountWorker)o;
        return !(this.cache != null ? !this.cache.equals(that.cache) : that.cache != null);
    }

    public int hashCode() {
        return this.cache != null ? this.cache.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MountWorker{");
        sb.append("cache=").append(this.cache);
        sb.append('}');
        return sb.toString();
    }
}

