/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class HostPasswordStore
implements PasswordStore {
    private static final Logger log = Logger.getLogger(HostPasswordStore.class);
    private final Preferences preferences = PreferencesFactory.get();

    public String findLoginPassword(Host bookmark) {
        String password;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching login password from keychain for %s", bookmark));
        }
        if (null == (password = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername())) && log.isInfoEnabled()) {
            log.info((Object)String.format("Password not found in keychain for %s", bookmark));
        }
        return password;
    }

    public String findPrivateKeyPassphrase(Host bookmark) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching private key passphrase from keychain for %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            Local key = credentials.getIdentity();
            String passphrase = this.getPassword(bookmark.getHostname(), key.getAbbreviatedPath());
            if (null == passphrase) {
                passphrase = this.getPassword("SSH", key.getAbsolute());
            }
            if (null == passphrase) {
                passphrase = this.getPassword("SSHKeychain", key.getAbbreviatedPath());
            }
            if (null == passphrase && log.isInfoEnabled()) {
                log.info((Object)String.format("Passphrase not found in keychain for %s", key));
            }
            return passphrase;
        }
        return null;
    }

    public void save(Host host) {
        if (StringUtils.isEmpty((CharSequence)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return;
        }
        Credentials credentials = host.getCredentials();
        if (!credentials.isSaved()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip writing credentials for host %s", host.getHostname()));
            }
            return;
        }
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)String.format("No username in credentials for host %s", host.getHostname()));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)credentials.getPassword())) {
            log.warn((Object)String.format("No password in credentials for host %s", host.getHostname()));
            return;
        }
        if (credentials.isAnonymousLogin()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Do not write anonymous credentials for host %s", host.getHostname()));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Add password for host %s", host));
        }
        if (credentials.isPublicKeyAuthentication()) {
            this.addPassword(host.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getPassword());
        } else {
            this.addPassword(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), credentials.getUsername(), credentials.getPassword());
        }
    }
}

