/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSearchListService;
import ch.cyberduck.core.googledrive.DriveSession;

public class DriveSearchFeature
implements Search {
    private DriveSession session;
    private DriveFileidProvider fileid;

    public DriveSearchFeature(DriveSession session) {
        this(session, new DriveFileidProvider(session));
    }

    public DriveSearchFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        try {
            return new DriveSearchListService(this.session, regex.toPattern().pattern()).list(workdir, listener);
        }
        catch (NotfoundException e) {
            return AttributedList.emptyList();
        }
    }

    public boolean isRecursive() {
        return true;
    }

    public Search withCache(Cache<Path> cache) {
        this.fileid.withCache(cache);
        return this;
    }
}

