/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.googledrive.DriveDeleteFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;

public class DriveMoveFeature
implements Move {
    private final DriveSession session;
    private Delete delete;

    public DriveMoveFeature(DriveSession session) {
        this.session = session;
        this.delete = new DriveDeleteFeature(session);
    }

    public boolean isSupported(Path source, Path target) {
        return !source.getType().contains(AbstractPath.Type.placeholder);
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            if (status.isExists()) {
                this.delete.delete(Collections.singletonList(renamed), (PasswordCallback)connectionCallback, callback);
            }
            String fileid = new DriveFileidProvider(this.session).getFileid(file, (ListProgressListener)new DisabledListProgressListener());
            if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)renamed.getName())) {
                File properties = new File();
                properties.setName(renamed.getName());
                properties.setMimeType(status.getMime());
                ((Drive)this.session.getClient()).files().update(fileid, properties).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            }
            StringBuilder previousParents = new StringBuilder();
            File reference = (File)((Drive)this.session.getClient()).files().get(fileid).setFields("parents").setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            for (String parent : reference.getParents()) {
                previousParents.append(parent);
                previousParents.append(',');
            }
            ((Drive)this.session.getClient()).files().update(fileid, null).setAddParents(new DriveFileidProvider(this.session).getFileid(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())).setRemoveParents(previousParents.toString()).setFields("id, parents").setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new PathAttributes(renamed.attributes()).withVersionId(fileid));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

