/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.DriveDefaultListService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveSharedFolderListService;
import ch.cyberduck.core.googledrive.DriveTeamDrivesListService;

public class DriveListService
implements ListService {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveListService(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            AttributedList list = new AttributedList();
            list.add((Referenceable)DriveHomeFinderService.MYDRIVE_FOLDER);
            list.add((Referenceable)DriveHomeFinderService.SHARED_FOLDER_NAME);
            list.add((Referenceable)DriveHomeFinderService.TEAM_DRIVES_NAME);
            listener.chunk(directory, list);
            return list;
        }
        if (DriveHomeFinderService.SHARED_FOLDER_NAME.equals((Object)directory)) {
            return new DriveSharedFolderListService(this.session).list(directory, listener);
        }
        if (DriveHomeFinderService.TEAM_DRIVES_NAME.equals((Object)directory)) {
            return new DriveTeamDrivesListService(this.session).list(directory, listener);
        }
        return new DriveDefaultListService(this.session, this.fileid).list(directory, listener);
    }
}

