/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.FileidDriveListService;
import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class DriveFileidProvider
implements IdProvider {
    private final DriveSession session;

    public DriveFileidProvider(DriveSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (file.isRoot()) {
            return "root";
        }
        if (file.equals((Object)DriveHomeFinderService.MYDRIVE_FOLDER)) {
            return "root";
        }
        AttributedList<Path> list = new FileidDriveListService(this.session, this, file).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
        Path found = (Path)list.filter((Comparator)new Comparator<Path>(){

            @Override
            public int compare(Path p1, Path p2) {
                return -Long.compare(p1.attributes().getModificationDate(), p2.attributes().getModificationDate());
            }
        }, (Filter)new NullFilter()).find((Predicate)new SimplePathPredicate(file));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return found.attributes().getVersionId();
    }

    public IdProvider withCache(Cache<Path> cache) {
        return this;
    }
}

