/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.date.ISO8601DateParser;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(SwiftObjectListService.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final ISO8601DateParser dateParser = new ISO8601DateParser();
    private final SwiftRegionService regionService;

    public SwiftObjectListService(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftObjectListService(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            List list;
            AttributedList children = new AttributedList();
            int limit = PreferencesFactory.get().getInteger("openstack.list.object.limit");
            String marker = null;
            do {
                Path container = this.containerService.getContainer(directory);
                list = ((Client)this.session.getClient()).listObjectsStartingWith(this.regionService.lookup(container), container.getName(), this.containerService.isContainer(directory) ? "" : this.containerService.getKey(directory) + '/', null, limit, marker, Character.valueOf('/'));
                for (StorageObject object : list) {
                    EnumSet<AbstractPath.Type> types;
                    PathAttributes attributes = new PathAttributes();
                    attributes.setOwner(container.attributes().getOwner());
                    attributes.setRegion(container.attributes().getRegion());
                    if (StringUtils.isNotBlank((CharSequence)object.getMd5sum())) {
                        attributes.setChecksum(Checksum.parse((String)object.getMd5sum()));
                    }
                    attributes.setSize(object.getSize().longValue());
                    String lastModified = object.getLastModified();
                    if (lastModified != null) {
                        try {
                            attributes.setModificationDate(this.dateParser.parse(lastModified).getTime());
                        }
                        catch (InvalidDateException e) {
                            log.warn((Object)String.format("%s is not ISO 8601 format %s", lastModified, e.getMessage()));
                        }
                    }
                    EnumSet<AbstractPath.Type> enumSet = types = "application/directory".equals(object.getMimeType()) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                    if (StringUtils.endsWith((CharSequence)object.getName(), (CharSequence)String.valueOf('/')) && children.contains((Referenceable)new Path(directory, PathNormalizer.name((String)object.getName()), EnumSet.of(AbstractPath.Type.directory), attributes))) continue;
                    children.add((Referenceable)new Path(directory, PathNormalizer.name((String)object.getName()), types, attributes));
                    marker = object.getName();
                }
                listener.chunk(directory, children);
            } while (list.size() == limit);
            return children;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, directory);
        }
    }
}

