/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.pub.domain.UserGroup;

public class GeneralAdminInp
extends AbstractIRODSPackingInstruction {
    private static final String PI_TAG = "generalAdminInp_PI";
    public static final int GEN_ADMIN_INP_API_NBR = 701;
    public static final String ARG0 = "arg0";
    public static final String ARG1 = "arg1";
    public static final String ARG2 = "arg2";
    public static final String ARG3 = "arg3";
    public static final String ARG4 = "arg4";
    public static final String ARG5 = "arg5";
    public static final String ARG6 = "arg6";
    public static final String ARG7 = "arg7";
    public static final String ARG8 = "arg8";
    public static final String ARG9 = "arg9";
    public static final String BLANK = "";
    private String arg0 = "";
    private String arg1 = "";
    private String arg2 = "";
    private String arg3 = "";
    private String arg4 = "";
    private String arg5 = "";
    private String arg6 = "";
    private String arg7 = "";
    private String arg8 = "";
    private String arg9 = "";

    public static GeneralAdminInp instanceForAddUser(User user) throws JargonException {
        if (user == null) {
            throw new JargonException("null user");
        }
        if (user.getName().isEmpty()) {
            throw new JargonException("blank user name");
        }
        if (user.getUserType() == UserTypeEnum.RODS_UNKNOWN) {
            throw new JargonException("unknown user type");
        }
        return new GeneralAdminInp("add", "user", user.getName(), user.getUserType().getTextValue(), BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserComment(String userName, String comment) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("null or missing user name");
        }
        if (comment == null) {
            throw new JargonException("null comment");
        }
        return new GeneralAdminInp("modify", "user", userName, "comment", comment, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserInfo(String userName, String info) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("null or missing user name");
        }
        if (info == null) {
            throw new JargonException("null comment");
        }
        return new GeneralAdminInp("modify", "user", userName, "info", info, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForDeleteUser(String userName) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        return new GeneralAdminInp("rm", "user", userName, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForSetUserQuotaTotal(String userName, long quotaValue) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quota value is less than or equal to zero");
        }
        return new GeneralAdminInp("set-quota", "user", userName, "total", String.valueOf(quotaValue), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForSetUserGroupQuotaTotal(String userGroupName, long quotaValue) throws JargonException {
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quota value is less than or equal to zero");
        }
        return new GeneralAdminInp("set-quota", "group", userGroupName, "total", String.valueOf(quotaValue), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForSetUserQuotaForResource(String userName, String resourceName, long quotaValue) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quota value is less than or equal to zero");
        }
        return new GeneralAdminInp("set-quota", "user", userName, resourceName, String.valueOf(quotaValue), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForSetUserGroupQuotaForResource(String userGroupName, String resourceName, long quotaValue) throws JargonException {
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quota value is less than or equal to zero");
        }
        return new GeneralAdminInp("set-quota", "group", userGroupName, resourceName, String.valueOf(quotaValue), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForCalculateQuotaUsage() throws JargonException {
        return new GeneralAdminInp("calculate-usage", BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserZone(String userName, String zone) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        if (zone == null) {
            throw new JargonException("zone is null");
        }
        return new GeneralAdminInp("modify", "user", userName, "zone", zone, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserDN(String userName, String userDN) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        if (userDN == null || userDN.isEmpty()) {
            throw new JargonException("user dn is null or empty");
        }
        return new GeneralAdminInp("modify", "user", userName, "addAuth", userDN, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForRemoveUserDN(String userName, String userDN) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        if (userDN == null || userDN.isEmpty()) {
            throw new JargonException("user dn is null or empty");
        }
        return new GeneralAdminInp("modify", "user", userName, "rmAuth", userDN, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserPasswordByAdmin(String userName, String password) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new JargonException("password is null or empty");
        }
        return new GeneralAdminInp("modify", "user", userName, "password", password, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserPassword(String userName, String password) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new JargonException("password is null or empty");
        }
        return new GeneralAdminInp("modify", "user", userName, "password", password, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForAddUserGroup(UserGroup userGroup) throws JargonException {
        if (userGroup == null) {
            throw new IllegalArgumentException("null userGroup");
        }
        return new GeneralAdminInp("add", "user", userGroup.getUserGroupName(), "rodsgroup", userGroup.getZone(), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForAddUserToGroup(String userGroupName, String userName, String zoneName) throws JargonException {
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        StringBuilder userNameBuilder = new StringBuilder();
        userNameBuilder.append(userName.trim());
        if (zoneName != null && zoneName.length() > 0) {
            userNameBuilder.append('#');
            userNameBuilder.append(zoneName.trim());
        }
        return new GeneralAdminInp("modify", "group", userGroupName.trim(), "add", userNameBuilder.toString(), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForRemoveUserFromGroup(String userGroupName, String userName, String zoneName) throws JargonException {
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        StringBuilder userNameBuilder = new StringBuilder();
        userNameBuilder.append(userName.trim());
        if (zoneName != null && zoneName.length() > 0) {
            userNameBuilder.append('#');
            userNameBuilder.append(zoneName.trim());
        }
        return new GeneralAdminInp("modify", "group", userGroupName.trim(), "remove", userNameBuilder.toString(), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForRemoveUserGroup(UserGroup userGroup) throws JargonException {
        if (userGroup == null) {
            throw new IllegalArgumentException("null userGroup");
        }
        return new GeneralAdminInp("rm", "user", userGroup.getUserGroupName(), userGroup.getZone(), BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    public static GeneralAdminInp instanceForModifyUserType(String userName, UserTypeEnum userType) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new JargonException("user name is null or empty");
        }
        if (userType == null) {
            throw new JargonException("user type is null");
        }
        if (userType == UserTypeEnum.RODS_UNKNOWN) {
            throw new JargonException("user type is null");
        }
        return new GeneralAdminInp("modify", "user", userName, "type", userType.getTextValue(), BLANK, BLANK, BLANK, BLANK, BLANK, 701);
    }

    protected GeneralAdminInp(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, String arg8, String arg9, int apiNumber) throws JargonException {
        if (apiNumber <= 0) {
            throw new JargonException("api type is <= zero");
        }
        this.setApiNumber(apiNumber);
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.arg4 = arg4;
        this.arg5 = arg5;
        this.arg6 = arg6;
        this.arg7 = arg7;
        this.arg8 = arg8;
        this.arg9 = arg9;
    }

    public String getArg0() {
        return this.arg0;
    }

    public String getArg1() {
        return this.arg1;
    }

    public String getArg2() {
        return this.arg2;
    }

    public String getArg3() {
        return this.arg3;
    }

    public String getArg4() {
        return this.arg4;
    }

    public String getArg5() {
        return this.arg5;
    }

    public String getArg6() {
        return this.arg6;
    }

    public String getArg7() {
        return this.arg7;
    }

    public String getArg8() {
        return this.arg8;
    }

    public String getArg9() {
        return this.arg9;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(ARG0, this.getArg0()), new Tag(ARG1, this.getArg1()), new Tag(ARG2, this.getArg2()), new Tag(ARG3, this.getArg3()), new Tag(ARG4, this.getArg4()), new Tag(ARG5, this.getArg5()), new Tag(ARG6, this.getArg6()), new Tag(ARG7, this.getArg7()), new Tag(ARG8, this.getArg8()), new Tag(ARG9, this.getArg9())});
        return message;
    }
}

