/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.diagnostics;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.diagnostics.Reachability;
import ch.cyberduck.core.idna.PunycodeConverter;
import ch.cyberduck.core.library.Native;

public final class SystemConfigurationReachability
implements Reachability {
    public boolean isReachable(Host host) {
        return this.isReachable(this.toURL(host));
    }

    private String toURL(Host host) {
        StringBuilder url = new StringBuilder(host.getProtocol().getScheme().toString());
        url.append("://");
        url.append(new PunycodeConverter().convert(host.getHostname()));
        url.append(":").append(host.getPort());
        return url.toString();
    }

    private native boolean isReachable(String var1);

    public void diagnose(Host host) {
        this.diagnose(new HostUrlProvider().withUsername(false).get(host));
    }

    private native void diagnose(String var1);

    static {
        Native.load((String)"core");
    }
}

