/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageAccessControlListFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageDirectoryFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageLoggingFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageUrlProvider;
import ch.cyberduck.core.googlestorage.GoogleStorageWebsiteDistributionConfiguration;
import ch.cyberduck.core.identity.DefaultCredentialsIdentityConfiguration;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3MetadataFeature;
import ch.cyberduck.core.s3.S3MoveFeature;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3SingleUploadService;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.InputStream;
import java.util.Collections;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.AccessControlListHandler;
import org.jets3t.service.impl.rest.GSAccessControlListHandler;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.WebsiteConfig;
import org.jets3t.service.security.ProviderCredentials;

public class GoogleStorageSession
extends S3Session {
    private OAuth2RequestInterceptor authorizationService;

    public GoogleStorageSession(Host h) {
        super(h);
    }

    public GoogleStorageSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected Jets3tProperties configure() {
        Jets3tProperties configuration = super.configure();
        configuration.setProperty("s3service.enable-storage-classes", String.valueOf(false));
        configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
        return configuration;
    }

    public RequestEntityRestStorageService connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.authorizationService));
        return new OAuth2RequestEntityRestStorageService(this, this.configure(), configuration);
    }

    protected boolean authorize(HttpUriRequest request, ProviderCredentials credentials) throws ServiceException {
        request.setHeader("x-goog-api-version", "2");
        return true;
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, keychain, prompt, cancel));
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return super.list(directory, listener);
        }
        return new S3ObjectListService((S3Session)this).list(directory, listener);
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser(this.configure(), false){

            public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws ServiceException {
                return this.parseAccessControlListResponse(inputStream, (AccessControlListHandler)new GSAccessControlListHandler());
            }

            public XmlResponsesSaxParser.BucketLoggingStatusHandler parseLoggingStatusResponse(InputStream inputStream) throws ServiceException {
                return super.parseLoggingStatusResponse(inputStream, (XmlResponsesSaxParser.BucketLoggingStatusHandler)new XmlResponsesSaxParser.GSBucketLoggingStatusHandler((XmlResponsesSaxParser)this));
            }

            public WebsiteConfig parseWebsiteConfigurationResponse(InputStream inputStream) throws ServiceException {
                return super.parseWebsiteConfigurationResponse(inputStream, (XmlResponsesSaxParser.WebsiteConfigurationHandler)new XmlResponsesSaxParser.GSWebsiteConfigurationHandler((XmlResponsesSaxParser)this));
            }
        };
    }

    protected String getSignatureIdentifier() {
        return "GOOG1";
    }

    protected String getRestHeaderPrefix() {
        return "x-goog-";
    }

    protected String getRestMetadataPrefix() {
        return "x-goog-meta-";
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Upload.class) {
            return (T)new S3SingleUploadService((S3Session)this, (Write)new S3WriteFeature((S3Session)this, (S3MultipartService)new S3DisabledMultipartService()));
        }
        if (type == MultipartWrite.class) {
            return null;
        }
        if (type == Write.class) {
            return (T)new S3WriteFeature((S3Session)this, (S3MultipartService)new S3DisabledMultipartService());
        }
        if (type == Delete.class) {
            return (T)new S3DefaultDeleteFeature((S3Session)this);
        }
        if (type == Directory.class) {
            return (T)((Object)new GoogleStorageDirectoryFeature(this, (Write<StorageObject>)new S3WriteFeature((S3Session)this, (S3MultipartService)new S3DisabledMultipartService())));
        }
        if (type == Move.class) {
            return (T)new S3MoveFeature((S3Session)this, (S3AccessControlListFeature)new GoogleStorageAccessControlListFeature(this));
        }
        if (type == Headers.class) {
            return (T)new S3MetadataFeature((S3Session)this, (S3AccessControlListFeature)new GoogleStorageAccessControlListFeature(this));
        }
        if (type == Metadata.class) {
            return (T)new S3MetadataFeature((S3Session)this, (S3AccessControlListFeature)new GoogleStorageAccessControlListFeature(this));
        }
        if (type == Copy.class) {
            return (T)new S3CopyFeature((S3Session)this, (S3AccessControlListFeature)new GoogleStorageAccessControlListFeature(this));
        }
        if (type == AclPermission.class) {
            return (T)((Object)new GoogleStorageAccessControlListFeature(this));
        }
        if (type == DistributionConfiguration.class) {
            return (T)new GoogleStorageWebsiteDistributionConfiguration(this);
        }
        if (type == IdentityConfiguration.class) {
            return (T)new DefaultCredentialsIdentityConfiguration(this.host);
        }
        if (type == Logging.class) {
            return (T)((Object)new GoogleStorageLoggingFeature(this));
        }
        if (type == Lifecycle.class) {
            return null;
        }
        if (type == Versioning.class) {
            return null;
        }
        if (type == Encryption.class) {
            return null;
        }
        if (type == Redundancy.class) {
            return null;
        }
        if (type == UrlProvider.class) {
            return (T)new GoogleStorageUrlProvider(this);
        }
        return (T)super._getFeature(type);
    }

    private final class OAuth2RequestEntityRestStorageService
    extends RequestEntityRestStorageService {
        public OAuth2RequestEntityRestStorageService(GoogleStorageSession session, Jets3tProperties properties, HttpClientBuilder configuration) {
            super((S3Session)session, properties, configuration);
        }

        protected StorageBucket createBucketImpl(String bucketName, String location, AccessControlList acl) throws ServiceException {
            return super.createBucketImpl(bucketName, location, acl, Collections.singletonMap("x-goog-project-id", GoogleStorageSession.this.host.getCredentials().getUsername()));
        }

        protected StorageBucket[] listAllBucketsImpl() throws ServiceException {
            return super.listAllBucketsImpl(Collections.singletonMap("x-goog-project-id", GoogleStorageSession.this.host.getCredentials().getUsername()));
        }
    }
}

