/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.dropbox.DropboxSession;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DropboxUrlProvider
implements UrlProvider {
    private static final Logger log = Logger.getLogger(DropboxUrlProvider.class);
    private final DropboxSession session;

    public DropboxUrlProvider(DropboxSession session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.isFile()) {
            try {
                String link = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).getTemporaryLink(file.getAbsolute()).getLink();
                Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                expiry.add(10, 4);
                list.add(new DescriptiveUrl(URI.create(link), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Temporary", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(expiry.getTimeInMillis()))));
            }
            catch (DbxException e) {
                log.warn((Object)String.format("Failure retrieving shared link. %s", e.getMessage()));
            }
        }
        return list;
    }
}

