/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.HostnameConfiguratorFactory;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloudfront.CustomOriginCloudFrontDistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxySocketFactory;
import ch.cyberduck.core.sftp.SFTPAttributesFinderFeature;
import ch.cyberduck.core.sftp.SFTPCommandFeature;
import ch.cyberduck.core.sftp.SFTPCompressFeature;
import ch.cyberduck.core.sftp.SFTPDeleteFeature;
import ch.cyberduck.core.sftp.SFTPDirectoryFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPFindFeature;
import ch.cyberduck.core.sftp.SFTPHomeDirectoryService;
import ch.cyberduck.core.sftp.SFTPListService;
import ch.cyberduck.core.sftp.SFTPMoveFeature;
import ch.cyberduck.core.sftp.SFTPQuotaFeature;
import ch.cyberduck.core.sftp.SFTPReadFeature;
import ch.cyberduck.core.sftp.SFTPSymlinkFeature;
import ch.cyberduck.core.sftp.SFTPTimestampFeature;
import ch.cyberduck.core.sftp.SFTPTouchFeature;
import ch.cyberduck.core.sftp.SFTPUnixPermissionFeature;
import ch.cyberduck.core.sftp.SFTPWriteFeature;
import ch.cyberduck.core.sftp.auth.SFTPAgentAuthentication;
import ch.cyberduck.core.sftp.auth.SFTPChallengeResponseAuthentication;
import ch.cyberduck.core.sftp.auth.SFTPNoneAuthentication;
import ch.cyberduck.core.sftp.auth.SFTPPasswordAuthentication;
import ch.cyberduck.core.sftp.auth.SFTPPublicKeyAuthentication;
import ch.cyberduck.core.sftp.openssh.OpenSSHAgentAuthenticator;
import ch.cyberduck.core.sftp.putty.PageantAuthenticator;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.net.SocketFactory;
import net.schmizz.concurrent.Promise;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.DisconnectListener;
import net.schmizz.sshj.transport.NegotiatedAlgorithms;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.compression.DelayedZlibCompression;
import net.schmizz.sshj.transport.compression.NoneCompression;
import net.schmizz.sshj.transport.compression.ZlibCompression;
import net.schmizz.sshj.transport.verification.AlgorithmsVerifier;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFTPSession
extends Session<SSHClient> {
    private static final Logger log = Logger.getLogger(SFTPSession.class);
    private final Preferences preferences = PreferencesFactory.get();
    private SFTPEngine sftp;
    private StateDisconnectListener disconnectListener;
    private NegotiatedAlgorithms algorithms;
    private final SocketFactory socketFactory;

    public SFTPSession(Host h) {
        this(h, (SocketFactory)new ProxySocketFactory(h.getProtocol(), (TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(h)));
    }

    public SFTPSession(Host h, SocketFactory socketFactory) {
        super(h);
        this.socketFactory = socketFactory;
    }

    public boolean isConnected() {
        if (super.isConnected()) {
            return ((SSHClient)this.client).isConnected();
        }
        return false;
    }

    public SSHClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        try {
            DefaultConfig configuration = new DefaultConfig();
            if ("zlib".equals(this.preferences.getProperty("ssh.compression"))) {
                configuration.setCompressionFactories(Arrays.asList(new DelayedZlibCompression.Factory(), new ZlibCompression.Factory(), new NoneCompression.Factory()));
            } else {
                configuration.setCompressionFactories(Collections.singletonList(new NoneCompression.Factory()));
            }
            configuration.setVersion(new PreferencesUseragentProvider().get());
            KeepAliveProvider heartbeat = this.preferences.getProperty("ssh.heartbeat.provider").equals("keep-alive") ? KeepAliveProvider.KEEP_ALIVE : KeepAliveProvider.HEARTBEAT;
            configuration.setKeepAliveProvider(heartbeat);
            return this.connect(key, (Config)configuration);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map(e);
        }
    }

    protected SSHClient connect(final HostKeyCallback key, Config configuration) throws IOException {
        SSHClient connection = new SSHClient(configuration);
        int timeout = this.preferences.getInteger("connection.timeout.seconds") * 1000;
        connection.setTimeout(timeout);
        connection.setSocketFactory(this.socketFactory);
        connection.addHostKeyVerifier(new HostKeyVerifier(){

            public boolean verify(String hostname, int port, PublicKey publicKey) {
                try {
                    return key.verify(hostname, port, publicKey);
                }
                catch (ChecksumException | ConnectionCanceledException e) {
                    return false;
                }
            }
        });
        connection.addAlgorithmsVerifier(new AlgorithmsVerifier(){

            public boolean verify(NegotiatedAlgorithms negotiatedAlgorithms) {
                log.info((Object)String.format("Negotiated algorithms %s", negotiatedAlgorithms));
                SFTPSession.this.algorithms = negotiatedAlgorithms;
                return true;
            }
        });
        this.disconnectListener = new StateDisconnectListener();
        Transport transport = connection.getTransport();
        transport.setDisconnectListener((DisconnectListener)this.disconnectListener);
        connection.connect(HostnameConfiguratorFactory.get((Protocol)this.host.getProtocol()).getHostname(this.host.getHostname()), this.host.getPort());
        KeepAlive keepalive = connection.getConnection().getKeepAlive();
        keepalive.setKeepAliveInterval(this.preferences.getInteger("ssh.heartbeat.seconds"));
        return connection;
    }

    public boolean alert(ConnectionCallback prompt) throws BackgroundException {
        if (null == this.algorithms) {
            return super.alert(prompt);
        }
        if (!this.preferences.getBoolean(String.format("ssh.algorithm.whitelist.%s", this.host.getHostname()))) {
            if (this.preferences.getList("ssh.algorithm.cipher.blacklist").contains(this.algorithms.getClient2ServerCipherAlgorithm())) {
                this.alert(prompt, this.algorithms.getClient2ServerCipherAlgorithm());
            }
            if (this.preferences.getList("ssh.algorithm.cipher.blacklist").contains(this.algorithms.getServer2ClientCipherAlgorithm())) {
                this.alert(prompt, this.algorithms.getServer2ClientCipherAlgorithm());
            }
            if (this.preferences.getList("ssh.algorithm.mac.blacklist").contains(this.algorithms.getClient2ServerMACAlgorithm())) {
                this.alert(prompt, this.algorithms.getClient2ServerMACAlgorithm());
            }
            if (this.preferences.getList("ssh.algorithm.mac.blacklist").contains(this.algorithms.getServer2ClientMACAlgorithm())) {
                this.alert(prompt, this.algorithms.getServer2ClientMACAlgorithm());
            }
            if (this.preferences.getList("ssh.algorithm.kex.blacklist").contains(this.algorithms.getKeyExchangeAlgorithm())) {
                this.alert(prompt, this.algorithms.getKeyExchangeAlgorithm());
            }
            if (this.preferences.getList("ssh.algorithm.signature.blacklist").contains(this.algorithms.getSignatureAlgorithm())) {
                this.alert(prompt, this.algorithms.getSignatureAlgorithm());
            }
        }
        return super.alert(prompt);
    }

    private void alert(ConnectionCallback prompt, String algorithm) throws ConnectionCanceledException {
        prompt.warn(this.host, MessageFormat.format(LocaleFactory.localizedString((String)"Insecure algorithm {0} negotiated with server", (String)"Credentials"), algorithm), MessageFormat.format("{0}. {1}.", LocaleFactory.localizedString((String)"The algorithm is possibly too weak to meet current cryptography standards", (String)"Credentials"), LocaleFactory.localizedString((String)"Please contact your web hosting service provider for assistance", (String)"Support")), LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Disconnect", (String)"Credentials"), String.format("ssh.algorithm.whitelist.%s", this.host.getHostname()));
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        String banner;
        ArrayList<Object> methods = new ArrayList<Object>();
        Credentials credentials = this.host.getCredentials();
        if (credentials.isAnonymousLogin()) {
            methods.add(new SFTPNoneAuthentication(this));
        } else {
            if (this.preferences.getBoolean("ssh.authentication.agent.enable")) {
                methods.add(new SFTPAgentAuthentication(this, new OpenSSHAgentAuthenticator()));
                methods.add(new SFTPAgentAuthentication(this, new PageantAuthenticator()));
            }
            methods.add(new SFTPPublicKeyAuthentication(this));
            methods.add(new SFTPChallengeResponseAuthentication(this));
            methods.add(new SFTPPasswordAuthentication(this));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Attempt login with %d authentication methods", methods.size()));
        }
        LoginFailureException lastFailure = null;
        for (AuthenticationProvider authenticationProvider : methods) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Attempt authentication with credentials %s and authentication method %s", credentials, authenticationProvider));
            }
            cancel.verify();
            try {
                if (!((Boolean)authenticationProvider.authenticate(this.host, keychain, prompt, cancel)).booleanValue()) {
                    if (((SSHClient)this.client).getUserAuth().hadPartialSuccess()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Partial login success with credentials %s and authentication method %s", credentials, authenticationProvider));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Login refused with credentials %s and authentication method %s", credentials, authenticationProvider));
                    continue;
                }
            }
            catch (IllegalStateException ignored) {
                log.warn((Object)String.format("Server disconnected with %s while trying authentication method %s", this.disconnectListener.getFailure(), authenticationProvider));
                try {
                    throw new SFTPExceptionMappingService().map(LocaleFactory.localizedString((String)"Login failed", (String)"Credentials"), (Throwable)this.disconnectListener.getFailure());
                }
                catch (InteroperabilityException e) {
                    throw new LoginFailureException(e.getDetail(false), (Throwable)e);
                }
            }
            catch (InteroperabilityException e) {
                throw new LoginFailureException(e.getDetail(false), (Throwable)e);
            }
            catch (LoginFailureException e) {
                log.warn((Object)String.format("Login failed with credentials %s and authentication method %s", credentials, authenticationProvider));
                if (!((SSHClient)this.client).isConnected()) {
                    log.warn((Object)String.format("Server disconnected after failed authentication attempt with method %s", authenticationProvider));
                    throw e;
                }
                lastFailure = e;
                continue;
            }
            if (!log.isInfoEnabled()) break;
            log.info((Object)String.format("Login successful with authentication method %s", authenticationProvider));
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)(banner = ((SSHClient)this.client).getUserAuth().getBanner()))) {
            this.log(TranscriptListener.Type.response, banner);
        }
        if (!((SSHClient)this.client).isAuthenticated()) {
            if (null == lastFailure) {
                throw new LoginFailureException(MessageFormat.format(LocaleFactory.localizedString((String)"Login {0} with username and password", (String)"Credentials"), BookmarkNameProvider.toString((Host)this.host)));
            }
            throw lastFailure;
        }
        try {
            this.sftp = new SFTPEngine((SessionFactory)this.client, String.valueOf('/')){

                public Promise<Response, SFTPException> request(Request req) throws IOException {
                    SFTPSession.this.log(TranscriptListener.Type.request, String.format("%d %s", req.getRequestID(), req.getType()));
                    return super.request(req);
                }
            }.init();
            int n = this.preferences.getInteger("connection.timeout.seconds") * 1000;
            this.sftp.setTimeoutMs(n);
        }
        catch (IOException iOException) {
            throw new SFTPExceptionMappingService().map(iOException);
        }
    }

    public SFTPEngine sftp() throws LoginCanceledException {
        if (null == this.sftp) {
            throw new LoginCanceledException();
        }
        return this.sftp;
    }

    protected void logout() throws BackgroundException {
        try {
            if (null == this.sftp) {
                return;
            }
            this.sftp.close();
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map(e);
        }
    }

    public void disconnect() {
        try {
            ((SSHClient)this.client).close();
        }
        catch (IOException e) {
            log.warn((Object)String.format("Ignore disconnect failure %s", e.getMessage()));
        }
        super.disconnect();
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return new SFTPListService(this).list(directory, listener);
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Find.class) {
            return (T)new SFTPFindFeature(this);
        }
        if (type == Attributes.class) {
            return (T)new SFTPAttributesFinderFeature(this);
        }
        if (type == Read.class) {
            return (T)new SFTPReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new SFTPWriteFeature(this));
        }
        if (type == Directory.class) {
            return (T)new SFTPDirectoryFeature(this);
        }
        if (type == Delete.class) {
            return (T)new SFTPDeleteFeature(this);
        }
        if (type == Move.class) {
            return (T)new SFTPMoveFeature(this);
        }
        if (type == UnixPermission.class) {
            return (T)((Object)new SFTPUnixPermissionFeature(this));
        }
        if (type == Timestamp.class) {
            return (T)((Object)new SFTPTimestampFeature(this));
        }
        if (type == Touch.class) {
            return (T)new SFTPTouchFeature(this);
        }
        if (type == Symlink.class) {
            return (T)new SFTPSymlinkFeature(this);
        }
        if (type == Command.class) {
            return (T)new SFTPCommandFeature(this);
        }
        if (type == Compress.class) {
            return (T)new SFTPCompressFeature(this);
        }
        if (type == DistributionConfiguration.class) {
            return (T)new CustomOriginCloudFrontDistributionConfiguration(this.host);
        }
        if (type == Home.class) {
            return (T)((Object)new SFTPHomeDirectoryService(this));
        }
        if (type == Quota.class) {
            return (T)new SFTPQuotaFeature(this);
        }
        return (T)super._getFeature(type);
    }

    private static final class StateDisconnectListener
    implements DisconnectListener {
        private SSHException failure;

        private StateDisconnectListener() {
        }

        public void notifyDisconnect(DisconnectReason reason, String message) {
            log.warn((Object)String.format("Disconnected %s", reason));
            this.failure = new SSHException(reason, message);
        }

        public SSHException getFailure() {
            return this.failure;
        }
    }
}

