/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import ch.cyberduck.core.sds.io.swagger.client.model.UserGroup;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class UserAccount {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="needsToChangeUserName")
    private Boolean needsToChangeUserName = null;
    @JsonProperty(value="needsToChangePassword")
    private Boolean needsToChangePassword = null;
    @JsonProperty(value="needsToAcceptEULA")
    private Boolean needsToAcceptEULA = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="expireAt")
    private Date expireAt = null;
    @JsonProperty(value="hasManageableRooms")
    private Boolean hasManageableRooms = null;
    @JsonProperty(value="isEncryptionEnabled")
    private Boolean isEncryptionEnabled = null;
    @JsonProperty(value="lastLoginSuccessAt")
    private Date lastLoginSuccessAt = null;
    @JsonProperty(value="lastLoginSuccessIp")
    private String lastLoginSuccessIp = null;
    @JsonProperty(value="lastLoginFailAt")
    private Date lastLoginFailAt = null;
    @JsonProperty(value="lastLoginFailIp")
    private String lastLoginFailIp = null;
    @JsonProperty(value="customer")
    private CustomerData customer = null;
    @JsonProperty(value="userRoles")
    private RoleList userRoles = null;
    @JsonProperty(value="userGroups")
    private List<UserGroup> userGroups = null;
    @JsonProperty(value="userAttributes")
    private UserAttributes userAttributes = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = new ArrayList<UserAuthMethod>();

    public UserAccount id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserAccount login(String login) {
        this.login = login;
        return this;
    }

    @ApiModelProperty(required=true, value="Login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserAccount needsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
        return this;
    }

    @ApiModelProperty(value="User must change the user login name")
    public Boolean getNeedsToChangeUserName() {
        return this.needsToChangeUserName;
    }

    public void setNeedsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
    }

    public UserAccount needsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
        return this;
    }

    @ApiModelProperty(required=true, value="User has changed the password")
    public Boolean getNeedsToChangePassword() {
        return this.needsToChangePassword;
    }

    public void setNeedsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
    }

    public UserAccount needsToAcceptEULA(Boolean needsToAcceptEULA) {
        this.needsToAcceptEULA = needsToAcceptEULA;
        return this;
    }

    @ApiModelProperty(value="User has accepted EULA. Present, if EULA is system global active. See: Get system settings -> eula_active")
    public Boolean getNeedsToAcceptEULA() {
        return this.needsToAcceptEULA;
    }

    public void setNeedsToAcceptEULA(Boolean needsToAcceptEULA) {
        this.needsToAcceptEULA = needsToAcceptEULA;
    }

    public UserAccount title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserAccount firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="First name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserAccount lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="Last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserAccount gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(value="Gender key, one of [m|f|n]")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public UserAccount email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Email [NOT USED]")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserAccount lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="Lock status: 0 - Locked, 1 - Web access allowed, 2 - Web and mobile access allowed")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UserAccount expireAt(Date expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @ApiModelProperty(value="Account expiration date (2015-12-31T23:59:00)")
    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    public UserAccount hasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
        return this;
    }

    @ApiModelProperty(required=true, value="User has manageable rooms")
    public Boolean getHasManageableRooms() {
        return this.hasManageableRooms;
    }

    public void setHasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
    }

    public UserAccount isEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
        return this;
    }

    @ApiModelProperty(value="User has generated private key. Possible if <b>Triple-Crypt&trade; Technology</b> is active for this customer")
    public Boolean getIsEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    public void setIsEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public UserAccount lastLoginSuccessAt(Date lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
        return this;
    }

    @ApiModelProperty(value="Last successful logon date (2015-12-31T23:59:00)")
    public Date getLastLoginSuccessAt() {
        return this.lastLoginSuccessAt;
    }

    public void setLastLoginSuccessAt(Date lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
    }

    public UserAccount lastLoginSuccessIp(String lastLoginSuccessIp) {
        this.lastLoginSuccessIp = lastLoginSuccessIp;
        return this;
    }

    @ApiModelProperty(value="Last successful logon IP address")
    public String getLastLoginSuccessIp() {
        return this.lastLoginSuccessIp;
    }

    public void setLastLoginSuccessIp(String lastLoginSuccessIp) {
        this.lastLoginSuccessIp = lastLoginSuccessIp;
    }

    public UserAccount lastLoginFailAt(Date lastLoginFailAt) {
        this.lastLoginFailAt = lastLoginFailAt;
        return this;
    }

    @ApiModelProperty(value="Last failed logon date (2015-12-31T23:59:00)")
    public Date getLastLoginFailAt() {
        return this.lastLoginFailAt;
    }

    public void setLastLoginFailAt(Date lastLoginFailAt) {
        this.lastLoginFailAt = lastLoginFailAt;
    }

    public UserAccount lastLoginFailIp(String lastLoginFailIp) {
        this.lastLoginFailIp = lastLoginFailIp;
        return this;
    }

    @ApiModelProperty(value="Last failed logon IP address")
    public String getLastLoginFailIp() {
        return this.lastLoginFailIp;
    }

    public void setLastLoginFailIp(String lastLoginFailIp) {
        this.lastLoginFailIp = lastLoginFailIp;
    }

    public UserAccount customer(CustomerData customer) {
        this.customer = customer;
        return this;
    }

    @ApiModelProperty(required=true, value="Customer data")
    public CustomerData getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerData customer) {
        this.customer = customer;
    }

    public UserAccount userRoles(RoleList userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @ApiModelProperty(required=true, value="User assignment roles")
    public RoleList getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(RoleList userRoles) {
        this.userRoles = userRoles;
    }

    public UserAccount userGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    public UserAccount addUserGroupsItem(UserGroup userGroupsItem) {
        if (this.userGroups == null) {
            this.userGroups = new ArrayList<UserGroup>();
        }
        this.userGroups.add(userGroupsItem);
        return this;
    }

    @ApiModelProperty(value="All groups the user is member of.")
    public List<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public UserAccount userAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @ApiModelProperty(value="Custom user attributes; visible if more_info = true")
    public UserAttributes getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }

    public UserAccount authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UserAccount addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Authentication methods")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAccount userAccount = (UserAccount)o;
        return Objects.equals(this.id, userAccount.id) && Objects.equals(this.login, userAccount.login) && Objects.equals(this.needsToChangeUserName, userAccount.needsToChangeUserName) && Objects.equals(this.needsToChangePassword, userAccount.needsToChangePassword) && Objects.equals(this.needsToAcceptEULA, userAccount.needsToAcceptEULA) && Objects.equals(this.title, userAccount.title) && Objects.equals(this.firstName, userAccount.firstName) && Objects.equals(this.lastName, userAccount.lastName) && Objects.equals((Object)this.gender, (Object)userAccount.gender) && Objects.equals(this.email, userAccount.email) && Objects.equals(this.lockStatus, userAccount.lockStatus) && Objects.equals(this.expireAt, userAccount.expireAt) && Objects.equals(this.hasManageableRooms, userAccount.hasManageableRooms) && Objects.equals(this.isEncryptionEnabled, userAccount.isEncryptionEnabled) && Objects.equals(this.lastLoginSuccessAt, userAccount.lastLoginSuccessAt) && Objects.equals(this.lastLoginSuccessIp, userAccount.lastLoginSuccessIp) && Objects.equals(this.lastLoginFailAt, userAccount.lastLoginFailAt) && Objects.equals(this.lastLoginFailIp, userAccount.lastLoginFailIp) && Objects.equals(this.customer, userAccount.customer) && Objects.equals(this.userRoles, userAccount.userRoles) && Objects.equals(this.userGroups, userAccount.userGroups) && Objects.equals(this.userAttributes, userAccount.userAttributes) && Objects.equals(this.authMethods, userAccount.authMethods);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.login, this.needsToChangeUserName, this.needsToChangePassword, this.needsToAcceptEULA, this.title, this.firstName, this.lastName, this.gender, this.email, this.lockStatus, this.expireAt, this.hasManageableRooms, this.isEncryptionEnabled, this.lastLoginSuccessAt, this.lastLoginSuccessIp, this.lastLoginFailAt, this.lastLoginFailIp, this.customer, this.userRoles, this.userGroups, this.userAttributes, this.authMethods});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    needsToChangeUserName: ").append(this.toIndentedString(this.needsToChangeUserName)).append("\n");
        sb.append("    needsToChangePassword: ").append(this.toIndentedString(this.needsToChangePassword)).append("\n");
        sb.append("    needsToAcceptEULA: ").append(this.toIndentedString(this.needsToAcceptEULA)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    hasManageableRooms: ").append(this.toIndentedString(this.hasManageableRooms)).append("\n");
        sb.append("    isEncryptionEnabled: ").append(this.toIndentedString(this.isEncryptionEnabled)).append("\n");
        sb.append("    lastLoginSuccessAt: ").append(this.toIndentedString(this.lastLoginSuccessAt)).append("\n");
        sb.append("    lastLoginSuccessIp: ").append(this.toIndentedString(this.lastLoginSuccessIp)).append("\n");
        sb.append("    lastLoginFailAt: ").append(this.toIndentedString(this.lastLoginFailAt)).append("\n");
        sb.append("    lastLoginFailIp: ").append(this.toIndentedString(this.lastLoginFailIp)).append("\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    userRoles: ").append(this.toIndentedString(this.userRoles)).append("\n");
        sb.append("    userGroups: ").append(this.toIndentedString(this.userGroups)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f"),
        N("n");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

