/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.SharesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateDownloadShareRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateUploadShareRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.DownloadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.UploadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.triplecrypt.CryptoExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.log4j.Logger;

public class SDSSharesUrlProvider
implements PromptUrlProvider<CreateDownloadShareRequest, CreateUploadShareRequest> {
    private static final Logger log = Logger.getLogger(SDSSharesUrlProvider.class);
    private final PathContainerService containerService = new SDSPathContainerService();
    private final SDSSession session;

    public SDSSharesUrlProvider(SDSSession session) {
        this.session = session;
    }

    public DescriptiveUrl toDownloadUrl(Path file, CreateDownloadShareRequest options, PasswordCallback callback) throws BackgroundException {
        try {
            String help;
            DownloadShare share;
            Set roles = (Set)new SDSPermissionsFeature(this.session).getPermission(this.containerService.getContainer(file)).get((Object)new Acl.CanonicalUser(String.valueOf(this.session.userAccount().getId())));
            if (roles != null && !roles.contains(SDSPermissionsFeature.DOWNLOAD_SHARE_ROLE)) {
                return DescriptiveUrl.EMPTY;
            }
            Long fileid = Long.parseLong(new SDSNodeIdProvider(this.session).getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            if (this.containerService.getContainer(file).getType().contains(AbstractPath.Type.vault)) {
                FileKey key = new NodesApi((ApiClient)this.session.getClient()).getUserFileKey("", fileid);
                UserPrivateKey privateKey = new UserPrivateKey();
                UserKeyPairContainer keyPairContainer = this.session.keyPair();
                privateKey.setPrivateKey(keyPairContainer.getPrivateKeyContainer().getPrivateKey());
                privateKey.setVersion(keyPairContainer.getPrivateKeyContainer().getVersion());
                UserKeyPair userKeyPair = new UserKeyPair();
                userKeyPair.setUserPrivateKey(privateKey);
                Credentials passphrase = new TripleCryptKeyPair().unlock(callback, this.session.getHost(), userKeyPair);
                PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)TripleCryptConverter.toCryptoEncryptedFileKey(key), (UserPrivateKey)privateKey, (String)passphrase.getPassword());
                UserKeyPair pair = Crypto.generateUserKeyPair((String)options.getPassword());
                EncryptedFileKey encryptedFileKey = Crypto.encryptFileKey((PlainFileKey)plainFileKey, (UserPublicKey)pair.getUserPublicKey());
                options.setPassword(null);
                options.setKeyPair(TripleCryptConverter.toSwaggerUserKeyPairContainer(pair));
                options.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptedFileKey));
            }
            if (null == (share = new SharesApi((ApiClient)this.session.getClient()).createDownloadShare("", options.nodeId(fileid), null)).getExpireAt()) {
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3"));
            } else {
                Long expiry = share.getExpireAt().getTime();
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(expiry * 1000L));
            }
            return new DescriptiveUrl(URI.create(String.format("%s://%s/#/public/shares-downloads/%s", this.session.getHost().getProtocol().getScheme(), this.session.getHost().getHostname(), share.getAccessKey())), DescriptiveUrl.Type.signed, help);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map(e);
        }
        catch (CryptoException e) {
            throw new CryptoExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, CreateUploadShareRequest options, PasswordCallback callback) throws BackgroundException {
        try {
            String help;
            Set roles = (Set)new SDSPermissionsFeature(this.session).getPermission(this.containerService.getContainer(file)).get((Object)new Acl.CanonicalUser(String.valueOf(this.session.userAccount().getId())));
            if (roles != null && !roles.contains(SDSPermissionsFeature.UPLOAD_SHARE_ROLE)) {
                return DescriptiveUrl.EMPTY;
            }
            UploadShare share = new SharesApi((ApiClient)this.session.getClient()).createUploadShare("", options.targetId(Long.parseLong(new SDSNodeIdProvider(this.session).getFileid(file, (ListProgressListener)new DisabledListProgressListener()))), null);
            if (null == share.getExpireAt()) {
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3"));
            } else {
                Long expiry = share.getExpireAt().getTime();
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(expiry * 1000L));
            }
            return new DescriptiveUrl(URI.create(String.format("%s://%s/#/public/shares-uploads/%s", this.session.getHost().getProtocol().getScheme(), this.session.getHost().getHostname(), share.getAccessKey())), DescriptiveUrl.Type.signed, help);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map(e);
        }
    }
}

