/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UserApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class SDSQuotaFeature
implements Quota {
    private static final Logger log = Logger.getLogger(SDSQuotaFeature.class);
    private final SDSSession session;

    public SDSQuotaFeature(SDSSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        try {
            Path home = new DefaultHomeFinderService((Session)this.session).find();
            if (!home.isRoot()) {
                Node node = new NodesApi((ApiClient)this.session.getClient()).getFsNode("", Long.parseLong(new SDSNodeIdProvider(this.session).getFileid(home, (ListProgressListener)new DisabledListProgressListener())), null);
                if (null == node.getQuota()) {
                    log.warn((Object)String.format("No quota set for node %s", home));
                } else {
                    return new Quota.Space(node.getSize(), Long.valueOf(node.getQuota() - node.getSize()));
                }
            }
            CustomerData info = new UserApi((ApiClient)this.session.getClient()).getCustomerInfo("", null);
            return new Quota.Space(info.getSpaceUsed(), Long.valueOf(info.getSpaceLimit() - info.getSpaceUsed()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        }
    }
}

