/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.NodeList;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SDSNodeIdProvider
implements IdProvider {
    private static final Logger log = Logger.getLogger(SDSNodeIdProvider.class);
    private static final String ROOT_NODE_ID = "0";
    private final SDSSession session;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSNodeIdProvider(SDSSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Return cached node %s for file %s", file.attributes().getVersionId(), file));
            }
            return file.attributes().getVersionId();
        }
        if (file.isRoot()) {
            return ROOT_NODE_ID;
        }
        try {
            String type = file.isDirectory() ? "room:folder" : "file";
            NodeList nodes = new NodesApi((ApiClient)this.session.getClient()).getFsNodes("", null, 0, Long.parseLong(this.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener())), null, String.format("type:eq:%s|name:cn:%s", type, file.getName()), null, null, null);
            for (Node node : nodes.getItems()) {
                if (!node.getName().equals(file.getName())) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Return node %s for file %s", node.getId(), file));
                }
                return node.getId().toString();
            }
            throw new NotfoundException(file.getAbsolute());
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public IdProvider withCache(Cache<Path> cache) {
        return this;
    }
}

