/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.manta.MantaSession;
import com.joyent.manta.client.MantaObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public final class MantaObjectAttributeAdapter {
    private static final Logger log = Logger.getLogger(MantaObjectAttributeAdapter.class);
    private final MantaSession session;
    private static final String HEADER_KEY_STORAGE_CLASS = "Durability-Level";

    public MantaObjectAttributeAdapter(MantaSession session) {
        this.session = session;
    }

    public PathAttributes convert(MantaObject object) {
        String storageClass;
        PathAttributes attributes = new PathAttributes();
        attributes.setPermission(new Permission(this.session.isUserWritable(object) ? Permission.Action.all : Permission.Action.read, Permission.Action.none, this.session.isWorldReadable(object) ? Permission.Action.read : Permission.Action.none));
        if (object.getLastModifiedTime() != null) {
            attributes.setModificationDate(object.getLastModifiedTime().getTime());
        }
        if (object.isDirectory()) {
            return attributes;
        }
        if (this.session.isWorldReadable(object)) {
            String joinedPath = this.session.getHost().getWebURL() + URIEncoder.encode((String)object.getPath());
            try {
                URI link = new URI(joinedPath);
                attributes.setLink(new DescriptiveUrl(link, DescriptiveUrl.Type.http));
            }
            catch (URISyntaxException e) {
                log.warn((Object)String.format("Cannot set link. Web URL returned %s", joinedPath), (Throwable)e);
            }
        }
        attributes.setSize(object.getContentLength().longValue());
        attributes.setETag(object.getEtag());
        byte[] md5Bytes = object.getMd5Bytes();
        if (md5Bytes != null) {
            attributes.setChecksum(new Checksum(HashAlgorithm.md5, Hex.encodeHexString((byte[])md5Bytes)));
        }
        if ((storageClass = object.getHeaderAsString(HEADER_KEY_STORAGE_CLASS)) != null) {
            attributes.setStorageClass(storageClass);
        }
        return attributes;
    }

    public Path toPath(MantaObject object) {
        return new Path(object.getPath(), object.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file));
    }
}

