/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaObjectAttributeAdapter;
import ch.cyberduck.core.manta.MantaSession;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaObjectException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;

public class MantaListService
implements ListService {
    private final MantaSession session;

    public MantaListService(MantaSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        Iterator objectsIter;
        AttributedList children = new AttributedList();
        try {
            objectsIter = ((MantaClient)this.session.getClient()).listObjects(directory.getAbsolute()).iterator();
        }
        catch (MantaObjectException e) {
            throw new MantaExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Listing directory {0} failed", (Throwable)e);
        }
        MantaObjectAttributeAdapter adapter = new MantaObjectAttributeAdapter(this.session);
        while (objectsIter.hasNext()) {
            MantaObject o = (MantaObject)objectsIter.next();
            Path file = new Path(directory, FilenameUtils.getName((String)o.getPath()), EnumSet.of(o.isDirectory() ? AbstractPath.Type.directory : AbstractPath.Type.file), adapter.convert(o));
            children.add((Referenceable)file);
            listener.chunk(directory, children);
        }
        return children;
    }
}

