/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFileClient;

public final class FileRequestOptions
extends RequestOptions {
    private Integer concurrentRequestCount = null;
    private Boolean useTransactionalContentMD5 = null;
    private Boolean storeFileContentMD5 = null;
    private Boolean disableContentMD5Validation = null;

    public FileRequestOptions() {
    }

    public FileRequestOptions(FileRequestOptions other) {
        super(other);
        if (other != null) {
            this.setConcurrentRequestCount(other.getConcurrentRequestCount());
            this.setDisableContentMD5Validation(other.getDisableContentMD5Validation());
            this.setStoreFileContentMD5(other.getStoreFileContentMD5());
            this.setUseTransactionalContentMD5(other.getUseTransactionalContentMD5());
        }
    }

    protected static final FileRequestOptions populateAndApplyDefaults(FileRequestOptions options, CloudFileClient client) {
        return FileRequestOptions.populateAndApplyDefaults(options, client, true);
    }

    protected static final FileRequestOptions populateAndApplyDefaults(FileRequestOptions options, CloudFileClient client, boolean setStartTime) {
        FileRequestOptions modifiedOptions = new FileRequestOptions(options);
        FileRequestOptions.populateRequestOptions(modifiedOptions, client.getDefaultRequestOptions(), setStartTime);
        FileRequestOptions.applyDefaults(modifiedOptions);
        return modifiedOptions;
    }

    protected static void applyDefaults(FileRequestOptions modifiedOptions) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions);
        if (modifiedOptions.getConcurrentRequestCount() == null) {
            modifiedOptions.setConcurrentRequestCount(1);
        }
        if (modifiedOptions.getUseTransactionalContentMD5() == null) {
            modifiedOptions.setUseTransactionalContentMD5(false);
        }
        if (modifiedOptions.getStoreFileContentMD5() == null) {
            modifiedOptions.setStoreFileContentMD5(false);
        }
        if (modifiedOptions.getDisableContentMD5Validation() == null) {
            modifiedOptions.setDisableContentMD5Validation(false);
        }
    }

    private static void populateRequestOptions(FileRequestOptions modifiedOptions, FileRequestOptions clientOptions, boolean setStartTime) {
        RequestOptions.populateRequestOptions(modifiedOptions, clientOptions, setStartTime);
        if (modifiedOptions.getConcurrentRequestCount() == null) {
            modifiedOptions.setConcurrentRequestCount(clientOptions.getConcurrentRequestCount());
        }
    }

    public Integer getConcurrentRequestCount() {
        return this.concurrentRequestCount;
    }

    public Boolean getUseTransactionalContentMD5() {
        return this.useTransactionalContentMD5;
    }

    public Boolean getStoreFileContentMD5() {
        return this.storeFileContentMD5;
    }

    public Boolean getDisableContentMD5Validation() {
        return this.disableContentMD5Validation;
    }

    public void setConcurrentRequestCount(Integer concurrentRequestCount) {
        this.concurrentRequestCount = concurrentRequestCount;
    }

    public void setUseTransactionalContentMD5(Boolean useTransactionalContentMD5) {
        this.useTransactionalContentMD5 = useTransactionalContentMD5;
    }

    public void setStoreFileContentMD5(Boolean storeFileContentMD5) {
        this.storeFileContentMD5 = storeFileContentMD5;
    }

    public void setDisableContentMD5Validation(Boolean disableContentMD5Validation) {
        this.disableContentMD5Validation = disableContentMD5Validation;
    }

    @Override
    public final void setLocationMode(LocationMode locationMode) {
        if (locationMode != null && !locationMode.equals((Object)LocationMode.PRIMARY_ONLY)) {
            throw new UnsupportedOperationException("This operation can only be executed against the primary storage location.");
        }
        super.setLocationMode(locationMode);
    }

    @Override
    public void setRequireEncryption(Boolean requireEncryption) {
        if (requireEncryption != null && requireEncryption.booleanValue()) {
            throw new UnsupportedOperationException("Encryption is not supported for files.");
        }
    }
}

