/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.list;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPParserSelector;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.ftp.list.FTPDefaultListService;
import ch.cyberduck.core.ftp.list.FTPInvalidListException;
import ch.cyberduck.core.ftp.list.FTPMlsdListService;
import ch.cyberduck.core.ftp.list.FTPStatListService;
import ch.cyberduck.core.ftp.parser.CompositeFileEntryParser;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.log4j.Logger;

public class FTPListService
implements ListService {
    private static final Logger log = Logger.getLogger(FTPListService.class);
    private final FTPSession session;
    protected final Map<Command, ListService> implementations = new HashMap<Command, ListService>();

    public FTPListService(FTPSession session, String system, TimeZone zone) {
        this(session, (HostPasswordStore)new DisabledPasswordStore(), (LoginCallback)new DisabledLoginCallback(), system, zone);
    }

    public FTPListService(FTPSession session, HostPasswordStore keychain, LoginCallback prompt, String system, TimeZone zone) {
        this.session = session;
        CompositeFileEntryParser parser = new FTPParserSelector().getParser(system, zone);
        this.implementations.put(Command.list, new FTPDefaultListService(session, keychain, prompt, parser, Command.list));
        if (PreferencesFactory.get().getBoolean("ftp.command.stat")) {
            if (StringUtils.isNotBlank((CharSequence)system)) {
                if (!system.toUpperCase(Locale.ROOT).contains("WINDOWS")) {
                    this.implementations.put(Command.stat, new FTPStatListService(session, (FTPFileEntryParser)parser));
                }
            } else {
                this.implementations.put(Command.stat, new FTPStatListService(session, (FTPFileEntryParser)parser));
            }
        }
        if (PreferencesFactory.get().getBoolean("ftp.command.mlsd")) {
            this.implementations.put(Command.mlsd, new FTPMlsdListService(session, keychain, prompt));
        }
        if (PreferencesFactory.get().getBoolean("ftp.command.lista")) {
            this.implementations.put(Command.lista, new FTPDefaultListService(session, keychain, prompt, parser, Command.lista));
        }
    }

    protected void remove(Command command) {
        log.warn((Object)String.format("Remove %s from listing strategies", new Object[]{command}));
        this.implementations.remove((Object)command);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            if (this.implementations.containsKey((Object)Command.mlsd)) {
                if (((FTPClient)((Object)this.session.getClient())).hasFeature(FTPCmd.MLST.getCommand())) {
                    try {
                        return this.post(directory, (AttributedList<Path>)this.implementations.get((Object)Command.mlsd).list(directory, listener), listener);
                    }
                    catch (InteroperabilityException | FTPInvalidListException e) {
                        this.remove(Command.mlsd);
                    }
                } else {
                    this.remove(Command.mlsd);
                }
            }
            if (this.implementations.containsKey((Object)Command.stat)) {
                try {
                    return this.post(directory, (AttributedList<Path>)this.implementations.get((Object)Command.stat).list(directory, listener), listener);
                }
                catch (AccessDeniedException | InteroperabilityException | NotfoundException | FTPInvalidListException e) {
                    this.remove(Command.stat);
                }
            }
            if (this.implementations.containsKey((Object)Command.lista)) {
                try {
                    return this.post(directory, (AttributedList<Path>)this.implementations.get((Object)Command.lista).list(directory, listener), listener);
                }
                catch (InteroperabilityException e) {
                    this.remove(Command.lista);
                }
                catch (FTPInvalidListException e) {
                    // empty catch block
                }
            }
            try {
                return this.post(directory, (AttributedList<Path>)this.implementations.get((Object)Command.list).list(directory, listener), listener);
            }
            catch (FTPInvalidListException f) {
                return this.post(directory, f.getParsed(), listener);
            }
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    protected AttributedList<Path> post(Path directory, AttributedList<Path> list, ListProgressListener listener) throws BackgroundException {
        try {
            ArrayList<Path> verified = new ArrayList<Path>();
            HashSet<Path> removal = new HashSet<Path>();
            for (Path file : list) {
                if (!file.isSymbolicLink()) continue;
                Path target = file.getSymlinkTarget();
                if (((FTPClient)((Object)this.session.getClient())).changeWorkingDirectory(file.getAbsolute())) {
                    file.setType(EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.symboliclink));
                    target.setType(EnumSet.of(AbstractPath.Type.directory));
                } else if (((FTPClient)((Object)this.session.getClient())).changeWorkingDirectory(target.getAbsolute())) {
                    file.setType(EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.symboliclink));
                    target.setType(EnumSet.of(AbstractPath.Type.directory));
                } else {
                    file.setType(EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.symboliclink));
                    target.setType(EnumSet.of(AbstractPath.Type.file));
                }
                if (!verified.add(file)) continue;
                removal.add(file);
            }
            list.removeAll(removal);
            list.addAll(verified);
            listener.chunk(directory, list);
            return list;
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    public static enum Command {
        stat(FTPCmd.STAT),
        mlsd(FTPCmd.MLSD),
        list(FTPCmd.LIST),
        lista(FTPCmd.LIST, "-a");

        private final FTPCmd command;
        private final String arg;

        private Command(FTPCmd command) {
            this(command, null);
        }

        private Command(FTPCmd command, String arg) {
            this.command = command;
            this.arg = arg;
        }

        public FTPCmd getCommand() {
            return this.command;
        }

        public String getArg() {
            return this.arg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Command{");
            sb.append("command=").append(this.command);
            sb.append(", arg='").append(this.arg).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

