/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.handler.ContainerInfoResponseHandler;
import ch.iterate.openstack.swift.model.CDNContainer;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CdnContainerInfoListHandler
implements ResponseHandler<List<CDNContainer>> {
    private static final Logger logger = Logger.getLogger(ContainerInfoResponseHandler.class.getName());
    private Region region;

    public CdnContainerInfoListHandler(Region region) {
        this.region = region;
    }

    public List<CDNContainer> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(response.getEntity().getContent());
                NodeList nodes = document.getChildNodes();
                Node accountNode = nodes.item(0);
                if (!"account".equals(accountNode.getNodeName())) {
                    throw new GenericException("Unexpected node name", response.getAllHeaders(), response.getStatusLine());
                }
                ArrayList<CDNContainer> list = new ArrayList<CDNContainer>();
                NodeList containerNodes = accountNode.getChildNodes();
                for (int i = 0; i < containerNodes.getLength(); ++i) {
                    Node containerNode = containerNodes.item(i);
                    if (!"container".equals(containerNode.getNodeName())) continue;
                    CDNContainer container = new CDNContainer(this.region);
                    NodeList objectData = containerNode.getChildNodes();
                    for (int j = 0; j < objectData.getLength(); ++j) {
                        Node data = objectData.item(j);
                        if ("name".equals(data.getNodeName())) {
                            container.setName(data.getTextContent());
                            continue;
                        }
                        if ("cdn_url".equals(data.getNodeName())) {
                            container.setCdnURL(data.getTextContent());
                            continue;
                        }
                        if ("cdn_ssl_url".equals(data.getNodeName())) {
                            container.setSslURL(data.getTextContent());
                            continue;
                        }
                        if ("cdn_streaming_url".equals(data.getNodeName())) {
                            container.setStreamingURL(data.getTextContent());
                            continue;
                        }
                        if ("cdn_ios_url".equals(data.getNodeName())) {
                            container.setiOSStreamingURL(data.getTextContent());
                            continue;
                        }
                        if ("cdn_enabled".equals(data.getNodeName())) {
                            container.setEnabled(Boolean.parseBoolean(data.getTextContent()));
                            continue;
                        }
                        if ("log_retention".equals(data.getNodeName())) {
                            container.setRetainLogs(Boolean.parseBoolean(data.getTextContent()));
                            continue;
                        }
                        if ("ttl".equals(data.getNodeName())) {
                            container.setTtl(Integer.parseInt(data.getTextContent()));
                            continue;
                        }
                        if ("referrer_acl".equals(data.getNodeName())) {
                            container.setReferrerACL(data.getTextContent());
                            continue;
                        }
                        if ("useragent_acl".equals(data.getNodeName())) {
                            container.setUserAgentACL(data.getTextContent());
                            continue;
                        }
                        logger.warning(String.format("Unexpected node name %s", data.getNodeName()));
                    }
                    if (container.getName() == null) continue;
                    list.add(container);
                }
                return list;
            }
            catch (ParserConfigurationException e) {
                throw new GenericException("Parser configuration failure", e);
            }
            catch (SAXException e) {
                throw new GenericException("Error parsing XML server response", e);
            }
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }
}

