#!/bin/sh -p
dtrace=/usr/sbin/dtrace

############################################################################
# ASSERTION:
#	To verify that a binary launched with dtrace -c with -xevaltime=exec
#	(which starts tracing after intiializers are run)
#	is controlled and can start tracing correctly initializers.

# NOTE:
# We run this with '-Z', because at the time of evaluation, only
# dyld is loaded.


script()
{
	$dtrace -xnolibs -Z -c ./tst.has_initializers.exe -xevaltime=exec -qs /dev/stdin <<EOF
	pid\$target::function_called_by_initializer:entry
	{
		trace("Called");
		exit(0);
	}
	pid\$target::main_binary_function:entry
	{
		trace("Library initializer not called or called after main");
		exit(1);
	}

EOF
}


script | tee /dev/fd/2 | grep 'Called'
status=$?

exit $status
