.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "funfilters n"
.TH funfilters n "April 14, 2011" "version 1.4.5" "SAORD Documentation"
.SH "NAME"
\&\fBFunfilters: Filtering Rows in a Table\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document contains a summary of the user interface for 
filtering rows in binary tables.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Table filtering allows a program to select rows from an table (e.g.,
X\-ray event list) by checking each row against one or more expressions
involving the columns in the table. When a table is filtered, only
valid rows satisfying these expressions are passed through for processing.
.PP
A filter expression is specified using bracket notation appended to
the filename of the data being processed:
.PP
.Vb 1
\&  foo.fits[pha==1&&pi==2]
.Ve
.PP
It is also possible to put region specification inside a file and
then pass the filename in bracket notation:
.PP
.Vb 1
\&  foo.fits[@my.reg]
.Ve
.PP
Filters must be placed after the extension and image section
information, when such information is present. The correct order is:
.IP "\(bu" 4
file[fileinfo,sectioninfo][filters]
.IP "\(bu" 4
file[fileinfo,sectioninfo,filters]
.PP
where:
.IP "\(bu" 4
\&\fBfile\fR is the Funtools file name
.IP "\(bu" 4
\&\fBfileinfo\fR is an \s-1ARRAY\s0, \s-1EVENT\s0, \s-1FITS\s0 extension, or \s-1FITS\s0 index
.IP "\(bu" 4
\&\fBsectioninfo\fR is the image section to extract
.IP "\(bu" 4
\&\fBfilters\fR are spatial region and table (row) filters to apply
.PP
See Funtools Files for more information
on file and image section specifications.
.PP
\&\fBFilter Expressions\fR
.PP
Table filtering can be performed on columns of data in a \s-1FITS\s0
binary table or a raw event file.  Table filtering is accomplished by
means of \fBtable filter specifications\fR.  An table filter
specification consists of one or more \fBfilter expressions\fR Filter
specifications also can contain comments and local/global processing
directives.
.PP
More specifically, a filter specification consist of one or more lines
containing:
.PP
.Vb 13
\&  # comment until end of line
\&  # include the following file in the table descriptor
\&  @file
\&  # each row expression can contain filters separated by operators
\&  [filter_expression] BOOLOP [filter_expression2], ...
\&  # each row expression can contain filters separated by the comma operator
\&  [filter_expression1], [filter_expression2], ...
\&  # the special row# keyword allows a range of rows to be processed
\&  row#=m:n
\&  # or a single row
\&  row#=m
\&  # regions are supported -- but are described elsewhere
\&  [spatial_region_expression]
.Ve
.PP
A single filter expression consists of an arithmetic, logical, or
other operations involving one or more column values from a
table. Columns can be compared to other columns, to header values,
or to numeric constants. Standard math functions can be applied to
columns. Separate filter expressions can be combined using boolean operators.
Standard C semantics can be used when constructing expressions, with
the usual precedence and associativity rules holding sway:
.PP
.Vb 15
\&  Operator                                Associativity
\&  --------                                -------------
\&  ()                                      left to right
\&  !! (logical not)                        right to left
\&  !  (bitwise not) - (unary minus)        right to left
\&  *  /                                    left to right
\&  +  -                                    left to right
\&  < <= > >=                               left to right
\&  == !=                                   left to right
\&  &  (bitwise and)                        left to right
\&  ^  (bitwise exclusive or)               left to right
\&  |  (bitwise inclusive or)               left to right
\&  && (logical and)                        left to right
\&  || (logical or)                         left to right
\&  =                                       right to left
.Ve
.PP
For example, if energy and pha are columns in a table, 
then the following are valid expressions:
.PP
.Vb 4
\&  pha>1
\&  energy == pha
\&  (pha>1) && (energy<=2)
\&  max(pha,energy)>=2.5
.Ve
.PP
Comparison values can be integers or floats. Integer comparison values can be
specified in decimal, octal (using '0' as prefix), hex (using '0x' as prefix)
or binary (using '0b' as prefix). Thus, the following all specify the same
comparison test of a status mask:
.PP
.Vb 4
\&  (status & 15) == 8           # decimal
\&  (status & 017) == 010        # octal
\&  (status & 0xf) == 0x8        # hex
\&  (status & 0b1111) == 0b1000  # binary
.Ve
.PP
The special keyword row# allows you to process a range of rows.
When row# is specified, the filter code skips to the designated
row  and only processes the specified number of rows. The
\&\*(L"*\*(R" character can be utilized as the high limit value to denote
processing of the remaining rows. Thus:
.PP
.Vb 1
\&  row#=100:109
.Ve
.PP
processes 10 rows, starting with row 100 (counting from 1),
while:
.PP
.Vb 1
\&  row#=100:*
.Ve
.PP
specifies that all but the first 99 rows are to be processed.
.PP
Spatial region filtering allows a program to select regions of an
image or rows of a table (e.g., X\-ray events) using simple geometric
shapes and boolean combinations of shapes.  For a complete description
of regions, see Spatial Region Filtering.
.PP
\&\fBSeparators Also Are Operators\fR
.PP
As mentioned previously, multiple filter expressions can be specified
in a filter descriptor, separated by commas or new\-lines.
When such a comma or new-line separator is used, the boolean \s-1AND\s0 operator
is automatically generated in its place. Thus and expression such as:
.PP
.Vb 1
\&  pha==1,pi=2:4
.Ve
.PP
is equivalent to:
.PP
.Vb 1
\&  (pha==1) && (pi>=2&&pi<=4)
.Ve
.PP
[Note that the behavior of separators is different for filter expressions
and spatial region expressions.  The former uses \s-1AND\s0 as the operator, while
the latter user \s-1OR\s0. See
Combining Region and Table Filters
for more information about these conventions and how they are treated
when combined.]
.PP
\&\fBRange Lists\fR 
.PP
Aside from the standard C syntax, filter expressions can make use of
IRAF-style \fBrange lists\fR which specify a range of values. The
syntax requires that the column name be followed by an '=' sign, which
is followed by one or more comma-delimited range expressions of the form:
.PP
.Vb 4
\&  col = vv              # col == vv in range
\&  col = :vv             # col <= vv in range
\&  col = vv:             # col >= vv in range
\&  col = vv1:vv2         # vv1 <= col <= vv2 in range
.Ve
.PP
The vv's above must be numeric constants; the right hand side of a
range list cannot contain a column name or header value.
.PP
Note that, unlike an ordinary comma separator, the comma separator used
between two or more range expressions denotes \s-1OR\s0.  Thus, when two or
more range expressions are combined with a comma separator, the resulting
expression is a shortcut for more complicated boolean logic. For example:
.PP
.Vb 1
\&  col = :3,6:8,10:
.Ve
.PP
is equivalent to:
.PP
.Vb 1
\&  (col=6 && col =10)
.Ve
.PP
Note also that the single-valued rangelist:
.PP
.Vb 1
\&  col = val
.Ve
.PP
is equivalent to the C\-based filter expression:
.PP
.Vb 1
\&  col == val
.Ve
.PP
assuming, of course, that val is a numeric constant.
.PP
\&\fBMath Operations and Functions\fR 
.PP
It is permissible to specify C math functions as part of the filter syntax.
When the filter parser recognizes a function call, it automatically
includes the math.h and links in the C math library.  Thus, it is
possible to filter rows by expressions such as these:
.IP "\(bu" 4
(pi+pha)>(2+log(pi)\-pha)
.IP "\(bu" 4
min(pi,pha)*14>x
.IP "\(bu" 4
max(pi,pha)==(pi+1)
.IP "\(bu" 4
feq(pi,pha)
.IP "\(bu" 4
div(pi,pha)>0
.PP
The function feq(a,b) returns true (1) if the difference between a and b
(taken as double precision values) is less than approximately 10E\-15.
The function div(a,b) divides a by b, but returns NaN (not a number)
if b is 0. It is a safe way to avoid floating point errors when
dividing one column by another.
.PP
\&\fBInclude Files\fR 
.PP
The special \fB@filename\fR directive specifies an include file
containing filter expressions. This file is processed as part of
the overall filter descriptor:
.PP
.Vb 1
\&  foo.fits[pha==1,@foo]
.Ve
.PP
\&\fBHeader Parameters\fR 
.PP
The filter syntax supports comparison between a column value and a
header parameter value of a \s-1FITS\s0 binary tables (raw event files have no
such header).  The header parameters can be taken from the binary
table header or the primary header.  For example, assuming there is a
header value \s-1MEAN_PHA\s0 in one of these headers, you can select photons
having exactly this value using:
.IP "\(bu" 4
pha==MEAN_PHA
.PP
Table filtering is more easily described by means of examples.
Consider data containing the following table structure:
.IP "\(bu" 4
double \s-1TIME\s0
.IP "\(bu" 4
int X
.IP "\(bu" 4
int Y
.IP "\(bu" 4
short \s-1PI\s0
.IP "\(bu" 4
short \s-1PHA\s0
.IP "\(bu" 4
int \s-1DX\s0
.IP "\(bu" 4
int \s-1DY\s0
.PP
Tables can be filtered on these columns using \s-1IRAF/QPOE\s0 range syntax or
any valid C syntax.  The following examples illustrate the possibilities:
.IP "\(bu" 4
pha=10
.IP "\(bu" 4
pha==10
.Sp
select rows whose pha value is exactly 10
.IP "\(bu" 4
pha=10:50
.Sp
select rows whose pha value is in the range of 10 to 50
.IP "\(bu" 4
pha=10:50,100
.Sp
select rows whose pha value is in the range of 10 to 50 or is
equal to 100
.IP "\(bu" 4
pha>=10 && pha<=50
.Sp
select rows whose pha value is in the range of 10 to 50
.IP "\(bu" 4
pi=1,2&&pha>3
.Sp
select rows whose pha value is 1 or 2 and whose pi value is 3
.IP "\(bu" 4
pi=1,2 || pha>3
.Sp
select rows whose pha value is 1 or 2 or whose pi value is 3
.IP "\(bu" 4
pha==pi+1
.Sp
select rows whose pha value is 1 less than the pi value
.IP "\(bu" 4
(pha==pi+1) && (time>50000.0)
.Sp
select rows whose pha value is 1 less than the pi value
and whose time value is greater than 50000
.IP "\(bu" 4
(pi+pha)>20
.Sp
select rows in which the sum of the pi and pha values is greater
than 20
.IP "\(bu" 4
pi%2==1
.Sp
select rows in which the pi value is odd
.PP
Currently, integer range list limits cannot be specified in binary
notation (use decimal, hex, or octal instead). Please contact us if
this is a problem.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
