#include <iostream>
using namespace std;

#include <fstream>

#include <stdio.h>
#include <limits.h>
#include <math.h>
 
int lsb()
{
  return (*(short *)"\001\000" & 0x0001);
}

void swap2(char* src, char* dest) {
  *(dest  ) = *(src+1);
  *(dest+1) = *(src  );
}

void swap4(char* src, char* dest) {
  *(dest  ) = *(src+3);
  *(dest+1) = *(src+2);
  *(dest+2) = *(src+1);
  *(dest+3) = *(src  );
}

void swap8(char* src, char* dest) {
  *(dest  ) = *(src+7);
  *(dest+1) = *(src+6);
  *(dest+2) = *(src+5);
  *(dest+3) = *(src+4);
  *(dest+4) = *(src+3);
  *(dest+5) = *(src+2);
  *(dest+6) = *(src+1);
  *(dest+7) = *(src  );
}

int main(int argc, char **argv)
{
  if(argc<7){
    cerr << "usage: " << argv[0] << " outfile width height depth bitpix endian" << endl;
    exit(1);
  }

  FILE* out = fopen(argv[1],"w");
  int ww = atoi(argv[2]);
  int hh = atoi(argv[3]);
  int dd = atoi(argv[4]);
  int bitpix = atoi(argv[5]);
  int endian =0;
  if (!strncmp(argv[6],"big",3))
    endian =1;
  int ss = abs(bitpix)/8;
  char row[ww*ss];

  // create sample row
  switch (bitpix) {
  case 8:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  unsigned char vv = kk+jj+ii;
	  memcpy(row+ii,&vv,1);
	}

	fwrite(row,ww,1,out);
      }
    }
    break;
  case 16:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  short vv = kk+jj+ii;

	  if ((lsb() && endian) || (!lsb() && !endian))
	    swap2((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case -16:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  unsigned short vv = kk+jj+ii;

	  if ((lsb() && endian) || (!lsb() && !endian))
	    swap2((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case 32:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  int vv = kk+jj+ii;

	  if ((lsb() && endian) || (!lsb() && !endian))
	    swap4((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case -32:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  float vv = kk+jj+ii;

	  if ((lsb() && endian) || (!lsb() && !endian))
	    swap4((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case 64:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  long long vv = kk+jj+ii;

	  if ((lsb() && endian) || (!lsb() && !endian))
	    swap8((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case -64:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  double vv = kk+jj+ii;

	  if ((lsb() && endian) || (!lsb() && !endian))
	    swap8((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  }

  // done
  fclose(out);
}
