#if __GNUC__ >= 3
#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;
#else
#include <iostream.h>
#include <strstream.h>
#include <iomanip.h>
#endif

#include <limits.h>
#include <float.h>

#include "mmap.h"

void dumpit(char*);

int main(int argc, char* argv[])
{
  int count = 0;
  cout << argv[1] << endl;

  switch (argc) {
  case 3:
    {
      FitsMMap fits(argv[1]);
      if (fits.isValid()) {
	char* here = fits.mapdata();
	int size = fits.mapsize();

	FitsHead* head = NULL;
	do {
	  head = new FitsHead(here, size, FitsHead::EXTERNAL);
	  if (head->isValid()) {
	    char* nm = head->find("EXTNAME");
	    if (nm)
	      cout << ".." << head->getString("EXTNAME") << endl;

	    char* card = head->find(argv[2]);
	    if (card)
	      dumpit(card);

	    here += head->headbytes() + head->databytes();
	    size -= head->headbytes() + head->databytes();
	    count++;
	  }
	} while (head && head->isValid());
      }
      else {
	cout << "Unable to load " << argv[1] << endl;
	return 1;
      }
    }
    break;

  case 5:
    {
      FitsMMap fits(argv[1]);
      if (fits.isValid()) {
	char* here = fits.mapdata();
	int size = fits.mapsize();

	FitsHead* head = NULL;
	do {
	  head = new FitsHead(here, size, FitsHead::EXTERNAL);
	  if (head->isValid()) {
	    char* nm = head->find("EXTNAME");
	    if (nm)
	      cout << ".." << head->getString("EXTNAME") << endl;

	    char* card = head->find(argv[2]);
	    if (card) {
	      switch (argv[3][0]) {
		case 'i':
		  {
#if __GNUC__ >= 3
		    string x(argv[4]);
		    istringstream str(x);
#else
		    istrstream str(argv[4]);
#endif
		    int v;
		    str >> v;
		    if (head->getInteger(argv[2],INT_MAX) == v)
		      dumpit(card);
		  }
		  break;
		case 'r':
		  {
#if __GNUC__ >= 3
		    string x(argv[4]);
		    istringstream str(x);
#else
		    istrstream str(argv[4]);
#endif
		    float v;
		    str >> v;
		    if (head->getReal(argv[2],FLT_MAX) == v)
		      dumpit(card);
		  }
		  break;
		case 's':
		  {
		    char* r = head->getString(argv[2]);
		    if (r && !strncmp(r,argv[4],strlen(argv[4])))
		      dumpit(card);
		    delete r;
		  }		
		  break;
	      }
	    }

	    here += head->headbytes() + head->databytes();
	    size -= head->headbytes() + head->databytes();
	    count++;
	  }
	} while (head && head->isValid());
      }
      else {
	cout << "Unable to load " << argv[1] << endl;
	return 1;
      }
    }
    break;

  default:
    cerr << "Usage: " << argv[0] 
	 << " <filename> <keyword> [[i|r|s] <value>]" << endl;
    return 1;
  }

  //  cout << "Number of Headers Searched: " << count << endl;
  return 0;
}

void dumpit(char* card)
{
  char buf[81];
  strncpy(buf,card,80);
  buf[80] = '\0';
  cout << buf << endl;
}
