.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "funview n"
.TH funview n "April 14, 2011" "version 1.4.5" "SAORD Documentation"
.SH "NAME"
\&\fBFunview: Database View Support for Tables\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document contains a summary of the options for utilizing
database-inspired Views of tables.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBDatabase Views\fR
.PP
In database parlance, a \fBView\fR defines a \*(L"virtual table\*(R", i.e.,
a description of row and/or column selection filters (but with no
permanent storage space allocated). When used in place of a table, a
View selects the specified rows and/or columns from one or more real
tables. Views enable you to see complicated data tables in a more
convenient format. They also can be used as a security mechanism, by
restricting user access to specific columns and/or rows.  [See:
.PP
http://www.cs.unibo.it/~ciaccia/COURSES/RESOURCES/SQLTutorial/sqlch5.htm
.PP
for a good discussion of \s-1SQL\s0 Views.]
.PP
Funtools supports an expanded notion of Views for all tabular data
(\s-1FITS\s0 tables, raw binary tables, and \s-1ASCII\s0 column files). Funtools
Views allow you to pre-set values for the filter specification, the
columns to activate, and display format (though the latter is for
fundisp only).  Setting the filter and column activation values
provides functionality equivalent to that of a classical database
View, while the ability to set the format is similar to classical
report writing capabilities.
.PP
\&\fBFuntools View Attributes\fR
.PP
A Funtools View is a text file containing one or more of the following
columns:
.PP
.Vb 7
\&  column         description
\&  ------         -----------------------------
\&  view           name of view
\&  file           data file name or template
\&  filter         filter specification
\&  columns        columns to activate
\&  format         fundisp format specification
.Ve
.PP
All of the attribute columns are optional, including
the \fBview\fR name itself. This means that a View can be named or
unnamed. Unnamed Views can refer to a specific file or a template of
files (obviously if neither the view or the file column is specified,
the input View specification will never be used). You can specify any
combination of filter, column, and format parameters. (It also is
possible to apply file-specific View to other files; see the discussion
on \fBView Lists\fR below). Each column has a size limit of 1024 characters.
.PP
For example, consider the following View file:
.PP
.Vb 13
\&  view    file                    format  columns       filter
\&  ----    ----------------------  ------  ------------  -------
\&  x3      ${HOME}/data/snr.ev     I=%4d   x y pi pha    cir 512 512 .1 
\&  x2      ${HOME}/data/snr.ev             x y pi pha    cir 512 512 .1 
\&  x1      ${HOME}/data/snr.ev                           cir 512 512 .1 
\&  x1a     ${HOME}/data/snr.ev             x y pi pha
\&  x0      ${HOME}/data/snr.ev
\&  xf                              I=%4d
\&  xc                                      x y pi pha
\&  xr                                                    cir 512 512 .1
\&          *.ev                            x y pi pha
\&          *.fit                           x y dx dy     cir 400 400  3
\&          *.fits                  I=%3d   x y dx dy     cir 400 400  3
.Ve
.PP
This database example is in rdb format, i.e. using tab delimiters and
permitting null values. Any valid \s-1ASCII\s0 table format is acceptable,
but if you use a format that does not permit null values, it will be
necessary to quote the null strings.
.PP
The first five entries (x3, x2, x1, x1a, x0) are named entries defining
default values specifically for the snr.ev data file. Typically, you
would use these Views by specifying View name, and the corresponding
file, filter, column, and format values would be used. Note that the x0
View is essentially an alias for the pathname of this file.
.PP
The next three entries define defaults that can be applied to any
file.  You typically would use these View names in conjunction with
a specific file name (see \fBView Lists\fR below) so that the associated
parameter(s) were applied to that file.
.PP
The last three entry in the database define unnamed Views that
pertains to all files ending with the specified templates. In these
cases, any View that specifies a file name matching the file template
would be processed with the associated parameter attributes.
.PP
\&\fBInvoking a Funtools View (in Place of an Input File)\fR
.PP
To use a Funtools View, you simply pre-pend the \*(L"v:\*(R" prefix to a View name or
a file name where an input file name usually is specified. For example:
.PP
.Vb 1
\&  fundisp v:x3
.Ve
.PP
specifies that the View named x3 (with its file name and associated
parameters) is processed as the input file to fundisp. Using the
example database, above, this is equivalent to:
.PP
.Vb 1
\&  fundisp  -f "I=%4d" ${HOME}/data/snr.ev'[cir 512 512 .1]'  "x y pi pha"
.Ve
.PP
That is, the format is used with fundisp's \-f (format) switch, while the
filename and extension are composed of the x3 View's filename and
region filter.
.PP
Similarly, executing a command such as:
.PP
.Vb 1
\&  fundisp v:foo.fit
.Ve
.PP
will match the unnamed View associated with the template \*(L"*.fit\*(R".
This is equivalent to executing:
.PP
.Vb 1
\&  fundisp foo.fit'[cir 400 400 3]' "x y dx dy"
.Ve
.PP
Of course, if you omit the \*(L"v:\*(R" prefix, then no View processing takes place:
.PP
.Vb 2
\&  fundisp foo.fit    # process foo.fit without any View parameters
\&  fundisp x3         # error (assuming there is no file named x3)
.Ve
.PP
\&\fBBasic View Matching Rules\fR
.PP
When a \*(L"v:\*(R" prefix is recognized, Funtools searches for a View database
file in the following order:
.PP
.Vb 5
\&  location             description
\&  ------------         ------------------------------------
\&  FUN_VIEWFILE         environment variable (any file name)
\&  ./.funtools.vu       hidden file, default name
\&  $HOME/.funtools.vu   hidden file, default name
.Ve
.PP
The first View database file located is used to construct a new
filename, as well as an activation column specification and a format
specification. The following rules are used:
.PP
1. An attempt is made to match the input name (i.e., the part of the
input View after the \*(L"v:\*(R" prefix) against the \fBview\fR column value
(if present) of each row in the database. If a match is found, the
values of all non-blank columns are saved for later use.  Also note
that the first match terminates the search: i.e., the order of the
database rows matters.
.PP
2. If no \fBview\fR match is made, an attempt is made to match the input
name against the \fBfile\fR column value (if present). Matching is
performed on the full pathname of both the input name and the
database file name, and on the non-directory (root) part of these
files. This means that the root specification:
.PP
.Vb 1
\&  fundisp v:snr.ev
.Ve
.PP
will match a row in the database that has a full pathname in the file,
allowing you to use a \fBfile\fR\-matched View without having to
specify the full pathname. In this example, the \*(L"v:snr.ev\*(R" View
specification will match the first row (v:x3) in the database:
.PP
.Vb 1
\&  x3   ${HOME}/data/snr.ev     I=%4d   x y pi pha    cir 512 512 .1
.Ve
.PP
even though the row contains a fully qualified pathname as the file
value. Once again, values of all non-blank columns are saved, and the
first match terminates the search.
.PP
3. If neither a \fBview\fR or a \fBview\fR match has been found,
then a simple template match is attempted against the \fBview\fR
values. Template matching supports a simplified version of file
globbing (not a regular expression), with support for a single \*(L"*\*(R"
(all characters), \*(L"?\*(R" (single character), or \*(L"[...]\*(R" (range) specification.
.PP
4. If no template match was found on the \fBview\fR column, then a
simple template match is attempted against the \fBfile\fR columns.
.PP
5. If no match is found, then the filename (minus the \*(L"v:\*(R" prefix) is 
returned.
.PP
\&\fBMore on View Matching Rules: Single vs. Multiple Matches \fR
.PP
The matching rules described above stop after the first match,
regardless of whether that match provides values for all three
parameters (filter, columns, and format). In cases where a \fBview\fR
or \fBfile\fR match does not provide all three values, it is possible
that a template match might do so. With regard to the example View
database above, the x1 View provides only a filter, while omitting
both the format and columns values. But note that the final rows in
the database could provide the values via a template match on the
filename. This sort of multiple matching is especially valuable in
order to provide \*(L"global\*(R" values to several Views.
.PP
Obviously, multiple matching might not be wanted in every
case. Therefore, we support both multiple matching and single matching
according to the value of the \s-1FUN_VIEWMATCH\s0 environment variable.  If
the \s-1FUN_VIEWMATCH\s0 environment variable exists and if its value begins
with \*(L"s\*(R", then a single match is used and missing parameters are not
filled in with subsequent template matches on the file name. That is,
matching rules above are followed exactly as explained above.  If the
value of this environment variable begins with \*(L"m\*(R" (or does not exist),
then multiple matches are used to try to fill in missing parameters.
In this case, template matching always takes place and missing values are
taken from these template matches.
.PP
Thus, in the example above, the View specification:
.PP
.Vb 1
\&  fundisp v:x1
.Ve
.PP
will take the file name and filter value from the x1 View:
.PP
.Vb 1
\&  x1      ${HOME}/data/snr.ev                           cir 512 512 .1
.Ve
.PP
The column value then will be taken from the \*(L"*.ev\*(R" file template match
against the x1 file name:
.PP
.Vb 1
\&          *.ev                            x y pi pha
.Ve
.PP
Note once again that order is important: missing values are taken in the
order in which the template matches are processed.
.PP
\&\fBView Lists: Applying a View to Any File\fR
.PP
It is possible to apply a named View, or even several Views, to any
data file by appending a \fBviewlist\fR immediately after the standard \*(L"v:\*(R"
prefix. A viewlist takes the form:
.PP
.Vb 1
\&  :v1,v2,...vn:
.Ve
.PP
where v1, v2, etc. are named Views. The two \*(L":\*(R" colon characters surrounding
the list are required. Thus, the syntax for applying a viewlist to a file is:
.PP
.Vb 1
\&  v::view1,view2,...viewn:filename
.Ve
.PP
Note that the name after the last \*(L":\*(R" is assumed to be a file; it is
not permissible (or sensible) to use a View name.
.PP
For example, the View specification:
.PP
.Vb 1
\&  fundisp v::x2:foo
.Ve
.PP
applies the x2 View to the file foo (even if there is a View named foo)
and (in using our example database) is equivalent to:
.PP
.Vb 1
\&  ./fundisp foo'[cir 512 512 .1] "x y pi pha"
.Ve
.PP
The same command can be effected using a list of Views:
.PP
.Vb 1
\&  fundisp v::x1,x1a:foo
.Ve
.PP
What happens if a viewlist is used and the file also matches a
template? Consider, for example, this View specification:
.PP
.Vb 1
\&  fundisp v::x2:foo.fit
.Ve
.PP
Here, the x2 View will supply filter and column values, while the
template *.fit can also supply (different) filter and column
values. In this case, the explicitly specified Views of the viewlist
trump the matched view values.
.PP
On the other hand, if a file template match can supply a View value
that is not supplied by the viewlist, then that value will be taken
from the file template match. For example:
.PP
.Vb 1
\&  fundisp v::x2:foo.fits
.Ve
.PP
does not explicitly supply a format value, but the file match on *.fits
can and does. You can avoid supplying missing values using file template
matching by replacing the first \*(L":\*(R" with a \*(L"\-\*(R" in a viewlist
specification:
.PP
.Vb 1
\&  fundisp v:-x2:foo.fits
.Ve
.PP
The use of \*(L":+\*(R" to explicitly allow file template matching is also
supported, but is the same as the default case. Note that the nuances
of viewlist support are subject to change as our experience and
understanding grow.
.PP
\&\fBOverriding Values Associated with a View\fR
.PP
To override values associated with a View, simply supply the override
values in the correct place on the command line. Thus, given
the example database described above, the command:
.PP
.Vb 1
\&  fundisp v:x3
.Ve
.PP
specifies that the View named x3, along with its file name and
associated parameters, be processed as the input file to fundisp in
this way:
.PP
.Vb 1
\&  fundisp  -f "I=%4d" ${HOME}/data/snr.ev'[cir 512 512 .1]'  "x y pi pha"
.Ve
.PP
To override one or more of these values, simply specify a new value
for the format, filter, or columns.  For example, if your input View file
contains a filter, then the View will use that filter as an override
of the View filter:
.PP
.Vb 1
\&  fundisp v:x3'[cir 400 400 3]'
.Ve
.PP
will use the columns and format of the x3 View but not the x3 filter. Further
examples are:
.PP
.Vb 2
\&  fundisp v:x3 "x y dx dy"    # activate a different set of columns
\&  fundisp -f "I=%3d" v:x3     # use a different format statement
.Ve
.PP
Note that extension names, extension index values, and other
non-filter specifications \fBdo not\fR override the View
filter. Thus:
.PP
.Vb 1
\&  fundisp v:foo.fit[3]
.Ve
.PP
will still use the filter associated with the .fit template (see above), since
the \*(L"3\*(R" is an extension index, not a filter.
.PP
\&\fBEnvironment Variables\fR
.PP
The following environment variables are used by Funtools Views:
.IP "\(bu" 4
\&\fB\s-1FUN_VIEWNAME\s0\fR
.Sp
The \fB\s-1FUN_VIEWNAME\s0\fR environment variable specifies the
name and location of the View database file. If not present, the
files ./.funtools.vu and \f(CW$HOME\fR/.funtools.vu are searched for, in
that order.
.IP "\(bu" 4
\&\fB\s-1FUN_VIEWMATCH\s0\fR
.Sp
The \fB\s-1FUN_VIEWMATCH\s0\fR environment variable specifies whether a
single match or multiple match algorithm is used to locate parameter
values. If the value of this environment variable begins with \*(L"s\*(R",
then a single match is used and missing parameters are not filled in
with subsequent template matches on the file name. If the value begins
with \*(L"m\*(R", then multiple matches are used to try to fill in missing 
parameters. The default is to use multiple matches.
.PP
\&\fBRestrictions and Problems\fR
.PP
Support for overriding a filter (while not overriding extension names,
extension indexes, etc.) requires that we can sense the presence of a
filter in a bracket specification. It is unclear yet whether our
algorithm is perfect.
.PP
Go to Funtools Help Index
.PP
Last updated: August 3, 2007
