.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "funfiles n"
.TH funfiles n "April 14, 2011" "version 1.4.5" "SAORD Documentation"
.SH "NAME"
\&\fBFunFiles: Funtools Data Files\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document describes the data file formats (\s-1FITS\s0, array, raw
events) as well as the file types (gzip, socket, etc.) supported
by Funtools.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Funtools supports \s-1FITS\s0 images and binary tables, and binary files
containing array (homogeneous) data or event (heterogeneous) data.
IRAF-style brackets are appended to the filename to specify various
kinds of information needed to characterize these data:
.PP
.Vb 3
\&  file[ext|ind|ARRAY()|EVENTS(),section][filters]
\&  or
\&  file[ext|ind|ARRAY()|EVENTS(),section,filters]
.Ve
.PP
where:
.IP "\(bu" 4
\&\fBfile\fR is the Funtools file name
.IP "\(bu" 4
\&\fBext\fR is the \s-1FITS\s0 extension name
.IP "\(bu" 4
\&\fBind\fR is the \s-1FITS\s0 extension number
.IP "\(bu" 4
\&\fB\s-1\f(BIARRAY\s0()\fB\fR is an array specification
.IP "\(bu" 4
\&\fB\s-1\f(BIEVENTS\s0()\fB\fR is an event specification
.IP "\(bu" 4
\&\fBsection\fR is the image section specification
.IP "\(bu" 4
\&\fBfilters\fR are spatial region and table (row) filters
.PP
\&\fBSupported Data Formats\fR
.PP
Funtools programs (and the underlying libraries) support the
following data file formats:
.IP "\(bu" 4
\&\s-1FITS\s0 images (and image extensions)
.IP "\(bu" 4
\&\s-1FITS\s0 binary tables
.IP "\(bu" 4
binary files containing an array of homogeneous data
.IP "\(bu" 4
binary files containing events, i.e. records of heterogeneous data
.IP "\(bu" 4
column-based text files, which are documented here
.IP "\(bu" 4
non-disk files and lists of files
.PP
Information needed to identify and characterize
the event or image data can be specified on the command line 
using IRAF-style bracket notation appended to the filename:
.PP
.Vb 5
\&  foo.fits                              # open FITS default extension
\&  image.fits[3]                         # open FITS extension #3
\&  events.fits[EVENTS]                   # open EVENTS extension
\&  array.file[ARRAY(s1024)]              # open 1024x1024 short array
\&  events.file[EVENTS(x:1024,y:1024...)] # open non-FITS event list
.Ve
.PP
Note that in many Unix shells (e.g., csh and tcsh), filenames must
be enclosed in quotes to protect the brackets from shell processing.
.PP
\&\fB\s-1FITS\s0 Images and Binary Tables\fR
.PP
When \fIFunOpen()\fR opens a \s-1FITS\s0 file
without a bracket specifier, the default behavior is to look for a
valid image in the primary \s-1HDU\s0. In the absence of a primary image,
Funtools will try to open an extension named either \fB\s-1EVENTS\s0\fR or
\&\fB\s-1STDEVT\s0\fR, if one of these exists. This default behavior supports
both \s-1FITS\s0 image processing and standard X\-ray event list processing
(which, after all, is what we at \s-1SAO/HEAD\s0 do).
.PP
In order to open a \s-1FITS\s0 binary table or image extension explicitly, it
is necessary to specify either the extension name or the extension
number in brackets:
.PP
.Vb 3
\&  foo.fits[1]                      # open extension #1: the primary HDU
\&  foo.fits[3]                      # open extension #3 of a FITS file
\&  foo.fits[GTI]                    # open GTI extension of a FITS file
.Ve
.PP
The ext argument specifies the name of the \s-1FITS\s0 extension (i.e. the
value of the \s-1EXTENSION\s0 header parameter in a \s-1FITS\s0 extension), while
the index specifies the value of the \s-1FITS\s0 \s-1EXTVER\s0 header parameter.
Following \s-1FITS\s0 conventions, extension numbers start at 1.
.PP
When a \s-1FITS\s0 data file is opened for reading using 
\&\fIFunOpen()\fR, the specified extension
is automatically located and is used to initialize the Funtools internal
data structures.
.PP
\&\fBNon-FITS Raw Event Files\fR
.PP
In addition to \s-1FITS\s0 tables, Funtools programs and libraries can operate
on non-FITS files containing heterogeneous event records. To specify
such an event file, use:
.IP "\(bu" 4
file[\s-1EVENTS\s0(event\-spec)]
.IP "\(bu" 4
file[\s-1\fIEVENTS\s0()\fR]
.PP
where \fBevent-spec\fR is a string that specified the names, data
types, and optional image dimensions for each element of the event
record:
.IP "\(bu" 4
[name]:[n][type]:[(lodim:)hidim]
.PP
Data types follow standard conventions for \s-1FITS\s0 binary tables, but include
two extra unsigned types ('U' and 'V'):
.IP "\(bu" 4
\&\fBB\fR \*(-- unsigned 8\-bit char
.IP "\(bu" 4
\&\fBI\fR \*(-- signed 16\-bit int
.IP "\(bu" 4
\&\fBJ\fR \*(-- signed 32\-bit int
.IP "\(bu" 4
\&\fBK\fR \*(-- signed 64\-bit int
.IP "\(bu" 4
\&\fBE\fR \*(-- 32\-bit float
.IP "\(bu" 4
\&\fBD\fR \*(-- 64\-bit float
.IP "\(bu" 4
\&\fBU\fR \*(-- unsigned 16\-bit int
.IP "\(bu" 4
\&\fBV\fR \*(-- unsigned 32\-bit int
.PP
An optional integer value \fBn\fR can be prefixed to the type to indicate
that the element is an array of n values. For example:
.PP
.Vb 1
\&  foo.fits[EVENTS(x:I,y:I,status:4J)]
.Ve
.PP
defines x and y as 16\-bit ints and status as an array of 4 32\-bit ints.
.PP
Furthermore, image dimensions can be attached to the event specification
in order to tell Funtools how to bin the events into an image. They
follow the conventions for the \s-1FITS\s0 \s-1TLMIN/TLMAX\s0 keywords. If the low
image dimension is not specified, it defaults to 1.  Thus:
.IP "\(bu" 4
\&\s-1RAWX:J:1:100\s0
.IP "\(bu" 4
\&\s-1RAWX:J:100\s0
.PP
both specify that the dimension of this column runs from 1 to 100.
.PP
\&\s-1NB:\s0 it is required that all padding be specified in the record
definition. Thus, when writing out whole C structs instead of
individual record elements, great care must be taken to include
the compiler-added padding in the event definition.
.PP
For example, suppose a \s-1FITS\s0 binary table has the following set of column
definitions:
.PP
.Vb 22
\&  TTYPE1  = 'X                 ' / Label for field
\&  TFORM1  = '1I                ' / Data type for field
\&  TLMIN1  =                    1 / Min. axis value
\&  TLMAX1  =                   10 / Max. axis value
\&  TTYPE2  = 'Y                 ' / Label for field
\&  TFORM2  = '1I                ' / Data type for field
\&  TLMIN2  =                    2 / Min. axis value
\&  TLMAX2  =                   11 / Max. axis value
\&  TTYPE3  = 'PHA               ' / Label for field
\&  TFORM3  = '1I                ' / Data type for field
\&  TTYPE4  = 'PI                ' / Label for field
\&  TFORM4  = '1J                ' / Data type for field
\&  TTYPE5  = 'TIME              ' / Label for field
\&  TFORM5  = '1D                ' / Data type for field 
\&  TTYPE6  = 'DX                ' / Label for field
\&  TFORM6  = '1E                ' / Data type for field
\&  TLMIN6  =                    1 / Min. axis value
\&  TLMAX6  =                   10 / Max. axis value
\&  TTYPE7  = 'DY                ' / Label for field
\&  TFORM7  = '1E                ' / Data type for field
\&  TLMIN7  =                    3 / Min. axis value
\&  TLMAX7  =                   12 / Max. axis value
.Ve
.PP
An raw event file containing these same data would have the event
specification:
.PP
.Vb 1
\&  EVENTS(X:I:10,Y:I:2:11,PHA:I,PI:J,TIME:D,DX:E:10,DY:E:3:12)
.Ve
.PP
If no event specification string is included within the \s-1\fIEVENTS\s0()\fR operator,
then the event specification is taken from the \fB\s-1EVENTS\s0\fR environment
variable:
.PP
.Vb 1
\&  setenv EVENTS "X:I:10,Y:I:10,PHA:I,PI:J,TIME:D,DX:E:10,DY:E:10"
.Ve
.PP
In addition to knowing the data structure, it is necessary to know the
\&\fIendian\fR ordering of the data, i.e., whether or not the data is
in \fIbigendian\fR format, so that we can convert to the native
format for this platform. This issue does not arise for \s-1FITS\s0 Binary
Tables because all \s-1FITS\s0 files use big-endian ordering, regardless of
platform. But for non-FITS data, big-endian data produced on a Sun
workstation but read on a Linux \s-1PC\s0 needs to be byte\-swapped, since PCs
use little-endian ordering. To specify an ordering, use the
\&\fIbigendian=\fR or \fIendian=\fR keywords on the command-line
or the \s-1EVENTS_BIGENDIAN\s0 or \s-1EVENTS_ENDIAN\s0 environment variables.  The
value of the \fIbigendian\fR variables should be \*(L"true\*(R" or \*(L"false\*(R",
while the value of the \fIendian\fR variables should be \*(L"little\*(R" or
\&\*(L"big\*(R".
.PP
For example, a \s-1PC\s0 can access data produced by a Sun using:
.PP
.Vb 7
\&  hrc.nepr[EVENTS(),bigendian=true]
\&or
\&  hrc.nepr[EVENTS(),endian=big]
\&or
\&  setenv EVENTS_BIGENDIAN true
\&or
\&  setenv EVENTS_ENDIAN big
.Ve
.PP
If none of these are specified, the data are assumed to follow the
format for that platform and no byte-swapping is performed.
.PP
\&\fBNon-FITS Array Files\fR
.PP
In addition to \s-1FITS\s0 images, Funtools programs and libraries can operate
on non-FITS files containing arrays of homogeneous data. To specify
an array file, use:
.IP "\(bu" 4
file[\s-1ARRAY\s0(array\-spec)]
.IP "\(bu" 4
file[\s-1\fIARRAY\s0()\fR]
.PP
where array-spec is of the form:
.IP "\(bu" 4
[type][dim1][.dim2][:skip][endian]
.PP
and where [type] is:
.IP "\(bu" 4
b   (8\-bit unsigned char)
.IP "\(bu" 4
s   (16\-bit short int)
.IP "\(bu" 4
u   (16\-bit unsigned short int)
.IP "\(bu" 4
i   (32\-bit int)
.IP "\(bu" 4
r,f (32\-bit float)
.IP "\(bu" 4
d   (64\-bit float)
.PP
The dim1 specification is required, but dim2 is optional and defaults
to dim1.  The skip specification is optional and defaults to 0.  The
optional endian specification can be 'l' or 'b' and defaults to the
endian type for the current machine.
.PP
If no array specification is included within the \s-1\fIARRAY\s0()\fR operator,
then the array specification is taken from the \fB\s-1ARRAY\s0\fR environment
variable. For example:
.PP
.Vb 7
\&  foo.arr[ARRAY(r512)]          # bitpix=-32 dim1=512 dim2=512
\&  foo.arr[ARRAY(r512.400)]      # bitpix=-32 dim1=512 dim2=400
\&  foo.arr[ARRAY(r512.400])      # bitpix=-32 dim1=512 dim2=400
\&  foo.arr[ARRAY(r512.400:2880)] # bitpix=-32 dim1=512 dim2=400 skip=2880
\&  foo.arr[ARRAY(r512l)]         # bitpix=-32 dim1=512 dim2=512 endian=little
\&  setenv ARRAY "r512.400:2880"
\&  foo.arr[ARRAY()]              # bitpix=-32 dim1=512 dim2=400 skip=2880
.Ve
.PP
\&\fBSpecifying Image Sections\fR
.PP
Once a data file (and possibly, a \s-1FITS\s0 extension) has been specified,
the next (optional) part of a bracket specification can be used to
select image \fBsection\fR information, i.e., to specify the x,y
limits of an image section, as well as the blocking factor to apply to
that section. This information can be added to any file specification but
only is used by Funtools image processing routines.
.PP
The format of the image section specification is one of the following:
.IP "\(bu" 4
file[xy0:xy1,block]
.IP "\(bu" 4
file[x0:x1,y0:y1,block]
.IP "\(bu" 4
file[x0:x1,*,block]
.IP "\(bu" 4
file[*,y0:y1,block]
.IP "\(bu" 4
file[*,block]
.PP
where the limit values can be ints or \*(L"*\*(R" for default. A single \*(L"*\*(R"
can be used instead of val:val, as shown.  Note that blocking is
applied to the section after it is extracted.
.PP
In addition to image sections specified by the lo and hi x,y limits, image
sections using center positions can be specified:
.IP "\(bu" 4
file[dim1@xcen,dim2@ycen]
.IP "\(bu" 4
file[xdim2@xcen@ycen]
.IP "\(bu" 4
file[dim1@xcen,dim2@ycen,block]
.IP "\(bu" 4
file[dim@xcen@ycen,block]
.PP
Note that the (float) values for dim, dim1, dim2, xcen, ycen must be
specified or else the expression does not make sense!
.PP
In all cases, block is optional and defaults to 1. An 's' or 'a' can
be appended to signify \*(L"sum\*(R" or \*(L"average\*(R" blocking (default is \*(L"sum\*(R").
Section specifications are given in image coordinates by default. If you
wish to specify physical coordinates, add a 'p' as the last character
of the section specification, before the closing bracket.
For example:
.IP "\(bu" 4
file[\-8:\-7,\-8:\-7p]
.IP "\(bu" 4
file[\-8:\-7,\-8:\-7,2p]
.PP
A section can be specified in any Funtools file name. If the operation
to be applied to that file is an imaging operation, then the
specification will be utilized. If the operation is purely a table
operation, then the section specification is ignored.
.PP
Do not be confused by:
.PP
.Vb 2
\&  foo.fits[2]
\&  foo.fits[*,2]
.Ve
.PP
The former specifies opening the second extension of the \s-1FITS\s0 file.
The latter specifies application of block 2 to the image section.
.PP
Note that the section specification must come after
any of \s-1FITS\s0 \fBext\fR name or \fBind\fR number,
but all sensible defaults are supported:
.IP "\(bu" 4
file[ext]
.IP "\(bu" 4
file[ext,index]
.IP "\(bu" 4
file[index]
.IP "\(bu" 4
file[ext,section]
.IP "\(bu" 4
file[ext,index,section]
.IP "\(bu" 4
file[index,section]
.IP "\(bu" 4
file[section]
.PP
\&\fBBinning \s-1FITS\s0 Binary Tables and Non-FITS Event Files\fR
.PP
If a \s-1FITS\s0 binary table or a non-FITS raw event file is to be binned
into a 2D image (e.g., using the 
funimage
program), it is necessary to specify the two columns to be used for the
binning, as well as the dimensions of the image.  Funtools first looks
for a specifier of the form:
.PP
.Vb 1
\& bincols=([xnam[:tlmin[:tlmax:[binsiz]]]],[ynam[:tlmin[:tlmax[:binsiz]]]])
.Ve
.PP
in bracket syntax, and uses the column names thus specified. The tlmin, tlmax,
and binsiz specifiers determine the image binning dimensions using:
.PP
.Vb 2
\&  dim = (tlmax - tlmin)/binsiz     (floating point data)
\&  dim = (tlmax - tlmin)/binsiz + 1 (integer data)
.Ve
.PP
These tlmin, tlmax, and binsiz specifiers can be omitted if \s-1TLMIN\s0,
\&\s-1TLMAX\s0, and \s-1TDBIN\s0 header parameters are present in the \s-1FITS\s0 binary
table header, respectively. If only one parameter is specified, it is
assumed to be tlmax, and tlmin defaults to 1. If two parameters are
specified, they are assumed to be tlmin and tlmax.
.PP
For example, to bin an \s-1HRC\s0 event list columns \*(L"\s-1VPOS\s0\*(R" and \*(L"\s-1UPOS\s0\*(R", use:
.PP
.Vb 1
\&  hrc.nepr[bincols=(VPOS,UPOS)]
.Ve
.PP
or
.PP
.Vb 1
\&  hrc.nepr[bincols=(VPOS:49152,UPOS:4096)]
.Ve
.PP
Note that you can optionally specify the dimensions of these columns
to cover cases where neither \s-1TLMAX\s0 keywords are defined in
the header.  If either dimension is specified, then both must be specified.
.PP
You can set the \s-1FITS_BINCOLS\s0 or \s-1EVENTS_BINCOLS\s0 environment variable as
an alternative to adding the \*(L"bincols=\*(R" specifier to each file name
for \s-1FITS\s0 binary tables and raw event files, respectively.  If no
binning keywords or environment variables are specified, or if the
specified columns are not in the binary table, the Chandra parameters
\&\s-1CPREF\s0 (or \s-1PREFX\s0) are searched for in the \s-1FITS\s0 binary table header.
Failing this, columns named \*(L"X\*(R" and \*(L"Y\*(R" are sought.  If these are not
found, the code looks for columns containing the characters \*(L"X\*(R" and
\&\*(L"Y\*(R".  Thus, you can bin on \*(L"\s-1DETX\s0\*(R" and \*(L"\s-1DETX\s0\*(R" columns without
specifying them, if these are the only column names containing the \*(L"X\*(R"
and \*(L"Y\*(R" characters.
.PP
Ordinarily, each event or row contributes one count to an image pixel
during the 2D binning process. Thus, if five events all have the same
(x,y) position, the image pixel value for that position will have a
value of five. It is possible to specify a variable contribution
for each event by using the vcol=[colname] filter spec:
.PP
.Vb 1
\& vcol=[colname]
.Ve
.PP
The vcol colname is a column containing a numeric value in each event row
that will be used as the contribution of the given event to its image
pixel. For example, consider an event file that has the following content:
.PP
.Vb 10
\&  x:e:4    y:e:4    v:e
\&  ------   ------   ----
\&  1        1        1.0
\&  2        2        2.0
\&  3        3        3.0
\&  4        4        0.0
\&  1        1        1.0
\&  2        2        2.0
\&  3        3        3.0
\&  4        4        4.0
.Ve
.PP
There are two events with x,y value of (1,1) so ordinarily a 2D image will
have a value of 2 in the (1,1) pixel. If the v column is specified as the 
value column:
.PP
.Vb 1
\&  foo.fits'[vcol=v]'
.Ve
.PP
then each pixel will contain the additive sum of the associated (x,y)
column values from the v column.  For example, image pixel (1,1) will
contain 1. + 1. = 2, image pixel (2,2) will contain (2 + 2) = 4, etc.
.PP
An important variation on the use of a value column to specify the
contribution an event makes to an image pixel is when the value column
contains the reciprocal of the event contribution. For this case, the
column name should be prefixed with a / (divide sign) thus:
.PP
.Vb 1
\&  foo.fits'[vcol=/v]'
.Ve
.PP
Each image pixel value will then be the sum of the reciprocals of the value
column. A zero in the value column results in NaN (not a number).
Thus, in the above example, image pixel (1.1) will contain 1/1 + 1/1 = 2,
image pixel (2,2) will contain (1/2 + 1/2) = 1, etc. Image pixel (4,4)
will contain (1/0 + 1/4) = NaN.
.PP
You can set the \s-1FITS_VCOL\s0 or \s-1EVENTS_VCOL\s0 environment variable as
an alternative to adding the \*(L"vcol=\*(R" specifier to each file name
for \s-1FITS\s0 binary tables and raw event files, respectively.
.PP
Finally, when binning events, the data type of the resulting 2D image
must be specified. This can be done with the \*(L"bitpix=[n]\*(R" keyword in
the bracket specification.  For example:
.PP
.Vb 1
\&  events.fits[bincols=(VPOS,UPOS),bitpix=-32]
.Ve
.PP
will create a floating point image binned on columns \s-1VPOS\s0 and \s-1UPOS\s0.
If no bitpix keyword is specified, bitpix=32 is assumed.  As with
bincols values, you also can use the \s-1FITS_BITPIX\s0 and \s-1EVENTS_BITPIX\s0
environment variables to set this value for \s-1FITS\s0 binary tables and
raw event files, respectively.
.PP
The \fBfunimage\fR program also allows you to create a 1D image projection
along any column of a table by using the \fBbincols=[column]\fR
filter specification and specifying a single column.
For example, the following command projects a 1D image along
the chipx column of a table:
.PP
.Vb 1
\&  funimage ev.fits'[bincols=chipx]' im.fits
.Ve
.PP
See funimage for more
information about creating 1D and 2D images.
.PP
Finally, please note that Funtools supports most \s-1FITS\s0 standards.
We will add missing support as required by the community. In general,
however, we do not support non-standard extensions. For example, we
sense the presence of the binary table 'variable length array'
proposed extension and we pass it along when copying and filtering
files, but we do not process it. We will add support for new standards
as they become official.
.PP
\&\fBTable and Spatial Region Filters\fR
.PP
Note that, in addition extensions and image sections, Funtools bracket
notation can be used to specify table and spatial region filters.  These
filters are always placed after the image section information.  They
can be specified in the same bracket or in a separate bracket
immediately following:
.IP "\(bu" 4
file[ext|ind|\fIARRAY()\fR|\fIEVENTS()\fR,section][filters]
.IP "\(bu" 4
file[ext|ind|\fIARRAY()\fR|\fIEVENTS()\fR,section,filters]
.PP
where:
.IP "\(bu" 4
\&\fBfile\fR is the Funtools file name
.IP "\(bu" 4
\&\fB\s-1\f(BIARRAY\s0()\fB\fR is an array specification
.IP "\(bu" 4
\&\fB\s-1\f(BIEVENTS\s0()\fB\fR is an event list specification
.IP "\(bu" 4
\&\fBext\fR is the \s-1FITS\s0 extension name
.IP "\(bu" 4
\&\fBind\fR is the \s-1FITS\s0 extension number
.IP "\(bu" 4
\&\fBsection\fR is the image section to extract
.IP "\(bu" 4
\&\fBfilters\fR are spatial region and table (row) filters to apply
.PP
The topics of table and region filtering are covered in detail in:
.IP "\(bu" 4
Table Filtering
.IP "\(bu" 4
Spatial Region Filtering
.PP
\&\fBDisk Files and Other Supported File Types\fR
.PP
The specified \fBfile\fR usually is an ordinary disk file. In
addition, gzip'ed files are supported in Funtools: gzip'ed input files
are automatically uncompressed as they are read, and gzip'ed output
files are compressed as they are written. \s-1NB:\s0 if a \s-1FITS\s0 binary table
is written in gzip format, the number of rows in the table will be set
to \-1. Such a file will work with Funtools programs but will not work
with other \s-1FITS\s0 programs such as ds9.
.PP
The special keywords \*(L"stdin\*(R" and \*(L"stdout\*(R" designate Unix standard
input and standard output, respectively. The string \*(L"\-\*(R" (hyphen) will
be taken to mean \*(L"stdin\*(R" if the file is opened for reading and
\&\*(L"stdout\*(R" if the file is opened for writing.
.PP
A file also can be an \s-1INET\s0 socket on the same or another machine using
the syntax:
.PP
.Vb 1
\&  machine:port
.Ve
.PP
Thus, for example:
.PP
.Vb 1
\&  karapet:1428
.Ve
.PP
specifies that I/O should be performed to/from port 1428 on the
machine karapet.  If no machine name is specified, the default is to
use the current machine:
.PP
.Vb 1
\&  :1428
.Ve
.PP
This means to open port 1428 on the current machine. Socket support
allows you to generate a distributed pipe:
.PP
.Vb 2
\&  on karapet:       funtask1 in.fits bynars:1428
\&  on bynars:        funtask2 :1428 out.fits
.Ve
.PP
The socket mechanism thus supports simple parallel processing using
\&\fBprocess decomposition\fR. Note that parallel processing using
\&\fBdata decomposition\fR is supported via the \fBsection\fR specifier (see
below), and the \fBrow#\fR specifier, which is part of 
Table Filtering.
.PP
A file also can be a pointer to shared memory using the syntax:
.PP
.Vb 1
\&  shm:[id|@key][:size]
.Ve
.PP
A shared memory segment is specified with a \fBshm:\fR prefix,
followed by either the shared memory id or the shared memory key
(where the latter is prefixed by the '@' character).  The size (in
bytes) of the shared memory segment can then be appended (preceded by
the ':' character). If the size specification is absent, the code will
attempt to determine the length automatically. 
.PP
If the open mode contains the string \*(L"w+\*(R", then the memory segment will be
created if it does not exist. (It also will be released and deleted when the
file is closed.) In the case where a memory segment is being created, the
length of the segment is required.
.PP
A file also can be Unix piped command (i.e. a program to run) using the syntax:
.PP
.Vb 1
\&  "pipe: command arg1 ... argn"
.Ve
.PP
The output from the command must be a valid \s-1FITS\s0 file. It is important
to use quotes to protect spaces so that command arguments are passed
correctly. A silly example is:
.PP
.Vb 1
\&  fundisp "pipe: funtable 'foo.fits[cir 512 512 .1]' stdout"
.Ve
.PP
This seemed like a good idea at the time ...
.PP
\&\fBLists of Files\fR
.PP
Funtools also will process a list of files as a single file using the
syntax:
.PP
.Vb 1
\&  "list: file1 file2 ... filen"
.Ve
.PP
The files in the list are separated by whitespace. Any of the
above file types can be used. For example, if two files, foo1.fits and
foo2.fits, are part of the same observation, they can be processed as
a single file (using their own filters):
.PP
.Vb 17
\&  fundisp "list: foo1.fits[cir(512,512,10)] foo2.fits[cir(511,511,10)]"
\&         X        Y      PHA       PI                  TIME       DX       DY
\&  -------- -------- -------- -------- --------------------- -------- --------
\&       512      512        6        7     79493997.45854475      578      574
\&       512      512        8        9     79494575.58943175      579      573
\&       512      512        5        6     79493631.03866175      578      575
\&       512      512        5        5     79493290.86521725      578      575
\&       512      512        8        9     79493432.00990875      579      573
\&       511      511        5        5     79488631.09462625      580      575
\&       511      511       10       11     79488780.60006675      580      573
\&       511      511        4        4     79494562.35474326      580      575
\&       511      511        6        6     79488203.01561825      580      575
\&       511      511        6        6     79488017.99730176      580      575
\&       511      511        4        4     79494332.45355175      580      575
\&       511      511        9       10     79492685.94014275      581      574
\&       511      511        5        5     79487708.71298325      580      575
\&       511      511        8        9     79493719.00160225      581      573
.Ve
.PP
Again, note that it is important to avoid spaces in the filters
because the list separator also is whitespace. To protect whitespace
in a filter, enclose the file specification in quotes:
.PP
.Vb 1
\&  fundisp "list: 'foo1.fits[cir 512 512 .1]' foo2.fits[cir(511,511,.1)]"
.Ve
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
