'\"
'\" Generated from file 'ldapx\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006-2018 Pierre David <pdav@users\&.sourceforge\&.net>
'\"
.TH "ldapx" n 1\&.1 tcllib "LDAP extended object interface"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
ldapx \- LDAP extended object interface
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBldapx  ?1\&.1?\fR
.sp
\fIe\fR \fBreset\fR
.sp
\fIe\fR \fBdn\fR ?\fInewdn\fR?
.sp
\fIe\fR \fBrdn\fR
.sp
\fIe\fR \fBsuperior\fR
.sp
\fIe\fR \fBprint\fR
.sp
\fIse\fR \fBisempty\fR
.sp
\fIse\fR \fBget\fR \fIattr\fR
.sp
\fIse\fR \fBget1\fR \fIattr\fR
.sp
\fIse\fR \fBset\fR \fIattr\fR \fIvalues\fR
.sp
\fIse\fR \fBset1\fR \fIattr\fR \fIvalue\fR
.sp
\fIse\fR \fBadd\fR \fIattr\fR \fIvalues\fR
.sp
\fIse\fR \fBadd1\fR \fIattr\fR \fIvalue\fR
.sp
\fIse\fR \fBdel\fR \fIattr\fR ?\fIvalues\fR?
.sp
\fIse\fR \fBdel1\fR \fIattr\fR \fIvalue\fR
.sp
\fIse\fR \fBgetattr\fR
.sp
\fIse\fR \fBgetall\fR
.sp
\fIse\fR \fBsetall\fR \fIavpairs\fR
.sp
\fIse\fR \fBbackup\fR ?\fIother\fR?
.sp
\fIse\fR \fBswap\fR
.sp
\fIse\fR \fBrestore\fR ?\fIother\fR?
.sp
\fIse\fR \fBapply\fR \fIcentry\fR
.sp
\fIce\fR \fBchange\fR ?\fInew\fR?
.sp
\fIce\fR \fBdiff\fR \fInew\fR ?\fIold\fR?
.sp
\fIla\fR \fBerror\fR ?\fInewmsg\fR?
.sp
\fIla\fR \fBconnect\fR \fIurl\fR ?\fIbinddn\fR? ?\fIbindpw\fR?
.sp
\fIla\fR \fBdisconnect\fR
.sp
\fIla\fR \fBtraverse\fR \fIbase\fR \fIfilter\fR \fIattrs\fR \fIentry\fR \fIbody\fR
.sp
\fIla\fR \fBsearch\fR \fIbase\fR \fIfilter\fR \fIattrs\fR
.sp
\fIla\fR \fBread\fR \fIbase\fR \fIfilter\fR \fIentry\fR \&.\&.\&. \fIentry\fR
.sp
\fIla\fR \fBcommit\fR \fIentry\fR \&.\&.\&. \fIentry\fR
.sp
\fIli\fR \fBchannel\fR \fIchan\fR
.sp
\fIli\fR \fBerror\fR ?\fInewmsg\fR?
.sp
\fIli\fR \fBread\fR \fIentry\fR
.sp
\fIli\fR \fBwrite\fR \fIentry\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBldapx\fR package provides an extended Tcl interface to
LDAP directores and LDIF files\&. The \fBldapx\fR package is built
upon the \fBldap\fR package in order to get low level LDAP access\&.
.PP
LDAP access is compatible with RFC 2251
(\fIhttp://www\&.rfc-editor\&.org/rfc/rfc2251\&.txt\fR)\&.
LDIF access is compatible with RFC 2849
(\fIhttp://www\&.rfc-editor\&.org/rfc/rfc2849\&.txt\fR)\&.
.SH OVERVIEW
The \fBldapx\fR package provides objects to interact with LDAP
directories and LDIF files with an easy to use programming interface\&.
It implements three \fBsnit\fR::type classes\&.
.PP
The first class, \fBentry\fR, is used to store individual entries\&.
Two different formats are available: the first one is the
\fIstandard\fR format, which represents an entry as read from the
directory\&. The second format is the \fIchange\fR format, which
stores differences between two standard entries\&.
.PP
With these entries, an application which wants to modify an entry
in a directory needs to read a (standard) entry from the directory,
create a fresh copy into a new (standard) entry, modify the new
copy, and then compute the differences between the two entries into
a new (change) entry, which may be commited to the directory\&.
.PP
Such kinds of modifications are so heavily used that standard entries
may contain their own copy of the original data\&. With such a copy,
the application described above reads a (standard) entry from the
directory, backs-up the original data, modifies the entry, and
computes the differences between the entry and its backup\&. These
differences are then commited to the directory\&.
.PP
Methods are provided to compute differences between two entries,
to apply differences to an entry in order to get a new entry, and
to get or set attributes in standard entries\&.
.PP
The second class is the \fBldap\fR class\&. It provides a method
to \fBconnect\fR and bind to the directory with a uniform access
to LDAP and LDAPS through an URL (ldap:// or ldaps://)\&. The
\fBtraverse\fR control structure executes a body for each entry
found in the directory\&. The \fBcommit\fR method applies some
changes (represented as \fBentry\fR objects) to the directory\&.
Since some attributes are represented as UTF-8 strings, the option
\fB-utf8\fR controls which attributes must be converted and
which attributes must not be converted\&.
.PP
The last class is the \fBldif\fR class\&. It provides a method to
associate a standard Tcl \fIchannel\fR to an LDIF object\&. Then,
methods \fBread\fR and \fBwrite\fR read or write entries from
or to this channel\&. This class can make use of standard or change
entries, according to the type of the LDIF file which may contain
either standard entries or change entries (but not both at the same
time)\&. The option \fB-utf8\fR works exactly as with the
\fBldap\fR class\&.
.SH "ENTRY CLASS"
.SS "ENTRY INSTANCE DATA"
An instance of the \fBentry\fR class keeps the following data:
.TP
dn
This is the DN of the entry, which includes (in LDAP
terminology) the RDN (relative DN) and the Superior parts\&.
.TP
format
The format may be \fIuninitialized\fR (entry not yet used),
\fIstandard\fR or \fIchange\fR\&. Most methods check the
format of the entry, which can be reset with the
\fBreset\fR method\&.
.TP
attrvals
In a \fIstandard\fR entry, this is where the attributes
and associated values are stored\&. Many methods provide
access to these informations\&. Attribute names are always
converted into lower case\&.
.TP
backup
In a \fIstandard\fR entry, the backup may contain a copy
of the dn and all attributes and values\&. Methods
\fBbackup\fR and \fBrestore\fR manipulate these data,
and method \fBdiff\fR may use this backup\&.
.TP
change
In a \fIchange\fR entry, these data represent the
modifications\&. Such modifications are handled by specialized
methods such as \fBapply\fR or \fBcommit\fR\&.
Detailed format should not be used directly by programs\&.
.sp
Internally, modifications are represented as a list of
elements, each element has one of the following formats
(which match the corresponding LDAP operations):
.RS
.IP [1]
{\fBadd\fR {attr1 {val1\&.\&.\&.valn} attr2 {\&.\&.\&.} \&.\&.\&.}}
.sp
Addition of a new entry\&.
.IP [2]
{\fBmod\fR {modop {attr1 ?val1\&.\&.\&.valn?} attr2 \&.\&.\&.} {modop \&.\&.\&.} \&.\&.\&.}
.sp
Modification of one or more attributes and/or values,
where <modop> can be \fBmodadd\fR, \fBmoddel\fR
or \fBmodrepl\fR (see the LDAP modify operation)\&.
.IP [3]
{\fBdel\fR}
.sp
Deletion of an old entry\&.
.IP [4]
{\fBmodrdn\fR newrdn deleteoldrdn ?newsuperior?}
.sp
Renaming of an entry\&.
.RE
.PP
.SS "ENTRY OPTIONS"
No option is defined by this class\&.
.SS "METHODS FOR ALL KINDS OF ENTRIES"
.TP
\fIe\fR \fBreset\fR
This method resets the entry to an uninitialized state\&.
.TP
\fIe\fR \fBdn\fR ?\fInewdn\fR?
This method returns the current DN of the entry\&. If the
optional \fInewdn\fR is specified, it replaces the current
DN of the entry\&.
.TP
\fIe\fR \fBrdn\fR
This method returns the RDN part of the DN of the entry\&.
.TP
\fIe\fR \fBsuperior\fR
This method returns the superior part of the DN of the entry\&.
.TP
\fIe\fR \fBprint\fR
This method returns the entry as a string ready to be printed\&.
.PP
.PP
.SS "METHODS FOR STANDARD ENTRIES ONLY"
In all methods, attribute names are converted in lower case\&.
.TP
\fIse\fR \fBisempty\fR
This method returns 1 if the entry is empty (i\&.e\&. without
any attribute)\&.
.TP
\fIse\fR \fBget\fR \fIattr\fR
This method returns all values of the attribute \fIattr\fR,
or the empty list if the attribute is not fond\&.
.TP
\fIse\fR \fBget1\fR \fIattr\fR
This method returns the first value of the attribute\&.
.TP
\fIse\fR \fBset\fR \fIattr\fR \fIvalues\fR
This method sets the values (list \fIvalues\fR) of the
attribute \fIattr\fR\&. If the list is empty, this method
deletes all
.TP
\fIse\fR \fBset1\fR \fIattr\fR \fIvalue\fR
This method sets the values of the attribute \fIattr\fR to
be an unique value \fIvalue\fR\&. Previous values, if any,
are replaced by the new value\&.
.TP
\fIse\fR \fBadd\fR \fIattr\fR \fIvalues\fR
This method adds all elements the list \fIvalues\fR to the
values of the attribute \fIattr\fR\&.
.TP
\fIse\fR \fBadd1\fR \fIattr\fR \fIvalue\fR
This method adds a single value given by the parameter
\fIvalue\fR to the attribute \fIattr\fR\&.
.TP
\fIse\fR \fBdel\fR \fIattr\fR ?\fIvalues\fR?
If the optional list \fIvalues\fR is specified, this method
deletes all specified values from the attribute \fIattr\fR\&.
If the argument \fIvalues\fR is not specified, this method
deletes all values\&.
.TP
\fIse\fR \fBdel1\fR \fIattr\fR \fIvalue\fR
This method deletes a unique \fIvalue\fR from the attribute
\fIattr\fR\&.
.TP
\fIse\fR \fBgetattr\fR
This method returns all attributes names\&.
.TP
\fIse\fR \fBgetall\fR
This method returns all attributes and values from the
entry, packed in a list of pairs <attribute, list of values>\&.
.TP
\fIse\fR \fBsetall\fR \fIavpairs\fR
This method sets at once all attributes and values\&. The
format of the \fIavpairs\fR argument is the same as the one
returned by method \fBgetall\fR\&.
.TP
\fIse\fR \fBbackup\fR ?\fIother\fR?
This method stores in an \fIother\fR standard entry object
a copy of the current DN and attributes/values\&. If the
optional \fIother\fR argument is not specified, copy is
done in the current entry (in a specific place, see section
\fBOVERVIEW\fR)\&.
.TP
\fIse\fR \fBswap\fR
This method swaps the current and backup contexts of the
entry\&.
.TP
\fIse\fR \fBrestore\fR ?\fIother\fR?
If the optional argument \fIother\fR is given, which must
then be a \fIstandard\fR entry, this method restores the
current entry into the \fIother\fR entry\&. If the argument
\fIother\fR argument is not specified, this methods restores
the current entry from its internal backup (see section
\fBOVERVIEW\fR)\&.
.TP
\fIse\fR \fBapply\fR \fIcentry\fR
This method applies changes defined in the \fIcentry\fR
argument, which must be a \fIchange\fR entry\&.
.PP
.SS "METHODS FOR CHANGE ENTRIES ONLY"
.TP
\fIce\fR \fBchange\fR ?\fInew\fR?
If the optional argument \fInew\fR is specified, this method
modifies the change list (see subsection \fBEntry Instance Data\fR for
the exact format)\&. In both cases, current change list is
returned\&.
Warning: values returned by this method should only be used
by specialized methods such as \fBapply\fR or
\fBcommit\fR\&.
.TP
\fIce\fR \fBdiff\fR \fInew\fR ?\fIold\fR?
This method computes the differences between the \fInew\fR
and \fIold\fR entries under the form of a change list, and
stores this list into the current \fIchange\fR entry\&. If
the optional argument \fIold\fR is not specified, difference
is computed from the entry and its internal backup (see
section \fBOVERVIEW\fR)\&. Return value is the computed
change list\&.
.PP
.SS "ENTRY EXAMPLE"
.CS


    package require ldapx

    #
    # Create an entry and fill it as a standard entry with
    # attributes and values
    #
    ::ldapx::entry create e
    e dn "uid=joe,ou=people,o=mycomp"
    e set1 "uid"             "joe"
    e set  "objectClass"     {person anotherObjectClass}
    e set1 "givenName"       "Joe"
    e set1 "sn"              "User"
    e set  "telephoneNumber" {+31415926535 +2182818}
    e set1 "anotherAttr"     "This is a beautiful day, isn't it?"

    puts stdout "e\\n[e print]"

    #
    # Create a second entry as a backup of the first, and
    # make some changes on it\&.
    # Entry is named automatically by snit\&.
    #

    set b [::ldapx::entry create %AUTO%]
    e backup $b

    puts stdout "$b\\n[$b print]"

    $b del  "anotherAttr"
    $b del1 "objectClass" "anotherObjectClass"

    #
    # Create a change entry, a compute differences between first
    # and second entry\&.
    #

    ::ldapx::entry create c
    c diff e $b

    puts stdout "$c\\n[$c print]"

    #
    # Apply changes to first entry\&. It should be the same as the
    # second entry, now\&.
    #

    e apply c

    ::ldapx::entry create nc
    nc diff e $b

    puts stdout "nc\\n[nc print]"

    #
    # Clean-up
    #

    e destroy
    $b destroy
    c destroy
    nc destroy

.CE
.SH "LDAP CLASS"
.SS "LDAP INSTANCE DATA"
An instance of the \fBldap\fR class keeps the following data:
.TP
channel
This is the channel used by the \fBldap\fR package for
communication with the LDAP server\&.
.TP
lastError
This variable contains the error message which appeared in
the last method of the \fBldap\fR class (this string is
modified in nearly all methods)\&. The \fBerror\fR method
may be used to fetch this message\&.
.PP
.SS "LDAP OPTIONS"
A first set of options of the \fBldap\fR class is used during
search operations (methods \fBtraverse\fR, \fBsearch\fR and
\fBread\fR, see below)\&.
.TP
\fB-scope\fR \fBbase\fR|\fBone\fR|\fBsub\fR
Specify the scope of the LDAP search to be one of
\fBbase\fR, \fBone\fR or \fBsub\fR to specify
a base object, one-level or subtree search\&.
.sp
The default is \fBsub\fR\&.
.TP
\fB-derefaliases\fR \fBnever\fR|\fBseach\fR|\fBfind\fR|\fBalways\fR
Specify how aliases dereferencing is handled:
\fBnever\fR is used to specify that aliases are never derefenced,
\fBalways\fR that aliases are always derefenced,
\fBsearch\fR that aliases are dereferenced when searching,
or \fBfind\fR that aliases are dereferenced only  when
locating  the  base object for the search\&.
.sp
The default is \fBnever\fR\&.
.TP
\fB-sizelimit\fR integer
Specify the maximum number of entries to be retreived
during a search\&. A value of \fB0\fR means no limit\&.
.sp
Default is \fB0\fR\&.
.TP
\fB-timelimit\fR integer
Specify the time limit for a search to complete\&.
A value of \fB0\fR means no limit\&.
.sp
Default is \fB0\fR\&.
.TP
\fB-attrsonly\fR \fB0\fR|\fB1\fR
Specify if only attribute names are to be retrieved (value
\fB1\fR)\&. Normally (value \fB0\fR), attribute values
are also retrieved\&.
.sp
Default is \fB0\fR\&.
.PP
.PP
The last option is used when getting entries or committing changes
in the directory:
.TP
\fB-utf8\fR pattern-yes pattern-no
Specify which attribute values are encoded in UTF-8\&. This
information is specific to the LDAP schema in use by the
application, since some attributes such as jpegPhoto, for
example, are not encoded in UTF-8\&. This option takes the
form of a list with two regular expressions suitable for
the \fBregexp\fR command (anchored by ^ and $)\&.
The first specifies which attribute names are to be UTF-8
encoded, and the second selects, among those, the attribute
names which will not be UTF-8 encoded\&.  It is thus possible
to say: convert all attributes, except jpegPhoto\&.
.sp
Default is {{\&.*} {}}, meaning: all attributes are converted,
without exception\&.
.PP
.SS "LDAP METHODS"
.TP
\fIla\fR \fBerror\fR ?\fInewmsg\fR?
This method returns the error message that occurred in the
last call to a \fBldap\fR class method\&. If the optional
argument \fInewmsg\fR is supplied, it becomes the last
error message\&.
.TP
\fIla\fR \fBconnect\fR \fIurl\fR ?\fIbinddn\fR? ?\fIbindpw\fR?
This method connects to the LDAP server using given URL
(which can be of the form \fIldap://host:port\fR or
\fIldaps://host:port\fR)\&. If an optional \fIbinddn\fR
argument is given together with the \fIbindpw\fR argument,
the \fBconnect\fR binds to the LDAP server using the
specified DN and password\&.
.TP
\fIla\fR \fBdisconnect\fR
This method disconnects (and unbinds, if necessary) from
the LDAP server\&.
.TP
\fIla\fR \fBtraverse\fR \fIbase\fR \fIfilter\fR \fIattrs\fR \fIentry\fR \fIbody\fR
This method is a new control structure\&. It searches the
LDAP directory from the specified base DN (given by the
\fIbase\fR argument) and selects entries based on the
argument \fIfilter\fR\&. For each entry found, this method
fetches attributes specified by the \fIattrs\fR argument
(or all attributes if it is an empty list), stores them in
the \fIentry\fR instance of class \fBentry\fR and executes
the script defined by the argument \fIbody\fR\&. Options are
used to refine the search\&.
.sp
Caution: when this method is used, the script \fIbody\fR
cannot perform another LDAP search (methods \fBtraverse\fR,
\fBsearch\fR or \fBread\fR)\&.
.TP
\fIla\fR \fBsearch\fR \fIbase\fR \fIfilter\fR \fIattrs\fR
This method searches the directory using the same way as
method \fBtraverse\fR\&. All found entries are stored in
newly created instances of class \fBentry\fR, which are
returned in a list\&. The newly created instances should be
destroyed when they are no longer used\&.
.TP
\fIla\fR \fBread\fR \fIbase\fR \fIfilter\fR \fIentry\fR \&.\&.\&. \fIentry\fR
This method reads one or more entries, using the same search
criteria as methods \fBtraverse\fR and \fBsearch\fR\&.
All attributes are stored in the entries\&. This method
provides a quick way to read some entries\&. It returns the
number of entries found in the directory (which may be more
than the number of read entries)\&. If called without any
\fIentry\fR argument, this method just returns the number
of entries found, without returning any data\&.
.TP
\fIla\fR \fBcommit\fR \fIentry\fR \&.\&.\&. \fIentry\fR
This method commits the changes stored in the \fIentry\fR
arguments\&. Each \fIentry\fR may be either a \fIchange\fR
entry, or a \fIstandard\fR entry with a backup\&.
.sp
Note: in the future, this method should use the LDAP
transaction extension provided by OpenLDAP 2\&.3 and later\&.
.PP
.SS "LDAP EXAMPLE"
.CS


    package require ldapx

    #
    # Connects to the LDAP directory
    #

    ::ldapx::ldap create l
    set url "ldap://server\&.mycomp\&.com"
    if {! [l connect $url "cn=admin,o=mycomp" "mypasswd"]} then {
	puts stderr "error: [l error]"
	exit 1
    }

    #
    # Search all entries matching some criterion
    #

    l configure -scope one
    ::ldapx::entry create e
    set n 0
    l traverse "ou=people,o=mycomp" "(sn=Joe*)" {sn givenName} e {
	puts "dn: [e dn]"
	puts "  sn:        [e get1 sn]"
	puts "  givenName: [e get1 givenName]"
	incr n
    }
    puts "$n entries found"
    e destroy

    #
    # Add a telephone number to some entries
    # Note this modification cannot be done in the "traverse" operation\&.
    #

    set lent [l search "ou=people,o=mycomp" "(sn=Joe*)" {}]
    ::ldapx::entry create c
    foreach e $lent {
	$e backup
	$e add1 "telephoneNumber" "+31415926535"
	c diff $e
	if {! [l commit c]} then {
	    puts stderr "error: [l error]"
	    exit 1
	}
	$e destroy
    }
    c destroy

    l disconnect
    l destroy

.CE
.SH "LDIF CLASS"
.SS "LDIF INSTANCE DATA"
An instance of the \fBldif\fR class keeps the following data:
.TP
channel
This is the Tcl channel used to retrieve or store LDIF file
contents\&. The association between an instance and a channel
is made by the method \fBchannel\fR\&. There is no need
to disrupt this association when the LDIF file operation
has ended\&.
.TP
format
LDIF files may contain \fIstandard\fR entries or
\fIchange\fR entries, but not both\&. This variable contains
the detected format of the file (when reading) or the format
of entries written to the file (when writing)\&.
.TP
lastError
This variable contains the error message which appeared in
the last method of the \fBldif\fR class (this string is
modified in nearly all methods)\&. The \fBerror\fR method
may be used to fetch this message\&.
.TP
version
This is the version of the LDIF file\&. Only version 1 is
supported: the method \fBread\fR can only read from
version 1 files, and method \fBwrite\fR only creates
version 1 files\&.
.PP
.SS "LDIF OPTIONS"
This class defines two options:
.TP
\fB-ignore\fR list-of-attributes
This option is used to ignore certain attribute names on
reading\&. For example, to read OpenLDAP replica files (replog),
one must ignore \fBreplica\fR and \fBtime\fR attributes
since they do not conform to the RFC 2849 standard for LDIF
files\&.
.sp
Default is empty list: no attribute is ignored\&.
.TP
\fB-utf8\fR pattern-yes pattern-no
Specify which attribute values are encoded in UTF-8\&. This
information is specific to the LDAP schema in use by the
application, since some attributes such as jpegPhoto, for
example, are not encoded in UTF-8\&. This option takes the
form of a list with two regular expressions suitable for
the \fBregexp\fR command (anchored by ^ and $)\&.
The first specifies which attribute names are to be UTF-8
encoded, and the second selects, among those, the attribute
names which will not be UTF-8 encoded\&.  It is thus possible
to say: convert all attributes, except jpegPhoto\&.
.sp
Default is {{\&.*} {}}, meaning: all attributes are converted,
without exception\&.
.PP
.SS "LDIF METHODS"
.TP
\fIli\fR \fBchannel\fR \fIchan\fR
This method associates the Tcl channel named \fIchan\fR
with the LDIF instance\&. It resets the type of LDIF object
to \fIuninitialized\fR\&.
.TP
\fIli\fR \fBerror\fR ?\fInewmsg\fR?
This method returns the error message that occurred in the
last call to a \fBldif\fR class method\&. If the optional
argument \fInewmsg\fR is supplied, it becomes the last
error message\&.
.TP
\fIli\fR \fBread\fR \fIentry\fR
This method reads the next entry from the LDIF file and
stores it in the \fIentry\fR object of class \fBentry\fR\&.
The entry may be a \fIstandard\fR or \fIchange\fR entry\&.
.TP
\fIli\fR \fBwrite\fR \fIentry\fR
This method writes the entry given in the argument
\fIentry\fR to the LDIF file\&.
.PP
.SS "LDIF EXAMPLE"
.CS


    package require ldapx

    # This examples reads a LDIF file containing entries,
    # compare them to a LDAP directory, and writes on standard
    # output an LDIF file containing changes to apply to the
    # LDAP directory to match exactly the LDIF file\&.

    ::ldapx::ldif create liin
    liin channel stdin

    ::ldapx::ldif create liout
    liout channel stdout

    ::ldapx::ldap create la
    if {! [la connect "ldap://server\&.mycomp\&.com"]} then {
	puts stderr "error: [la error]"
	exit 1
    }
    la configure -scope one

    # Reads LDIF file

    ::ldapx::entry create e1
    ::ldapx::entry create e2
    ::ldapx::entry create c

    while {[liin read e1] != 0} {
	set base [e1 superior]
	set id [e1 rdn]
	if {[la read $base "($id)" e2] == 0} then {
	    e2 reset
	}

	c diff e1 e2
	if {[llength [c change]] != 0} then {
	    liout write c
	}
    }

    la disconnect
    la destroy
    e1 destroy
    e2 destroy
    c destroy
    liout destroy
    liin destroy

.CE
.SH REFERENCES
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIldap\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
directory access, internet, ldap, ldap client, ldif, protocol, rfc 2251, rfc 2849
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2006-2018 Pierre David <pdav@users\&.sourceforge\&.net>

.fi