.\" dselect manual page - dselect(1)
.\"
.\" Copyright © 1995 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 2000 Josip Rodin
.\" Copyright © 2001 Joost Kooij
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2010-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dselect 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dselect \- Interface de gestion de paquets Debian.
.
.SH SYNOPSIS
\fBdselect\fP [\fIoption\fP...] [\fIcommande\fP...]
.
.SH DESCRIPTION
\fBdselect\fP est une des principales interfaces de gestion des paquets sur un système Debian. À partir du menu principal de \fBdselect\fP, l'administrateur système peut\ :
 \- Mettre à jour la liste des versions des paquets disponibles,
 \- Voir l'état des paquets installés ou disponibles,
 \- Modifier les sélections de paquets et gérer les dépendances,
 \- Installer de nouveaux paquets ou mettre à niveau vers de nouvelles versions.
.PP
\fBdselect\fP operates as a front\-end to \fBdpkg\fP(1), the low\-level Debian
package handling tool. It features a full\-screen package selections manager
with package depends and conflicts resolver. When run with administrator
privileges, packages can be installed, upgraded and removed. Various access
methods can be configured to retrieve available package version information
and installable packages from package repositories.  Depending on the used
access method, these repositories can be public archive servers on the
internet, local archive servers or CD\-ROMs.  The recommended access method
is \fIapt\fP, which is provided by the package \fBapt\fP.
.PP
Normalement, \fBdselect\fP est appelé sans paramètre. Un menu interactif est
présenté, offrant à l'utilisateur une liste de commandes. Si une commande
est donnée en paramètre, alors cette commande est démarrée
immédiatement. Plusieurs paramètres en ligne de commande sont disponibles
pour modifier le comportement de \fBdselect\fP ou pour montrer des informations
supplémentaires sur le programme.
.
.SH OPTIONS
On peut spécifier une option à la fois sur la ligne de commande et dans le
fichier de configuration de \fBdselect\fP, \fI%PKGCONFDIR%/dselect.cfg\fP ou dans
les fichiers du répertoire de configuration
\fI%PKGCONFDIR%/dselect.cfg.d/\fP. Chaque ligne de ce fichier est soit une
option (identique à une option en ligne de commande mais sans tiret), soit
un commentaire (si il commence par «\ \fB#\fP\ »).
.br
.TP 
\fB\-\-admindir\fP\fI répertoire\fP
Change le répertoire où les fichiers «\ \fIstatus\fP\ », «\ \fIavailable\fP\ » et
autres sont situés. Le répertoire par défaut est \fI%ADMINDIR%\fP et il ne
devrait pas y avoir besoin de le modifier.
.TP 
\fB\-D\fP\fIfichier\fP, \fB\-\-debug\fP \fIfichier\fP
Activer le débogage. Les informations de débogage sont envoyées dans
\fIfichier\fP.
.TP 
\fB\-\-expert\fP
Activer le mode expert, c'est\-à\-dire ne pas afficher les messages d'aide
ennuyeux.
.TP 
\fB\-\-color\fP \fIpartie_écran:\fP[\fIpremier_plan\fP],[\fIarrière_plan\fP][\fI:attr\fP[\fI+attr\fP]...]
.TQ
\fB\-\-colour\fP \fIpartie_écran:\fP[\fIpremier_plan\fP],[\fIarrière_plan\fP][\fI:attr\fP[\fI+attr\fP]...]
Configure les couleurs des écrans. Cela ne fonctionne que si votre terminal
gère les couleurs. Cette option peut\-être utilisée plusieurs fois (et il est
préférable de l'utiliser dans \fIdselect.cfg\fP). Chaque utilisation change la
couleur (et, en option, d'autres attributs) d'une partie de l'écran. Les
parties de l'écran (de haut en bas) sont\ :
.RS
.TP 
\fBtitle\fP
Le titre de l'écran.
.TP 
\fBlisthead\fP
La ligne d'en\-tête au dessus de la liste de paquets.
.TP 
\fBlist\fP
La liste déroulante de paquets (et de textes explicatifs).
.TP 
\fBlistsel\fP
L'élément sélectionné dans la liste.
.TP 
\fBpkgstate\fP
Dans la liste des paquets, le texte qui indique l'état actuel de chaque
paquet.
.TP 
\fBpkgstatesel\fP
Dans la liste des paquets, le texte qui indique l'état actuel du paquet
sélectionné.
.TP 
\fBinfohead\fP
La ligne d'en\-tête qui affiche l'état du paquet sélectionné.
.TP 
\fBinfodesc\fP
La description courte du paquet.
.TP 
\fBinfo\fP
Utilisé pour afficher les informations sur le paquet, comme par exemple la
description du paquet.
.TP 
\fBinfofoot\fP
La dernière ligne de l'écran lors de la sélection des paquets.
.TP 
\fBquery\fP
Utilisé pour les lignes des recherches.
.TP 
\fBhelpscreen\fP
La couleur des écrans d'aide.
.RE
.IP
Après la partie de l'écran concernée, vient un signe deux\-points et la
spécification des couleurs. Pour surcharger les valeurs des couleurs
compilées, vous pouvez indiquer la couleur du premier plan, de
l'arrière\-plan, ou les deux. Utilisez les noms standard de couleurs curses.
.IP
En option, les spécifications des couleurs peuvent être suivies d'un signe
deux\-points et de la spécification d'un attribut. Il s'agit d'une liste
d'attributs, séparés par des caractères plus («\ +\ »). Parmi les attributs
disponibles, on trouve (tous ne fonctionnent pas sur tous les terminaux)\ :
\fBnormal\fP, \fBstandout\fP, \fBunderline\fP, \fBreverse\fP, \fBblink\fP, \fBbright\fP,
\fBdim\fP, \fBbold\fP.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche une aide rapide et se termine normalement.
.TP 
\fB\-\-version\fP
Affiche la version et se termine normalement.
.
.SH COMMANDES
Quand \fBdselect\fP est démarré, il peut effectuer les actions suivantes, soit
directement si elles sont indiquées dans la ligne de commande, soit
interactivement avec un menu de commandes possibles\ :
.SS "Accéder (access)"
Choisir et configurer une méthode d'accès aux dépôts de paquets.
.sp
Par défaut, \fBdselect\fP fournit plusieurs méthodes telles que \fIcdrom\fP,
\fImulti_cd\fP, \fInfs\fP, \fImulti_nfs\fP, \fIharddisk\fP, \fImounted\fP, \fImulti_mount\fP
ou \fIftp\fP, mais d'autres paquets peuvent fournir des méthodes
supplémentaires, comme la méthode d'accès \fIapt\fP fournie par le paquet
\fBapt\fP.
.sp
L'utilisation de la méthode d'accès \fIapt\fP est fortement conseillée.
.sp
.SS "Mise à jour (update)"
Rafraîchir la liste des paquets disponibles.
.sp
Récupère une liste de versions de paquets disponibles depuis un dépôt de
paquets, qui a été configuré pour la méthode d'accès actuelle, puis met à
jour la base de données de dpkg. Les listes de paquets sont d'habitude
fournies par les dépôts sous la forme de fichiers \fIPackages\fP ou
\fIPackages.gz\fP. Ces fichiers peuvent être générés par les responsables des
dépôts grâce au programme \fBdpkg\-scanpackages\fP(1).
.sp
Le fonctionnement détaillé de la commande de mise à jour dépend de
l'implémentation de la méthode d'accès. Normalement le processus se passe
tout seul, sans intervention de l'utilisateur.
.sp
.SS "Sélectionner (select)"
Voir ou gérer les paquets sélectionnés et les dépendances.
.sp
Il s'agit de la fonction principale de \fBdselect\fP. Dans l'écran de
sélection, l'utilisateur peut consulter la liste de tous les paquets
disponibles ou installés. Exécuté avec les privilèges administrateur, il
permet également de changer de façon interactive l'état de paquets
sélectionnés. \fBdselect\fP vérifie les implications de ces changements
vis\-à\-vis des dépendances et des conflits entre paquets.
.sp
Lorsqu'un conflit ou une dépendance manquante est détecté, un sous\-écran de
résolution des dépendances est proposé à l'utilisateur. Dans cet écran, une
liste de paquets avec des conflits ou avec des dépendances manquantes est
affichée et pour chaque paquet listé, la raison de sa présence dans cette
liste est indiquée. L'utilisateur peut ensuite appliquer les suggestion de
\fBdselect\fP, les modifier ou supprimer toutes les modifications, dont celles
qui ont créé les conflits ou dépendances non résolues.
.sp
L'utilisation de l'écran interactif des sélections de paquets est expliquée
de façon plus détaillée ci\-dessous.
.sp
.SS "Installer (install)"
Installer les paquets sélectionnés.
.sp
La méthode d'accès récupérera dans les dépôts les paquets qui peuvent être
installés ou mis à jour, puis les installe avec \fBdpkg\fP. En fonction de la
méthode d'accès, les paquets peuvent être tous récupérés avant installation,
ou récupérés à la demande. Certaines méthodes d'accès retirent également les
paquets qui ont été marqués pour être retirés.
.sp
Si une erreur apparaît lors de l'installation, il est recommandé de
redémarrer une installation. La plupart des fois, les problèmes
disparaissent ou sont résolus. Si les problèmes persistent ou si
l'installation n'est pas correcte, veuillez examiner les causes et
circonstances puis soumettez un rapport de bogue au système de suivi des
bogues Debian. Les instructions pour soumettre ces rapports de bogues se
trouvent sur https://bugs.debian.org/ ou dans la page de manuel de \fBbug\fP(1)
ou de \fBreportbug\fP(1), si ce paquet est installé.
.sp
Les détails de la commande d'installation dépendent de l'implémentation de
la méthode d'accès. L'attention et la contribution de l'utilisateur peuvent
être nécessaires lors de l'installation, de la configuration ou du retrait
des paquets. Cela dépend des scripts des responsables des paquets. Certains
paquets utilisent la bibliothèque \fBdebconf\fP(1), ce qui permet la mise en
place d'installations plus flexibles ou même automatisées.
.sp
.SS "Configurer (config)"
Configure les paquets déjà installés mais n'étant pas complètement
installés.
.sp
.SS "Retirer (remove)"
Retirer ou purger les paquets installés qui sont marqués comme étant à
retirer.
.sp
.SS "Quitter (quit)"
Quitter \fBdselect\fP.
.sp
Quitte le programme avec un code d'erreur de \fB0\fP (succès).
.sp
.
.SH "GESTION DE LA SÉLECTION DES PAQUETS"
.sp
.SS Introduction
.sp
\fBdselect\fP expose directement l'administrateur à une partie de la complexité
liée à la gestion d'un grand nombre de paquets ayant beaucoup de liens entre
eux. Pour un utilisateur qui n'est pas habitué aux concepts et au système de
gestion des paquets Debian, cela peut être perturbant. Mais \fBdselect\fP est
conçu pour aider la gestion et l'administration des paquets. Ce n'est qu'un
outil, et ne doit pas remplacer la compréhension et les aptitudes d'un
administrateur. L'utilisateur doit être familier des concepts sous\-jacents
au système de gestion des paquets Debian. En cas de doute, consultez la page
de manuel \fBdpkg\fP(1) et la Charte Debian.
.sp
À moins que \fBdselect\fP ne soit lancé en mode expert ou intermédiaire, un
message d'aide est d'abord affiché lorsque cette action est choisie dans le
menu. Il est \fBfortement\fP conseillé à l'utilisateur d'étudier toutes les
informations dans ces écrans d'aide lorsqu'ils apparaissent. Les écrans
d'aide peuvent être affichés à tout moment à l'aide de la touche «\ \fB?\fP\ ».
.sp
.SS "Disposition de l'écran"
.sp
L'écran de sélection est découpé par défaut en une moitié supérieure et une
moitié inférieure. La moitié supérieure affiche une liste de paquets. Un
curseur permet de sélectionner un paquet, ou un groupe de paquets en
sélectionnant le titre du groupe, si ça s'applique. La moitié inférieure de
l'écran affiche les détails du paquet sélectionné dans la moitié
supérieure. Le type de détail affiché peut varier.
.sp
Appuyez sur la touche «\ \fBI\fP\ » pour passer d'un affichage de la liste des
paquets en mode plein\-écran, à un affichage plus important des détails des
paquets ou à un mode partagé équitablement.
.sp
.SS "Vue des détails d'un paquet"
.sp
La vue des détails d'un paquet affiche par défaut la description longue du paquet sélectionné dans la liste des paquets. Le type de détail peut être modifié en pressant la touche «\ \fBi\fP\ ». Cela permet d'alterner entre\ :
 \- la description longue
 \- les informations de contrôle de la version installée
 \- les informations de contrôle de la version disponible
.sp
Dans un écran de résolution des dépendances, on peut également voir les
dépendances et conflits spécifiques au paquet qui expliquent la présence du
paquet dans la liste.
.sp
.SS "Liste des états des paquets"
.sp
L'écran principal de sélection affiche une liste de tous les paquets connus
par le système de gestion des paquets Debian. Cela inclut les paquets
installés sur le système et les paquets connus par la base de données des
paquets disponibles.
.sp
Pour tous les paquets, la liste affiche sur une ligne l'état du paquet, sa
priorité, sa section, les architectures installée et disponible, les
versions installée et disponible, le nom du paquet et sa description
courte. En appuyant sur la touche «\ \fBA\fP\ », on peut activer ou désactiver
l'affichage des architectures installée et disponible. En appuyant sur la
touche «\ \fBV\fP\ », on peut activer ou désactiver l'affichage des versions
installée et disponible. En appuyant sur la touche «\ \fBv\fP\ », l'affichage de
l'état passe d'un mode bavard à un mode raccourci. Par défaut, l'état
raccourci est utilisé.
.sp
L'état raccourci consiste en 4 parties\ : un drapeau d'erreur, qui est
habituellement vide, l'état courant, l'état de sélection précédent et l'état
de sélection actuel. Les deux premiers donnent des indications sur l'état
courant du paquet, les deux suivants concernent les sélections définies par
l'utilisateur.
.sp
Voici la signification des codes d'indication des états\ :
 Drapeau d'erreur\ :
  \fIvide\fP    aucune erreur\ ;
  \fBR\fP       erreur sérieuse, réinstallation nécessaire.
 État d'installation\ :
  \fIvide\fP    pas installé\ ;
  \fB*\fP       complètement installé et configuré\ ;
  \fB\-\fP       pas installé, mais des fichiers de configuration existent toujours\ ;
  \fBU\fP       dépaqueté, mais toujours pas configuré\ ;
  \fBC\fP       à moitié configuré (il y a eu une erreur)\ ;
  \fBI\fP       à moitié installé (il y a eu une erreur).
 Sélection actuelle et demandée\ :
  \fB*\fP       marqué comme étant à installer ou à mettre à jour\ ;
  \fB\-\fP       marqué comme étant à retirer, en conservant la configuration\ ;
  \fB=\fP       marqué comme étant à conserver\ : le paquet ne sera pas traité\ ;
  \fB_\fP       marqué comme étant à nettoyer, la configuration sera retirée également\ ;
  \fBn\fP       nouveau paquet, n'a toujours pas été marqué.
.sp
.SS "Déplacement du curseur et de l'écran"
.sp
Vous pouvez naviguer dans la liste de sélection des paquets et dans l'écran
de résolution des dépendances et des conflits à l'aide des touches
suivantes\ :
.br
  \fBp, Haut, k\fP             déplace le curseur vers le haut
  \fBn, Bas, j\fP              déplace le curseur vers le bas
  \fBP, Page\-préc., Effacer\fP fait défiler la liste d'une page vers le haut
  \fBN, Page\-suiv., Espace\fP  fait défiler la liste d'une page vers le bas
  \fB^p\fP                     fait défiler la liste d'une ligne vers le haut
  \fB^n\fP                     fait défiler la liste d'une ligne vers le bas
  \fBt, Home\fP                saute au début de la liste
  \fBe, Fin\fP                 saute à la fin de la liste
  \fBu\fP                      fait défiler les informations d'une page vers le haut
  \fBd\fP                      fait défiler les informations d'une page vers le bas
  \fB^u\fP                     fait défiler les informations d'une ligne vers le haut
  \fB^d\fP                     fait défiler les informations d'une ligne vers le bas
  \fBB, gauche\fP              déplace l'affichage de 1/3 vers la gauche
  \fBF, droite\fP              déplace l'affichage de 1/3 vers la droite
  \fB^b\fP                     déplace l'affichage d'un caractère vers la gauche
  \fB^f\fP                     déplace l'affichage d'un caractère vers la droite
.sp
.SS "Recherches et tris"
.sp
On peut rechercher un paquet par son nom dans la liste des paquets. Pour
cela, il faut presser la touche «\ \fB/\fP\ », puis taper le texte à
rechercher. Ce texte est interprété comme une expression rationnelle (voir
\fBregex\fP(7)). Si vous ajoutez «\ \fB/d\fP\ » à la recherche, dselect recherchera
également dans les descriptions. Si vous ajoutez «\ \fB/i\fP\ », la recherche ne
prend pas en compte la casse. Les deux suffixes peuvent être combinés comme
ceci\ : «\ \fB/id\fP\ ». La recherche peut être répétée en appuyant sur la touche
«\ \fBn\fP\ » ou «\ \fB\e\fP\ », jusqu'à ce que le paquet soit trouvé. Lorsque la
recherche atteint la fin de la liste, elle recommence au début.
.sp
On peut changer l'ordre du tri en appuyant sur la touche «\ \fBo\fP\ » ou «\ \fBO\fP\ ». Les neuf systèmes de tris suivants existent\ :
 alphabétique      disponible           état
 priorité+section  disponible+priorité  état+priorité
 section+priorité  disponible+section   état+section
.br
Lorsqu'il n'est pas indiqué, l'ordre alphabétique est utilisé comme dernier
critère de tri.
.sp
.SS "Modifier les sélections"
.sp
Le type de sélection demandé d'un paquet peut être changé à l'aide des commandes suivantes\ :
  \fB+, Inser\fP     installer ou mettre à jour
  \fB=, H\fP         à garder dans l'état et la version actuels
  \fB:, G\fP         ne plus garder\ : mettre à niveau ou laisser non installé
  \fB\-, Suppr\fP     retirer, en gardant la configuration
  \fB_\fP            retirer et supprimer la configuration
.sp
Lorsque la demande de modification entraîne des dépendances non satisfaites
ou des conflits, \fBdselect\fP fournit à l'utilisateur un écran de résolution
des dépendances. Cela sera décrit plus tard.
.sp
Il est également possible d'appliquer ces commandes à des groupes de
sélections de paquets en plaçant le curseur sur le titre d'un groupe. Le
regroupement des paquets dépend de la façon dont les paquets sont triés dans
la liste.
.sp
Une attention particulière doit être prise lors de la modification de grands
groupes de sélections, parce qu'ils peuvent créer rapidement un nombre
important de dépendances non résolues ou de conflits, qui seraient tous
listés dans un écran de résolution de dépendances, le rendant difficile à
utiliser. En pratique, seules les opérations «\ à garder\ » et «\ ne plus
garder\ » sont utiles pour les groupes.
.sp
.SS "Résoudre les dépendances et les conflits"
.sp
Lorsque la demande de modification entraîne des dépendances non satisfaites
ou des conflits, \fBdselect\fP fournit à l'utilisateur un écran de résolution
des dépendances. Mais un écran d'information est affiché dans un premier
temps.
.sp
La moitié supérieure de cet écran liste tous les paquets ayant des
dépendances non résolues ou des conflits dus aux modifications demandées,
ainsi que les paquets dont l'installation permettrait de résoudre une
dépendance ou dont le retrait permettrait de résoudre un conflit. La moitié
inférieure affiche par défaut les dépendances ou conflits pour lesquels le
paquet sélectionné se trouve présent dans la liste.
.sp
Quand la sous\-liste de paquets est affichée pour la première fois,
\fBdselect\fP peut avoir déjà fixé les états demandés pour certains des paquets
listés, cela afin de résoudre les dépendances ou les conflits qui ont causé
l'apparition de l'écran de résolution des dépendances. Il est habituellement
recommandé de suivre les suggestions de \fBdselect\fP.
.sp
L'état de sélection des paquets listés peut être remis dans son état
précédent, avant que le problème de dépendance ou le conflit ne soit créé,
en appuyant sur la touche «\ \fBR\fP\ ». La touche «\ \fBD\fP\ » permet de remettre à
zéro les suggestions automatiques, tout en conservant les modifications qui
ont causé l'apparition de l'écran de résolution des dépendances. Enfin, la
touche «\ \fBU\fP\ » permet de rétablir les suggestions automatiques.
.sp
.SS "Établir les sélections demandées"
.sp
En appuyant sur \fBEntrée\fP, les sélections affichées sont acceptées. Si
\fBdselect\fP ne détecte pas de dépendances non résolues du fait de ces
sélections, les nouvelles sélections sont établies. Cependant, si des
dépendances non résolues sont trouvées, \fBdselect\fP affichera de nouveau un
écran de résolution des dépendances.
.sp
Pour modifier un jeu de sélections qui causent des dépendances non résolues
ou des conflits, et forcer \fBdselect\fP à l'accepter, appuyez sur la touche
«\ \fBQ\fP\ ». Cela fixe les sélections telles qu'elles sont définies par
l'utilisateur, sans condition. En général, ne faites pas cela, sauf si vous
avez bien lu ce qu'il y a d'écrit.
.sp
L'effet inverse, qui consiste à oublier les demandes de modification des
sélections et revenir à la liste précédente de sélections, peut être obtenu
en appuyant sur la touche «\ \fBX\fP\ » ou «\ \fBEchap\fP\ ». En répétant l'opération,
on peut complètement revenir à la dernière configuration établie.
.sp
Si vous avez fixé certains paramètres de façon erronée et que vous souhaitez
revenir en arrière sur ce qui est actuellement installé sur le système,
appuyez sur la touche «\ \fBC\fP\ ». C'est un peu comme utiliser la commande de
déblocage sur tous les paquets, mais cela offre un bouton panique plus
évident pour les cas où l'utilisateur a appuyé sur \fBentrée\fP
accidentellement.
.sp
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
La commande demandée s'est correctement déroulée.
.TP 
\fB2\fP
Erreur fatale ou irrécupérable due à l'utilisation d'une ligne de commande
non valable, ou interactions avec le système, telles que des accès à la base
de données, des allocations de mémoire,\ etc.
.
.SH ENVIRONNEMENT
.TP 
\fBHOME\fP
Si positionné, sera utilisé par \fBdselect\fP comme le répertoire d'où sera lu
le fichier de configuration propre à l'utilisateur.
.
.SH BOGUES
L'interface \fBdselect\fP de sélection de paquets est déroutante pour les
nouveaux utilisateurs. On rapporte même qu'elle fait pleurer certains
développeurs chevronnés du noyau.
.sp
La documentation manque.
.sp
Il n'existe pas d'option d'aide dans le menu.
.sp
La liste visible des paquets disponibles ne peut pas être réduite.
.sp
La méthode d'accès intégrée ne satisfait pas les normes de qualité
actuelles. Utilisez plutôt la méthode fournie par APT. Non seulement elle
n'est pas cassée, mais en plus elle est plus souple que la méthode d'accès
intégrée.
.
.SH "VOIR AUSSI"
\fBdpkg\fP(1), \fBapt\-get\fP(8), \fBsources.list\fP(5), \fBdeb\fP(5).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
