.\" dpkg manual page - dpkg(1)
.\"
.\" Copyright © 1996 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 1999 Jim Van Zandt <jrv@vanzandt.mv.com>
.\" Copyright © 1999-2003 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2000-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2002 Josip Rodin
.\" Copyright © 2004-2005 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2006-2016 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dpkg \- Gestionnaire de paquet pour Debian
.
.SH SYNOPSIS
\fBdpkg\fP [\fIoption\fP...] \fIaction\fP
.
.SH AVERTISSEMENT
Ce manuel est destiné aux utilisateurs qui souhaitent aller au\-delà de la
commande \fBdpkg \-\-help\fP pour la compréhension des options de la ligne de
commande et des états des paquets.

Les responsables de paquet qui veulent comprendre comment \fBdpkg\fP installe
leur paquet \fIne doivent pas\fP l'utiliser. Les descriptions concernant
l'installation ou la désinstallation des paquets sont très insuffisantes.
.
.SH DESCRIPTION
\fBdpkg\fP est un outil pour l'installation, la création, la suppression et la
gestion des paquets Debian. \fBaptitude\fP(1) est la principale interface à
\fBdpkg\fP et la plus agréable pour l'utilisateur. \fBdpkg\fP lui\-même est
entièrement contrôlé par des paramètres sur la ligne de commande. Une
commande comporte exactement une action et zéro ou plusieurs options. Le
paramètre «\ action\ » dit ce que \fBdpkg\fP doit faire et les options modifient
l'action d'une manière ou d'une autre.

\fBdpkg\fP peut également être utilisé comme interface pour \fBdpkg\-deb\fP(1) et
\fBdpkg\-query\fP(1). La liste des actions gérées est indiquée dans la section
\fBACTIONS\fP. Si cette section est présente, \fBdpkg\fP n'exécute que \fBdpkg\-deb\fP
ou \fBdpkg\-query\fP avec les paramètres qui lui sont passés, mais aucune action
spécifique ne leur est communiquée. Pour utiliser cela, il est nécessaire
d'appeler le programme directement.
.
.SH "RENSEIGNEMENTS SUR LES PAQUETS"
\fBdpkg\fP conserve des renseignements utiles sur les paquets
disponibles. Cette information est divisée en trois classes\ : les états, les
états de la sélection et les drapeaux. La modification de ces valeurs est
principalement dévolue à \fBdselect\fP.
.SS "États du paquet\ :"
.TP 
\fBnot\-installed\fP
Le paquet n'est pas installé sur le système.
.TP 
\fBconfig\-files\fP
Seuls les fichiers de configuration du paquet existent sur le système.
.TP 
\fBhalf\-installed\fP
L'installation du paquet a commencé mais, pour une raison quelconque, ne
s'est pas terminée.
.TP 
\fBunpacked\fP
Le paquet est dépaqueté mais n'est pas configuré.
.TP 
\fBhalf\-configured\fP
Le paquet est dépaqueté et la configuration a commencé mais, pour une
quelconque raison, ne s'est pas terminée.
.TP 
\fBtriggers\-awaited\fP
Le paquet attend l'exécution d'une action différée qui est à la charge d'un
autre paquet.
.TP 
\fBtriggers\-pending\fP
Une action différée de ce paquet a été activée, il reste à l'exécuter.
.TP 
\fBinstalled\fP
Le paquet est correctement dépaqueté et configuré.
.SS "États de sélection des paquets"
.TP 
\fBinstall\fP
Le paquet est sélectionné pour être installé.
.TP 
\fBhold\fP
A package marked to be on \fBhold\fP is kept on the same version, that is, no
automatic new installs, upgrades or removals will be performed on them,
unless these actions are requested explicitly, or are permitted to be done
automatically with the \fB\-\-force\-hold\fP option.
.TP 
\fBdeinstall\fP
Le paquet est sélectionné pour être désinstallé (c'est\-à\-dire qu'on veut
supprimer tous les fichiers à l'exception des fichiers de configuration).
.TP 
\fBpurge\fP
Le paquet est sélectionné pour être purgé (c'est\-à\-dire qu'on veut tout
supprimer dans les répertoires du système, même les fichiers de
configuration).
.TP 
\fBunknown\fP
La sélection de paquets est inconnue. Un paquet qui est aussi dans un état
\fBnot\-installed\fP et avec un drapeau \fBok\fP sera oublié dans le prochain
enregistrement de la base de données.
.SS "Drapeaux du paquet\ :"
.TP 
\fBok\fP
Un paquet marqué \fBok\fP est dans un état connu, mais pourrait nécessiter un
traitement supplémentaire.
.TP 
\fBreinstreq\fP
Un paquet marqué \fBreinstreq\fP est défectueux et demande une
réinstallation. \fBdpkg\fP ne peut supprimer ces paquets, à moins qu'il ne soit
lancé avec l'option de forçage \fB\-\-force\-remove\-reinstreq\fP.
.
.SH ACTIONS
.TP 
\fB\-i\fP, \fB\-\-install\fP \fIfichier\-paquet\fP...
Installe le paquet. Si l'option \fB\-\-recursive\fP ou \fB\-R\fP est utilisée,
\fIfichier\-paquet\fP doit alors être un répertoire.

L'installation comporte les étapes suivantes\ :
.br

\fB1.\fP Extraction des fichiers de contrôle du nouveau paquet.
.br

\fB2.\fP Quand une ancienne version du même paquet est déjà installée,
exécution du script \fIprerm\fP de l'ancien paquet.
.br

\fB3.\fP Lancement du script \fIpreinst\fP, s'il est fourni par le paquet.
.br

\fB4.\fP Dépaquetage des nouveaux fichiers et, en même temps, sauvegarde des
anciens de manière à pouvoir les restaurer si quelque chose tourne mal.
.br

\fB5.\fP Quand une ancienne version du même paquet est déjà installée,
exécution du script \fIpostrm\fP de l'ancien paquet. Il faut remarquer que ce
script est exécuté après le script \fIpreinst\fP du nouveau paquet, parce que
les nouveaux fichiers sont écrits dans le même temps que les anciens sont
supprimés.
.br

\fB6.\fP Configuration du paquet. Voyez l'action \fB\-\-configure\fP pour savoir
comment cela se passe.
.TP 
\fB\-\-unpack \fP\fIfichier\-paquet\fP...
Dépaquète le paquet mais ne configure rien. Si l'option \fB\-\-recursive\fP ou
\fB\-R\fP est utilisée, \fIfichier\-paquet\fP doit alors indiquer un répertoire.
.TP 
\fB\-\-configure \fP\fIpaquet\fP...|\fB\-a\fP|\fB\-\-pending\fP
Configuration d'un paquet dépaqueté mais non encore configuré. Si l'option
\fB\-a\fP ou \fB\-\-pending\fP est utilisée au lieu de \fIpaquet\fP, tous les paquets
dépaquetés mais non configurés sont configurés.

Pour reconfigurer un paquet qui l'a déjà été, vous devriez plutôt utiliser
la commande \fBdpkg\-reconfigure\fP(8).

La configuration comporte les étapes suivantes\ :
.br

\fB1.\fP Dépaquetage des fichiers de configuration, et dans le même temps
sauvegarde des anciens fichiers de configuration, de manière à pouvoir les
restaurer si quelque chose se passe mal.
.br

\fB2.\fP Exécution du script \fBpostinst\fP, s'il est fourni par le paquet.
.TP 
\fB\-\-triggers\-only\fP \fIpaquet\fP ...|\fB\-a\fP | \fB\-\-pending\fP
N'exécute que les actions différées (depuis dpkg\ 1.14.17). Toutes les
actions différées en attente seront traitées. Si des noms de paquets sont
fournis, les actions différées de ces paquets seront traitées, une fois
chacune lorsque nécessaire. L'utilisation de cette option peut laisser des
paquets dans les états incorrects de \fBtriggers\-awaited\fP et de
\fBtriggers\-pending\fP. Cela peut être corrigé plus tard en exécutant\ : \fBdpkg
\-\-configure \-\-pending\fP.
.TP 
\fB\-r\fP, \fB\-\-remove\fP \fIpaquet\fP...|\fB\-a\fP|\fB\-\-pending\fP
Supprimer un paquet installé. Cela supprime tout à l'exception des fichiers
de configuration et les autres données nettoyées par le script \fIpostrm\fP, ce
qui évite d'avoir à reconfigurer le paquet s'il était réinstallé par la
suite (ces fichiers sont les fichiers de configuration listés dans le
fichier de contrôle \fIDEBIAN/conffiles\fP). S'il n'y a pas de fichier de
contrôle \fIDEBIAN/conffiles\fP ni script \fIDEBIAN/postrm\fP, cette commande est,
équivalente à l'appel de \fB\-\-purge\fP. Si \fB\-a\fP ou \fB\-\-pending\fP est indiqué à
la place d'un nom de paquet, alors tous les paquets dépaquetés mais marqués
pour suppression dans le fichier \fI%ADMINDIR%/status\fP seront supprimés.

La suppression d'un paquet comporte les étapes suivantes\ :
.br

\fB1.\fP Lancement du script \fIprerm\fP
.br

\fB2.\fP Suppression des fichiers installés
.br

\fB3.\fP Lancement du script \fIpostrm\fP
.br

.TP 
\fB\-P\fP, \fB\-\-purge\fP \fIpaquet\fP...|\fB\-a\fP|\fB\-\-pending\fP
Purger un paquet installé ou déjà supprimé. L'action supprime tout, y
compris les fichiers de configuration et tout le reste nettoyé de
\fIpostrm\fP. Si \fB\-a\fP ou \fB\-\-pending\fP est indiqué à la place d'un nom de
paquet, tous les paquets dépaquetés ou supprimés mais marqués dans le
fichier \fI%ADMINDIR%/status\fP comme devant être purgés seront purgés.

Note\ : certains fichiers de configuration peuvent être inconnus de \fBdpkg\fP
car ils sont créés et gérés séparément par le biais de scripts de
configuration. En ce cas, \fBdpkg\fP ne les supprimera pas lui\-même et le
script \fIpostrm\fP du paquet devra s'en charger durant l'opération de
purge. Cela ne s'applique bien entendu qu'aux fichiers situés dans les
répertoires systèmes et non aux fichiers de configuration créés dans les
répertoires «\ home\ » des utilisateurs.

La suppression d'un paquet comporte les étapes suivantes\ :
.br

\fB1.\fP Supprime le paquet s'il n'est pas déjà supprimé. Voir \fB\-\-remove\fP pour
plus de détails sur la façon dont cela est fait.
.br

\fB2.\fP Exécuter le script \fIpostrm\fP.
.br
.TP 
\fB\-V\fP, \fB\-\-verify\fP \fInom\-du\-paquet\fP...
Vérifie l'intégrité du \fInom\-du\-paquet\fP ou de tous les paquets, si omis, en
comparant l'information des fichiers installés par un paquet avec
l'information des métadonnées des fichiers stockée dans la base de données
de \fBdpkg\fP (depuis dpkg\ 1.17.2). L'origine de l'information des métadonnées
des fichiers dans la base de données, ce sont les paquets binaires
eux\-mêmes. Ces métadonnées sont collectées au moment du dépaquetage des
paquets durant le processus d'installation.

Actuellement la seule vérification fonctionnelle effectuée est une
comparaison des sommes de contrôle MD5 du contenu des fichier par rapport
aux valeurs stockées dans la base de données des fichiers. La vérification
n'a lieu que si la base de données contient les informations
nécessaires. Pour vérifier si des métadonnées manquent dans la base de
données, la commande \fB\-\-audit\fP peut être employée.

On peut choisir le format de sortie avec l'option \fB\-\-verify\-format\fP, par
défaut c'est le format \fBrpm\fP, mais cela pourrait changer dans le futur, et
selon le format que les programmes analysant cette sortie de commande
pourraient explicitement attendre.
.TP 
\fB\-C\fP, \fB\-\-audit\fP \fInom\-du\-paquet\fP...
Effectue une vérification du bon état et de consistance de la base de
données sur le \fInom\-du\-paquet\fP ou sur tous les paquets si omis
(vérification par paquet depuis dpkg\ 1.17.10). Par exemple, recherche les
paquets qui n'ont été que partiellement installés sur le système ou qui ont
des données de contrôle ou des fichiers manquants, incorrects ou
obsolètes. \fBdpkg\fP suggère une manière de les corriger.
.TP 
\fB\-\-update\-avail\fP [\fIfichier\-Paquets\fP]
.TQ
\fB\-\-merge\-avail\fP [\fIfichier\-Paquets\fP]
Met à jour l'information de \fBdpkg\fP et de \fBdselect\fP sur les paquets
disponibles. L'action \fB\-\-merge\-avail\fP combine les informations anciennes
avec celles qui proviennent du fichier \fIfichier\-Packages\fP. L'action
\fB\-\-update\-avail\fP remplace les informations anciennes par celles qui
proviennent du fichier \fIfichier\-Packages\fP. Le fichier \fIfichier\-Packages\fP
distribué avec Debian est appelé simplement «\ \fIPackages\fP\ ». Si le paramètre
\fIfichier\-Packages\fP est manquant ou est nommé «\ \fB\-\fP\ », alors, il sera lu à
partir de l'entrée standard (depuis dpkg\ 1.17.7). \fBdpkg\fP garde son propre
enregistrement des paquets disponibles dans \fI%ADMINDIR%/available\fP.

Une simple commande permettant de récupérer et mettre à jour le fichier
\fIavailable\fP est \fBdselect update\fP. Veuillez noter que ce fichier est à peu
près inutile si vous n'utilisez pas \fBdselect\fP mais une interface basée sur
APT. APT contient en effet son propre mécanisme pour suivre les paquets
disponibles.
.TP 
\fB\-A\fP, \fB\-\-record\-avail\fP \fIfichier\-paquet\fP...
Met à jour l'information de \fBdpkg\fP et de \fBdselect\fP sur les paquets
disponibles avec les informations qui proviennent de \fIfichier\-paquet\fP. Si
l'option \fB\-\-recursive\fP ou \fB\-R\fP est utilisée, \fIfichier\-paquet\fP doit
indiquer un répertoire.
.TP 
\fB\-\-forget\-old\-unavail\fP
Désormais \fBobsolète\fP et sans effet car \fBdpkg\fP oublie automatiquement les
paquets désinstallés qui ne sont pas disponibles depuis (dpkg\ 1.15.4), mais
seulement ceux qui ne contiennent pas d'informations pour l'utilisateur
comme les sélections de paquets.
.TP 
\fB\-\-clear\-avail\fP
Efface les renseignements existants sur les paquets disponibles.
.TP 
\fB\-\-get\-selections\fP [\fImotif\-de\-nom\-de\-paquet\fP...]
Obtient la liste des sélections de paquets et l'envoie sur la sortie
standard. Sans un motif, les paquets non installés (c'est\-à\-dire ceux qui
ont été précédemment purgés) ne seront pas affichés.
.TP 
\fB\-\-set\-selections\fP
Modifie la liste des sélections des paquets en lisant un fichier sur
l'entrée standard. Le format de ce fichier doit être de la forme «\ \fIpaquet\fP
\fIétat\fP\ », où état vaut \fBinstall\fP, \fBhold\fP, \fBdeinstall\fP ou \fBpurge\fP. Les
lignes vides ou les lignes de commentaires débutant par «\ \fB#\fP\ » sont
autorisées.

Le fichier \fIavailable\fP doit être à jour pour que cette commande soit utile,
autrement des paquets inconnus seront ignorés avec un
avertissement. Veuillez consultez les commandes \fB\-\-update\-avail\fP et
\fB\-\-merge\-avail\fP pour plus d'informations.
.TP 
\fB\-\-clear\-selections\fP
Met l'état de chaque paquet non essentiel à «\ deinstall\ » (depuis
dpkg\ 1.13.18). Il faut utiliser cette option juste avant
\fB\-\-set\-selections\fP, pour désinstaller les paquets qui ne sont pas affichés
par \fB\-\-set\-selections\fP.
.TP 
\fB\-\-yet\-to\-unpack\fP
Recherche les paquets qui ont été sélectionnés pour l'installation, mais
qui, pour une raison quelconque, ne sont pas encore installés.
.IP
Note\ : cette commande utilise à la fois le fichier disponible et les
sélections de paquets.
.TP 
\fB\-\-predep\-package\fP
Affiche un fichier unique qui est la cible d'une ou plusieurs
pré\-dépendances correspondantes et n'a lui\-même pas de pré\-dépendances
insatisfaites.
.IP
Si un tel paquet est présent, l'affiche comme entrée du fichier Packages, et
il peut être manipulé comme il se doit.
.IP
Note\ : cette commande utilise à la fois le fichier disponible et les
sélections de paquets.
.IP
Renvoie \fB0\fP si un paquet est affiché, \fB1\fP quand il n'y a pas de paquet
adéquat disponible et \fB2\fP en cas d'erreur.
.TP 
\fB\-\-add\-architecture \fP\fIarchitecture\fP
Ajoute \fIarchitecture\fP à la liste d'architectures pour lesquelles les
paquets peuvent être installés sans utiliser \fB\-\-force\-architecture\fP (depuis
dpkg\ 1.16.2). L'architecture pour laquelle \fBdpkg\fP est compilé (c'est\-à\-dire
ce qu'affiche \fB\-\-print\-architecture\fP) est toujours incluse dans cette
liste.
.TP 
\fB\-\-remove\-architecture \fP\fIarchitecture\fP
Retire \fIarchitecture\fP de la liste d'architectures pour lesquelles les
paquets peuvent être installés sans utiliser \fB\-\-force\-architecture\fP (depuis
dpkg\ 1.16.2). Si cette architecture est actuellement utilisée dans la base
de données, cette opération sera rejetée, sauf si \fB\-\-force\-architecture\fP
est utilisé. L'architecture pour laquelle \fBdpkg\fP est compilé (c'est\-à\-dire
ce qu'affiche \fB\-\-print\-architecture\fP) ne peut jamais être retirée de cette
liste.
.TP 
\fB\-\-print\-architecture\fP
Affiche l'architecture des paquets installés (par exemple, «\ i386\ »).
.TP 
\fB\-\-print\-foreign\-architectures\fP
Affiche la liste, à raison d'une par ligne, des architectures
supplémentaires pour lesquelles \fBdpkg\fP est autorisé à installer des paquets
(depuis dpkg\ 1.16.2).
.TP 
\fB\-\-assert=\fP\fIfonction\fP
Déclare que \fBdpkg\fP prend en charge la fonction requise. Renvoie \fB0\fP si la
fonction est complètement prise en charge, \fB1\fP si la fonction est reconnue
mais que \fBdpkg\fP ne peut pas encore fournir sa prise en charge, et \fB2\fP si
la fonction est inconnue. La liste actuelle des fonctions déclarables est\ :
.RS
.TP 
\fBsupport\-predepends\fP
Gère le champ \fBPre\-Depends\fP (depuis\ dpkg\ 1.1.0).
.TP 
\fBworking\-epoch\fP
Gère les «\ epochs\ » dans les chaînes de version (depuis dpkg\ 1.4.0.7).
.TP 
\fBlongs\-noms\-de\-fichier\fP
Gère les longs noms de fichier dans les archives \fBdeb\fP(5) (depuis
dpkg\ 1.4.1.17).
.TP 
\fBmulti\-conrep\fP
Gère plusieurs \fBConflicts\fP et \fBReplaces\fP (depuis dpkg\ 1.4.1.19).
.TP 
\fBmulti\-arch\fP
Gère les champs et les sémantiques multi\-architectures (depuis dpkg\ 1.16.2).
.TP 
\fBversioned\-provides\fP
Gère les \fBProvides\fP versionnés (depuis dpkg\ 1.17.11).
.RE
.TP 
\fB\-\-validate\-\fP\fIchaîne\-quelque\-chose\fP
Valide que la \fIchaîne\fP \fIquelque\-chose\fP a une syntaxe correcte (depuis
dpkg\ 1.18.16). Renvoie \fB0\fP si la \fIchaîne\fP est valable, \fB1\fP si la
\fIchaîne\fP n'est pas valable mais pourrait être accepté dans des contextes
tolérants, et \fB2\fP si la chaîne n'est pas valable. La liste actuelle des
\fIquelque\-chose\fPs acceptables est\ :
.RS
.TP 
\fBpkgname\fP
Valide le nom de paquet donné (depuis dpkg\ 1.18.16).
.TP 
\fBtrigname\fP
Valide le nom d'action différée donné (depuis dpkg\ 1.18.16).
.TP 
\fBarchname\fP
Valide le nom d'architecture donné (depuis dpkg\ 1.18.16).
.TP 
\fBversion\fP
Valide la version donnée (depuis dpkg\ 1.18.16).
.RE
.TP 
\fB\-\-compare\-versions \fP\fIver1 op ver2\fP
.\" .TP
.\" .B \-\-command\-fd \fIn\fP
.\" Accept a series of commands on input file descriptor \fIn\fP. Note:
.\" additional options set on the command line, and through this file descriptor,
.\" are not reset for subsequent commands executed during the same run.
Compare des numéros de version, où \fIop\fP est un opérateur binaire. \fBdpkg\fP
renvoie «\ true\ » (\fB0\fP) si la condition spécifiée est vérifiée, et renvoie
«\ false\ » (\fB1\fP) dans le cas contraire. Il y a deux groupes d'opérateurs\ ;
ils diffèrent par leur façon de traiter l'absence de \fIver1\fP ou de
\fIver2\fP. Pour les opérateurs suivants, \fBlt le eq ne ge gt\fP, l'absence d'une
version est considérée comme inférieure à toute version\ ; pour les
opérateurs \fBlt\-nl le\-nl ge\-nl gt\-nl\fP, l'absence d'une version est
considérée comme supérieure à toute version. Les opérateurs \fB<
<< <= = >= >> >\fP ne sont fournis que pour la
compatibilité avec la syntaxe du fichier de contrôle. Les opérateurs
\fB<\fP et \fB>\fP sont obsolètes et ne devraient \fBpas\fP être utilisés du
fait d'une sémantique pas claire. Comme illustration, \fB0.1< 0.1\fP est
évaluée à vrai.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un court message d'aide.
.TP 
\fB\-\-force\-help\fP
Donne des renseignements sur les options \fB\-\-force\-\fP\fIquelque\-chose\fP.
.TP 
\fB\-Dh\fP, \fB\-\-debug=help\fP
Donne des renseignements sur les options de débogage.
.TP 
\fB\-\-version\fP
Affiche la version de \fBdpkg\fP.
.TP 
\fBdpkg\-deb actions\fP
Voyez \fBdpkg\-deb\fP(1) pour des renseignements supplémentaires sur les actions
suivantes.

.nf
\fB\-b\fP, \fB\-\-build\fP \fIrépertoire\fP [\fIarchive\fP|\fIrépertoire\fP]
    Construit un paquet deb.
\fB\-c\fP, \fB\-\-contents\fP \fIarchive\fP
    Liste le contenu d'un paquet deb.
\fB\-e\fP, \fB\-\-control\fP \fIarchive\fP [\fIrépertoire\fP]
    Extrait les informations de contrôle d'un paquet.
\fB\-x\fP, \fB\-\-extract\fP \fIarchive répertoire\fP
    Extrait et affiche les fichiers contenus dans un paquet.
\fB\-X\fP, \fB\-\-vextract\fP \fIarchive répertoire\fP
    Extrait et affiche les noms de fichiers contenus dans un
    paquet.
\fB\-f\fP, \fB\-\-field\fP \fIarchive\fP [\fIchamp de contrôle\fP] ...
    Affiche le(s) champ(s) de contrôle d'un paquet.
\fB\-\-ctrl\-tarfile\fP \fIarchive\fP
    Produit le contenu du fichier tar de contrôle d'un paquet Debian.
\fB\-\-fsys\-tarfile\fP \fIarchive\fP
    Produit le contenu du fichier tar du système de fichiers d'un
    paquet Debian.
\fB\-I\fP, \fB\-\-info\fP \fIarchive\fP [\fIfichier de contrôle\fP]
    Affiche des renseignements sur un paquet.
.fi

.TP 
\fBdpkg\-query actions\fP
Voyez \fBdpkg\-query\fP(1) pour davantage d'explications sur les actions
suivantes.

.nf

\fB\-l\fP, \fB\-\-list\fP \fImotif\-du\-nom\-de\-paquet\fP ...
    Affiche la liste des paquets qui correspondent au motif.
\fB\-s\fP, \fB\-\-status\fP \fInom\-du\-paquet\fP ...
    Donne l'état du paquet indiqué.
\fB\-L\fP, \fB\-\-listfiles\fP \fInom\-du\-paquet\fP ...
    Affiche la liste des fichiers installés qui appartiennent
    à \fIpaquet\fP.
\fB\-S\fP, \fB\-\-search\fP \fImotif\-du\-fichier\-à\-rechercher\fP ...
    Recherche un fichier dans les paquets installés.
\fB\-p\fP, \fB\-\-print\-avail\fP \fInom\-du\-paquet\fP
    Affiche les informations trouvées dans \fI%ADMINDIR%/available\fP
    à propos de \fIpaquet\fP. Les utilisateurs des interfaces à APT
    devraient plutôt utiliser \fBapt\-cache show\fP \fInom\-du\-paquet\fP.
.fi
.
.SH OPTIONS
On peut spécifier toutes les options à la fois sur la ligne de commande,
dans le fichier de configuration de \fBdpkg\fP, \fI%PKGCONFDIR%/dpkg.cfg\fP ou
dans les fragments de fichiers du répertoire de configuration
\fI%PKGCONFDIR%/dpkg.cfg.d/\fP (avec un nom qui respecte le motif
«\ [0\-9a\-zA\-Z_\-]*\ »). Chaque ligne de ce fichier est soit une option
(identique à une option en ligne de commande mais sans tirets initiaux),
soit un commentaire, commençant par «\ \fB#\fP\ ».
.br
.TP 
\fB\-\-abort\-after=\fP\fInombre\fP
Modifie le nombre d'erreurs au delà duquel \fBdpkg\fP s'arrête. Il est par
défaut égal à 50.
.TP 
\fB\-B\fP, \fB\-\-auto\-deconfigure\fP
Quand un paquet est supprimé, il peut arriver qu'un paquet installé
dépendait du paquet supprimé. En spécifiant cette option, on obtient la
déconfiguration automatique du paquet qui dépendait du paquet supprimé.
.TP 
\fB\-D\fP\fIoctal\fP\fB, \-\-debug=\fP\fIoctal\fP
Demande de débogage. \fIoctal\fP est formé en faisant un «\ ou\ » logique entre
des valeurs souhaitées appartenant à la liste ci\-dessous (notez que ces
valeurs pourront changer dans les prochaines versions). \fB\-Dh\fP ou
\fB\-\-debug=help\fP affiche ces valeurs de débogage.

 nombre  description
    1   Informations de progression
        en général utiles
    2   Appel et état des scripts du responsable
   10   Affichage pour chaque fichier traité
  100   De nombreux affichages pour chaque fichier
        traité
   20   Affichage pour chaque fichier de configuration
  200   De nombreux affichages pour chaque fichier
        de configuration
   40   Dépendances et conflits
  400   De nombreuses sorties pour les dépendances
        et les conflits
10000   Sortie sur l'activation et le traitement des actions différées
20000   De nombreuses sorties sur les actions différées
40000   Quantité stupide de sorties sur les actions différées
 1000   Beaucoup de radotage à propos, par exemple, du répertoire
        dpkg/info
 2000   Quantité stupide de radotage
.TP 
\fB\-\-force\-\fP\fIquelque\-chose\fP
.TQ
\fB\-\-no\-force\-\fP\fIquelque\-chose\fP, \fB\-\-refuse\-\fP\fIquelque\-chose\fP
Forcer ou refuser (\fBno\-force\fP et \fBrefuse\fP signifient la même chose) de
faire quelque chose. \fIquelque\-chose\fP est une liste d'actions séparées par
des virgules, décrites ci\-après. \fB\-\-force\-help\fP affiche un message qui les
décrit. Les actions marquées d'un (*) sont forcées par défaut.

\fIAvertissement\ : ces options sont principalement destinées aux experts. Un
usage auquel manque la pleine compréhension de leurs effets peut casser le
système entier.\fP

\fBall\fP\ : Met en œuvre (ou pas) toutes les options de forçage.

\fBdowngrade\fP(*)\ : Installe un paquet, même si une version plus récente du
paquet est déjà installée.

\fIAvertissement\ : pour l'instant,\fP \fBdpkg\fP \fIne recherche pas les
dépendances lors d'un retour à une version inférieure d'un paquet\ ; il ne
vous préviendra pas si la version choisie casse les dépendances d'un autre
paquet. Cela peut avoir de sérieuses conséquences\ ;\ et si l'on revient à des
versions antérieures des programmes essentiels du système, cela peut rendre
votre système inutilisable. N'utiliser qu'avec précaution.\fP

\fBconfigure\-any\fP\ : configurer aussi les paquets dépaquetés mais non
configurés dont dépend le paquet en question.

\fBhold\fP: Allow automatic installs, upgrades or removals of packages even
when marked to be on “hold”.  Note: This does not prevent these actions when
requested explicitly.

\fBremove\-reinstreq\fP\ : supprimer un paquet, même défectueux et marqué comme
demandant une réinstallation. Il se peut, dès lors, que des éléments du
paquet restent dans le système et soient oubliés par \fBdpkg\fP.

\fBremove\-essential\fP\ : supprimer un paquet même s'il est considéré comme
indispensable. Les paquets «\ Essential\ » comportent les commandes Unix les
plus fondamentales et les enlever peut casser le système entier. Il faut
utiliser cette option avec prudence.

\fBdepends\fP\ : changer tous les problèmes de dépendance en
avertissements. Cela affecte les champs \fBPre\-Depends\fP et \fBDepends\fP.

\fBdepends\-version\fP\ : ignorer les versions dans les questions de
dépendance.Cela affecte les champs \fBPre\-Depends\fP et \fBDepends\fP.

\fBbreaks\fP\ : forcer l'installation, même si cela risque de casser un autre
paquet (depuis dpkg\ 1.14.6). Cela affecte le champ \fBBreaks\fP.

\fBconflicts\fP\ : installer un paquet, même s'il est en conflit avec un autre
paquet. C'est dangereux car habituellement cela produit le remplacement de
certains fichiers. Cela affecte le champ \fBConflicts\fP.

\fBconfmiss\fP\ : toujours installer le fichier de configuration manquant sans
rien demander. Cette opération est dangereuse, puisque les changements
apportés au fichier ne seront pas préservés (suppression).

\fBconfnew\fP\ : quand un fichier de configuration a été modifié et que la
version dans le paquet a changé, toujours installer la nouvelle version sans
rien demander, sauf si l'option \fB\-\-force\-confdef\fP est aussi présente,
auquel cas l'action par défaut est choisie.

\fBconfold\fP\ : quand un fichier de configuration a été modifié et que la
version du paquet a changé, garder l'ancienne version sans rien demander,
sauf si l'option \fB\-\-force\-confdef\fP est aussi présente, auquel cas l'action
par défaut est choisie.

\fBconfdef\fP\ : quand un fichier de configuration a été modifié et que la
version du paquet a changé, utilise toujours l'action par défaut, de manière
non interactive. Quand il n'y a pas d'action par défaut, la commande
s'arrête et interroge l'utilisateur, à moins que l'option \fB\-\-force\-confnew\fP
ou l'option \fB\-\-force\-confold\fP n'ait été donnée, auquel cas elle se sert de
ces options pour déterminer ce qu'il faut faire.

\fBconfask\fP\ : si un fichier de configuration a été modifié, propose de le
remplacer avec la version du paquet, même si celle\-ci n'a pas changé (depuis
dpkg\ 1.15.8). Si l'une des options \fB\-\-force\-confmiss\fP, \fB\-\-force\-confnew\fP,
\fB\-\-force\-confold\fP, ou \fB\-\-force\-confdef\fP est également mentionnée, elle
déterminera l'action finalement utilisée.

\fBoverwrite\fP\ : remplacer un fichier par un fichier d'un autre paquet.

\fBoverwrite\-dir\fP\ : remplacer un répertoire d'un paquet par le fichier d'un
autre paquet.

\fBoverwrite\-diverted\fP\ : remplacer un fichier détourné avec une version non
détournée.

\fBstatoverride\-add\fP\ : remplacer une dérogation d'état existante lors de son
ajout (depuis dpkg\ 1.19.5)

\fBstatoverride\-remove\fP\ : ignorer l'absence de dérogation d'état lors de sa
suppression (depuis dpkg\ 1.19.5).

\fBsecurity\-mac\fP(*)\ : utiliser une sécurité basée sur le contrôle d'accès
obligatoire (Mandatory Access Controls –\ MAC) spécifique à la plateforme
lors de l'installation de fichiers dans le systèmes de fichiers (depuis
dpkg\ 1.19.5). Sur les systèmes Linux, la mise en œuvre utilise SELinux.

\fBunsafe\-io\fP\ : ne pas effectuer d'action d'entrée/sortie non sûre lors de la
décompression (depuis dpkg\ 1.15.8.6). Cela implique actuellement de ne pas
synchroniser le système de fichiers avant le renommage de fichiers, ce qui
est une cause connue de dégradation des performances sur certains systèmes,
en général ceux qui, peu fiables, ont besoin d'actions sûres pour éviter de
terminer avec des fichiers de taille vide en cas d'interruption inopinée.

\fINote\fP\ : pour ext4, le principal concerné, il est suggéré de plutôt
utiliser l'option de montage \fBnodelalloc\fP, qui corrigera à la fois la
dégradation des performances et les problèmes de sécurité des données. Elle
permet notamment d'éviter de terminer avec des fichiers vides lors des
arrêts brutaux pour tout logiciel qui ne synchronise pas le système de
fichiers avant chaque renommage.

\fIAvertissement\ : l'utilisation de cette option peut améliorer la
performance mais augmente le risque de perte de données. Elle est donc à
utiliser avec précautions.\fP

\fBscript\-chrootless\fP\ : exécuter les scripts du responsable sans créer de
\fBchroot\fP(2) dans \fBinstdir\fP même si le paquet ne gère pas ce mode
d'opération (depuis dpkg\ 1.18.5).

\fIAvertissement\ : cela peut détruire le système hôte, utilisez avec des
précautions extrêmes.\fP

\fBarchitecture\fP\ : traiter même les paquets sans architecture ou avec une
architecture incorrecte.

\fBbad\-version\fP\ : traiter même les paquets dont la version est incorrecte
(depuis dpkg\ 1.16.1).

\fBbad\-path\fP\ : programmes importants non visibles par la variable \fBPATH\fP, ce
qui va poser des problèmes.

\fBnot\-root\fP\ : tenter de (dés)installer même sans être root.

\fBbad\-verify\fP\ : installer un paquet même si la vérification de son
authenticité a échoué.

.TP 
\fB\-\-ignore\-depends\fP=\fIpaquet\fP,...
Ne tient pas compte de la vérification des dépendances pour les paquets
spécifiés (en fait, la vérification est faite mais on ne donne rien d'autre
que des avertissements). Cela affecte les champs \fBPre\-Depends\fP, \fBDepends\fP
et \fBBreaks\fP.
.TP 
\fB\-\-no\-act\fP, \fB\-\-dry\-run\fP, \fB\-\-simulate\fP
Faire tout ce qui doit être fait, mais n'écrire aucune modification. On
utilise cette option pour voir ce qui se passe sans modifier quoi que ce
soit.

Assurez\-vous de donner l'option \fB\-\-no\-act\fP avant le paramètre action, sinon
des résultats fâcheux sont probables. Par exemple, la commande \fBdpkg
\-\-purge foo \-\-no\-act\fP purge d'abord le paquet foo et essaie ensuite de
purger le paquet \-\-no\-act, même si vous comptiez qu'elle ne ferait rien du
tout.
.TP 
\fB\-R\fP, \fB\-\-recursive\fP
Traite récursivement tous les simples fichiers qui correspondent au motif
\fB*.deb\fP et qui se trouvent dans les répertoires et sous\-répertoires
spécifiés. On peut utiliser cette option avec les actions \fB\-i\fP, \fB\-A\fP,
\fB\-\-install\fP, \fB\-\-unpack\fP et \fB\-\-record\-avail\fP.
.TP 
\fB\-G\fP
Ne pas installer un paquet si une version plus récente de ce paquet est déjà
installée. C'est un alias pour \fB\-\-refuse\-downgrade\fP.
.TP 
\fB\-\-admindir\fP=\fIrépertoire\fP
Fixe le répertoire d'administration à \fIrépertoire\fP. Ce répertoire contient
de nombreux fichiers donnant des informations au sujet de l'état des paquets
installés ou non,\ etc. (Le répertoire par défaut est \fI%ADMINDIR%\fP)
.TP 
\fB\-\-instdir=\fP\fIrépertoire\fP
Fixe le répertoire d'installation qui indique où les paquets vont être
installés. \fBinstdir\fP est aussi le nom du répertoire indiqué à \fBchroot\fP(2)
avant que ne soient lancés les scripts d'installation, ce qui signifie que
ces scripts voient \fBinstdir\fP comme répertoire racine. Le répertoire par
défaut est «\ \fI/\fP\ ».
.TP 
\fB\-\-root=\fP\fIrépertoire\fP
Fixe le répertoire racine à \fIrépertoire\fP ce qui fixe le répertoire
d'installation à «\ \fIrépertoire\fP\ » et le répertoire d'administration à
«\ \fIrépertoire\fP\fB%ADMINDIR%\fP\ ».
.TP 
\fB\-O\fP, \fB\-\-selected\-only\fP
Traiter seulement les paquets qui sont sélectionnés pour l'installation. La
sélection est réellement faite par \fBdselect\fP ou par \fBdpkg\fP quand ils
manipulent les paquets. Par exemple, quand un paquet est supprimé, il est
marqué comme ayant été sélectionné pour une désinstallation.
.TP 
\fB\-E\fP, \fB\-\-skip\-same\-version\fP
Ne pas installer le paquet si la même version du paquet est déjà installée.
.TP 
\fB\-\-pre\-invoke=\fP\fIcommande\fP
.TQ
\fB\-\-post\-invoke=\fP\fIcommande\fP
Programme l'exécution de \fIcommande\fP à l'aide «\ sh \-c\ » avant ou après
l'exécution de \fBdpkg\fP pour les actions \fIunpack\fP, \fIconfigure\fP, \fIinstall\fP,
\fItriggers\-only\fP, \fIremove\fP, \fIpurge\fP, \fIadd\-architecture\fP et
\fIremove\-architecture\fP (depuis dpkg\ 1.15.4\ ; les actions \fIadd\-architecture\fP
et \fIremove\-architecture\fP depuis dpkg\ 1.17.19). Cette option peut être
utilisée plusieurs fois. L'ordre dans lequel les options multiples sont
indiquées sera préservé et celles indiquées dans le fichier de configuration
auront la priorité. La variable d'environnement \fBDPKG_HOOK_ACTION\fP est
utilisée pour indiquer aux scripts utilisés quelle est l'action actuelle de
\fBdpkg\fP. Note\ :\ les interfaces de \fBdpkg\fP peuvent l'appeler plusieurs fois à
chaque invocation, ce qui peut provoquer l'exécution des «\ hooks\ » plus
souvent que prévu.
.TP 
\fB\-\-path\-exclude=\fP\fImotif\-global\fP
.TQ
\fB\-\-path\-include=\fP\fImotif\-global\fP
Utilise \fImotif\-global\fP comme filtre de chemins, soit en excluant, soit en
ré\-incluant des chemins précédemment exclus, correspondant au motif indiqué,
pendant l'installation (depuis dpkg\ 1.15.8).

\fIAttention\ :\ dépendre des chemins exclus peut entièrement casser le
système. Ce réglage doit donc être utilisé avec précautions.\fP

Les motifs globaux utilisent les mêmes caractères joker que le
shell\ où\ «\ *\ » correspond à une séquence quelconque de caractères, y compris
une chaîne vide ou le caractère «\ /\ ». Ainsi, «\ \fI/usr/*/READ*\fP\ » comportera
«\ \fI/usr/share/doc/package/README\fP\ ». Comme toujours, le caractère «\ ?\ »
correspond à un caractère quelconque (y compris «\ /\ »). Le caractère «\ [\ »
marque le début d'une classe de caractères, qui contient une liste de
caractères, séries de caractères ou compléments de séries. Veuillez
consulter \fBglob\fP(7) pour plus d'informations à propos des correspondances
globales. Note\ :\ l'implémentation actuelle pourrait ré\-inclure plus de
répertoires et liens symboliques que nécessaire, par souci de sécurité et
pour éviter des échecs possibles de décompression. Des modifications à venir
pourraient changer cela.

Cela peut servir à exclure tous les chemins sauf certains spécifiques. Un
cas classique d'utilisation est\ :

.nf
\fB\-\-path\-exclude=/usr/share/doc/*\fP
\fB\-\-path\-include=/usr/share/doc/*/copyright\fP
.fi

qui permet de supprimer tous les fichiers de documentation sauf les fichiers
de «\ copyright\ ».

Ces deux options peuvent être utilisées plusieurs fois et éventuellement
être alternées entre elles. Les deux sont traitées dans l'ordre indiqué\ :\ la
dernière règle correspondant à un fichier donné est alors celle qui sera
utilisée.

Les filtres sont appliqués lors du dépaquetage des paquets binaires et, en
tant que tel, ont seulement connaissance du type des objets qui sont en
cours de filtrage (par exemple un fichier ordinaire ou un répertoire) et
n'ont pas de visibilité des objets à venir. Comme ces filtres ont des effets
secondaires (à la différence des filtres de \fBfind\fP(1)), l'exclusion d'un
chemin précis qui se trouve être un objet répertoire, comme
\fI/usr/share/doc\fP, n'aura pas le résultat désiré, et seul ce chemin sera
exclu (et qui pourrait être réintégré automatiquement si le code en voit la
nécessité).Le dépaquetage de tous les fichiers suivants renfermés par ce
répertoire échouera.

Astuce\ : Assurez\-vous que les «\ globs\ » ne sont pas développés par le shell.
.TP 
\fB\-\-verify\-format\fP\fI nom\-de\-format\fP
Définit le format de sortie de la commande \fB\-\-verify\fP (depuis dpkg\ 1.17.2).

Le seul format de sortie géré actuellement est \fBrpm\fP, qui consiste en une
ligne par chemin dont la vérification a échoué. Les lignes débutent par
9\ caractères pour signaler les résultats d'une vérification spécifique, un
«\ \fB?\fP\ » implique que la vérification ne peut être réalisée (absence de
prise en charge, droit d'accès de fichier,\ etc), «\ \fB.\fP\ » implique que la
vérification est passée et un caractère alphanumérique implique qu'une
vérification spécifique a échoué\ ; l'échec de vérification md5sum est
identifiée par un «\ \fB5\fP\ » en troisième caractère. La ligne continue par une
espace et un caractère d'attribut (comme «\ \fBc\fP\ » pour conffiles –\ fichiers
de configuration), une autre espace et le nom de chemin.
.TP 
\fB\-\-status\-fd \fP\fIn\fP
Envoie un état du paquet compréhensible par la machine et met à jour cette
information dans le descripteur de fichier \fIn\fP. Cette option peut être
spécifiée plusieurs fois. L'information est généralement constituée d'un
enregistrement par ligne, dans l'une des formes suivantes\ :
.RS
.TP 
\fBstatus: \fP\fIpaquet\fP\fB: \fP\fIétat\fP
L'état du paquet a changé\ ; l'\fIétat\fP est tel que dans le fichier d'état
(\ «status file\ »).
.TP 
\fBstatus: \fP\fIpaquet\fP\fB : error : \fP\fImessage\-d'erreur\-complet\fP
Une erreur s'est produite. Toutes les lignes supplémentaires éventuelles
dans \fImessage\-d'erreur\-complet\fP seront converties en espaces avant
affichage.
.TP 
\fBstatus: \fP\fIfichier\fP\fB : conffile\-prompt : '\fP\fIreal\-old\fP\fB' '\fP\fIreal\-new\fP\fB' \fP\fIuseredited\fP\fB \fP\fIdistedited\fP
Une question pour un fichier de configuration va être posée à l'utilisateur.
.TP 
\fBprocessing: \fP\fIphase\fP\fB: \fP\fIpaquet\fP
Envoyé juste avant le début du traitement d'une phase. Les \fIphases\fP sont
\fBupgrade\fP, \fBinstall\fP (les deux sont envoyés avant le dépaquetage),
\fBconfigure\fP, \fBtrigproc\fP, \fBdisappear\fP, \fBremove\fP, \fBpurge\fP.
.RE
.TP 
\fB\-\-status\-logger\fP=\fIcommande\fP
Envoie un état du paquet compréhensible par la machine et met à jour
l'information de progression sur l'entrée standard du processeur de
commandes \fIcommand\fP, à exécuter avec «\ sh \-c\ » (depuis dpkg\ 1.16.0). Cette
option peut être spécifiée plusieurs fois. Le format d'affichage utilisé est
le même que celui de \fB\-\-status\-fd.\fP
.TP 
\fB\-\-log=\fP\fIfichier\fP
Enregistre les mises à jour et actions des changements d'état dans
\fIfichier\fP plutôt que dans le \fI%LOGDIR%/dpkg.log\fP par défaut. Si l'option
est passée plusieurs fois, le dernier nom de fichier est utilisé. Les
messages du journal ont cette forme\ :
.RS
.TP 
AAAA\-MM\-JJ HH:MM:SS \fBstartup\fP \fItype\fP \fIcommande\fP
Pour chaque invocation de dpkg où \fItype\fP est \fBarchives\fP (avec une
\fIcommande\fP \fBunpack\fP ou \fBinstall\fP) ou \fBpackages\fP (avec une \fIcommande\fP
\fBconfigure\fP, \fBtriggers\-only\fP, \fBremove\fP ou \fBpurge\fP).
.TP 
AAAA\-MM\-JJ HH:MM:SS \fBstatus\fP \fIétat\fP \fIpaquet\fP \fIversion\-installée\fP
Pour les mises à jour des changements d'état.
.TP 
AAAA\-MM\-JJ HH:MM:SS \fBaction\fP \fIpaquet\fP \fIversion\-installée\fP \fIversion\-disponible\fP
Pour les actions où \fIaction\fP est \fBinstall\fP, \fBupgrade\fP, \fBconfigure\fP,
\fBtrigproc\fP, \fBdisappear\fP, \fBremove\fP ou \fBpurge\fP.
.TP 
AAAA\-MM\-JJ HH:MM:SS \fBconffile\fP \fIfichier\fP \fIdécision\fP
Pour les changements du fichier de configuration où \fIdécision\fP est
\fBinstall\fP ou \fBkeep\fP.
.RE
.TP 
\fB\-\-no\-pager\fP
Désactive l'utilisation d'un afficheur pour montrer les informations (depuis
dpkg\ 1.19.2).
.TP 
\fB\-\-no\-debsig\fP
Ne pas tenter de vérifier la signature des paquets.
.TP 
\fB\-\-no\-triggers\fP
Durant ce traitement, ne pas lancer d'actions différées (depuis
dpkg\ 1.14.17), mais les activations seront toujours enregistrées. S'il est
utilisé avec \fB\-\-configure\fP \fIpaquet\fP ou \fB\-\-triggers\-only\fP \fIpaquet\fP alors
le postinst du paquet sera toujours exécuté même si seule l'exécution d'une
action différée est nécessaire. L'utilisation de cette option peut laisser
des paquets dans les mauvais états \fBtriggers\-awaited\fP et
\fBtriggers\-pending\fP. Cela peut être corrigé plus tard en exécutant \fBdpkg
\-\-configure \-\-pending\fP.
.TP 
\fB\-\-triggers\fP
Annule un précédent \fB\-\-no\-triggers\fP (depuis dpkg\ 1.14.17).
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
L'action demandée s'est correctement déroulée. Ou bien une commande de
vérification ou de déclaration renvoie «\ true\ ».
.TP 
\fB1\fP
Une commande de vérification ou de déclaration renvoie «\ false\ ».
.TP 
\fB2\fP
Erreur fatale ou irrécupérable due à l'utilisation d'une ligne de commande
non valable, ou interactions avec le système, telles que des accès à la base
de données, des allocations de mémoire,\ etc.
.
.SH ENVIRONNEMENT
.SS "Environnement externe"
.TP 
\fBPATH\fP
Cette variable devrait être définie dans l'environnement et pointer vers les
chemins du système où plusieurs programmes requis devraient se trouver. Si
la variable n'est pas définie ou si les programmes ne sont pas trouvés,
\fBdpkg\fP s'arrête.
.TP 
\fBHOME\fP
Si cette option est utilisée, \fBdpkg\fP utilisera le répertoire indiqué pour
lire le fichier de configuration propre à l'utilisateur.
.TP 
\fBTMPDIR\fP
Si cette option est utilisée, \fBdpkg\fP utilisera le répertoire indiqué pour
créer les fichiers et répertoires temporaires.
.TP 
\fBSHELL\fP
Le programme exécuté par \fBdpkg\fP quand il lance un nouvel interpréteur de
commandes interactif ou lance une commande avec le shell.
.TP 
\fBPAGER\fP
.TQ
\fBDPKG_PAGER\fP
The program \fBdpkg\fP will execute when running a pager, which will be
executed with «\fB$SHELL \-c\fP», for example when displaying the conffile
differences.  If \fBSHELL\fP is not set, «\fBsh\fP» will be used instead.  The
\fBDPKG_PAGER\fP overrides the \fBPAGER\fP environment variable (since dpkg
1.19.2).
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_FORCE\fP
Définit les drapeaux de forçage (depuis dpkg\ 1.19.5). Quand cette variable
est présente, aucune des options internes de forçage par défaut ne sera
appliquée. Si la variable est présente mais vide, tous les drapeaux de
forçage seront désactivés.
.TP 
\fBDPKG_ADMINDIR\fP
If set and the \fB\-\-admindir\fP or \fB\-\-root\fP options have not been specified,
it will be used as the \fBdpkg\fP administrative directory (since dpkg 1.20.0).
.TP 
\fBDPKG_FRONTEND_LOCKED\fP
Définie par une interface de gestion de paquets pour notifier à dpkg qu'il
ne devrait pas obtenir le verrou d'interface (dpkg\ 1.19.1).
.SS "Environnement interne"
.TP 
\fBLESS\fP
Définie par \fBdpkg\fP à «\ \fB\-FRSXMQ\fP\ », si ce n'est pas déjà configuré, lors
du lancement d'un afficheur (depuis dpkg\ 1.19.2). Pour modifier le
comportement par défaut, cette variable peut être configurée à une autre
valeur y compris une chaîne vide\ ; alternativement, les variables \fBPAGER\fP
ou \fBDPKG_PAGER\fP peuvent être réglées pour désactiver des options
particulières avec «\fB\-+\fP», par exemple \fBDPKG_PAGER="less \-+F"\fP.
.TP 
\fBDPKG_ROOT\fP
Définie par \fBdpkg\fP dans l'environnement du script du responsable pour
indiquer quelle installation activer (depuis dpkg\ 1.18.5). La valeur est
destinée à être ajoutée avant n'importe quel chemin sur lequel les scripts
du responsable agissent. Pendant une opération normale, cette variable est
vide. Lors de l'installation de paquets dans un \fBinstdir\fP différent,
\fBdpkg\fP invoque normalement les scripts du responsable avec \fBchroot\fP(2) et
laisse cette variable vide, mais si \fB\-\-force\-script\-chrootless\fP est
indiqué, alors, l'appel de \fBchroot\fP(2) est ignoré et \fBinstdir\fP n'est pas
vide.
.TP 
\fBDPKG_ADMINDIR\fP
Définie par \fBdpkg\fP dans l'environnement du script du responsable, pour
indiquer le répertoire d'administration à utiliser (depuis
dpkg\ 1.16.0). Cette variable est toujours fixée à la valeur actuelle de
\fB\-\-admindir\fP.
.TP 
\fBDPKG_FORCE\fP
Définie par \fBdpkg\fP dans l'environnement du sous\-processus pour tous les
noms d'options de forçage actuellement activées séparés par des virgules
(depuis\ dpkg\ 1.19.5).
.TP 
\fBDPKG_SHELL_REASON\fP
Cette variable est définie pour le shell lancé par \fBdpkg\fP lorsqu'il lui est
demandé d'analyser la situation lors du traitement des fichiers de
configuration (depuis dpkg\ 1.15.6). La valeur actuellement valable est\ :
\fBconffile\-prompt\fP.
.TP 
\fBDPKG_CONFFILE_OLD\fP
Cette variable est définie pour le shell lancé par \fBdpkg\fP lorsqu'il lui est
demandé d'analyser la situation lors du traitement des fichiers de
configuration (depuis dpkg\ 1.15.6). Elle contient le nom de l'ancien fichier
de configuration.
.TP 
\fBDPKG_CONFFILE_NEW\fP
Cette variable est définie pour le shell lancé par \fBdpkg\fP lorsqu'il lui est
demandé d'analyser la situation lors du traitement des fichiers de
configuration (depuis dpkg\ 1.15.6). Elle contient le nom du nouveau fichier
de configuration.
.TP 
\fBDPKG_HOOK_ACTION\fP
Cette variable est définie par \fBdpkg\fP pour le shell lancé lors de
l'exécution d'une action de point d'entrée (depuis dpkg\ 1.15.4). Elle
contient l'action actuelle de \fBdpkg\fP.
.TP 
\fBDPKG_RUNNING_VERSION\fP
Cette variable est définie par \fBdpkg\fP dans l'environnement du script du
responsable. Elle contient la version de l'instance de \fBdpkg\fP en cours
d'exécution (depuis dpkg\ 1.14.17).
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE\fP
Définie par \fBdpkg\fP dans l'environnement du script du responsable, cette
variable contient le nom du paquet (sans qualification d'architecture) en
cours de traitement (depuis dpkg\ 1.14.17).
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE_REFCOUNT\fP
Définie par \fBdpkg\fP dans l'environnement du script du responsable, cette
variable contient le compte de référence du paquet, c'est\-à\-dire le nombre
d'instances de paquet avec un état plus élevé que \fBnot\-installed\fP (depuis
dpkg\ 1.17.2).
.TP 
\fBDPKG_MAINTSCRIPT_ARCH\fP
Définie par \fBdpkg\fP dans l'environnement du script du responsable, cette
variable contient l'architecture pour laquelle le paquet a été construit
(depuis dpkg\ 1.15.4).
.TP 
\fBDPKG_MAINTSCRIPT_NAME\fP
Définie par \fBdpkg\fP dans l'environnement du script du responsable, cette
variable contient le nom du script en cours d'exécution, \fBpreinst\fP,
\fBpostinst\fP, \fBprerm\fP ou \fBpostrm\fP (depuis dpkg\ 1.15.7).
.TP 
\fBDPKG_MAINTSCRIPT_DEBUG\fP
Cette variable est définie par \fBdpkg\fP dans l'environnement du script du
responsable à une valeur («\ \fB0\fP\ » ou «\ \fB1\fP\ » notant si le débogage a été
demandé (avec l'option \fB\-\-debug\fP) pour les scripts du responsable (depuis
dpkg\ 1.18.4).
.
.SH FICHIERS
.TP 
\fI%PKGCONFDIR%/dpkg.cfg.d/[0\-9a\-zA\-Z_\-]*\fP
Fragments de fichiers de configuration (depuis dpkg\ 1.15.4).
.TP 
\fI%PKGCONFDIR%/dpkg.cfg\fP
Fichier de configuration contenant les options par défaut.
.TP 
\fI%LOGDIR%/dpkg.log\fP
Fichier journal standard. Voyez \fI%PKGCONFDIR%/dpkg.cfg\fP et l'option
\fB\-\-log\fP.
.P
Les autres fichiers répertoriés ici sont dans leur répertoire par défaut,
voyez l'option \fB\-\-admindir\fP pour savoir comment changer l'emplacement de
ces fichiers.
.TP 
\fI%ADMINDIR%/available\fP
Liste des paquets disponibles.
.TP 
\fI%ADMINDIR%/status\fP
États des paquets disponibles. Ce fichier contient des informations qui
permettent de savoir si un paquet est marqué comme devant être supprimé ou
pas, devant être installé ou pas,\ etc. Voyez la section \fBRENSEIGNEMENTS SUR
LES PAQUETS\fP pour des informations supplémentaires.

Le fichier d'état est sauvegardé quotidiennement dans \fI/var/backups\fP. Cela
peut être utile en cas de perte ou de corruption due à des problèmes de
système de fichiers.
.P
Le format et le contenu d'un paquet binaire sont décrits dans \fBdeb\fP(5).
.
.SH BOGUES
L'option \fB\-\-no\-act\fP ne donne pas assez d'informations utiles.
.
.SH EXEMPLES
Affichage des paquets installés liés à l'éditeur \fBvi\fP(1) (noter que
\fBdpkg\-query\fP ne charge plus le fichier \fIavailable\fP par défaut, sauf si
l'option \fBdpkg\-query\fP \fB\-\-load\-avail\fP est utilisée)\ :
.br
    \fBdpkg \-l '*vi*'\fP
.br

Pour voir les entrées de \fI%ADMINDIR%/available\fP concernant deux paquets\ :
.br
    \fBdpkg \-\-print\-avail elvis vim | less\fP
.br

Pour rechercher vous\-même dans la liste des paquets\ :
.br
    \fBless %ADMINDIR%/available\fP
.br

Pour supprimer le paquet installé elvis\ :
.br
    \fBdpkg \-r elvis\fP
.br

Pour installer un paquet, vous devez d'abord le trouver dans une archive ou
sur un CD. Le fichier \fIavailable\fP montre que le paquet vim se trouve dans
la section «\ \fBeditors\fP\ »\ :
.br
     \fBcd /media/cdrom/pool/main/v/vim\fP
     \fBdpkg \-i vim_4.5\-3.deb\fP
.br

Pour faire une copie locale des états de sélection des paquets\ :
.br
    \fBdpkg \-\-get\-selections >mes\-sélections\fP
.br

Vous pourriez transférer ce fichier sur un autre ordinateur, et après avoir
mis à jour le fichier \fIavailable\fP avec l'interface de gestion de paquets de
votre choix (voir https://wiki.debian.org/Teams/Dpkg/FAQ pour plus de
détails), par exemple\ :
.br
     \fBapt\-cache dumpavail | dpkg \-\-merge\-avail\fP
.br
ou avec dpkg\ 1.17.6 et les versions antérieures\ :
.br
     \fBavail=`mktemp`\fP
     \fBapt\-cache dumpavail >"$avail"\fP
     \fBdpkg \-\-merge\-avail "$avail"\fP
     \fBrm "$avail"\fP
.br
vous pouvez l'installer de cette manière\ :
.br
    \fBdpkg \-\-clear\-selections\fP
    \fBdpkg \-\-set\-selections <mes\-sélections\fP
.br

On remarquera que cela n'installe ou ne supprime rien du tout\ ; cela ne fait
qu'enregistrer l'état souhaité des paquets. Vous aurez besoin d'autres
applications pour récupérer et installer réellement les paquets requis. Par
exemple, exécuter \fBapt\-get dselect\-upgrade\fP.

Habituellement, vous trouverez que \fBdselect\fP(1) fournit une façon plus
aisée de modifier les états de sélection des paquets.
.br
.
.SH "FONCTIONNALITÉS SUPPLÉMENTAIRES"
D'autres possibilités sont offertes en installant les paquets suivants\ :
\fBapt\fP, \fBaptitude\fP et \fBdebsums\fP.
.
.SH "VOIR AUSSI"
\fBaptitude\fP(1), \fBapt\fP(1), \fBdselect\fP(1), \fBdpkg\-deb\fP(1), \fBdpkg\-query\fP(1),
\fBdeb\fP(5), \fBdeb\-control\fP(5), \fBdpkg.cfg\fP(5) et \fBdpkg\-reconfigure\fP(8).
.
.SH AUTEURS
Consultez \fI%PKGDOCDIR%/THANKS\fP pour la liste de ceux qui ont contribué à
\fBdpkg\fP.
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
