.\" dpkg manual page - dpkg-deb(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-shlibdeps 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dpkg\-shlibdeps \- Générateur de variables de substitution de dépendances pour
bibliothèques partagées
.
.SH SYNOPSIS
\fBdpkg\-shlibdeps\fP [\fIoption\fP...] [\fB\-e\fP]\fIexécutable\fP [\fIoption\fP...]
.
.SH DESCRIPTION
\fBdpkg\-shlibdeps\fP calcule, pour les exécutables indiqués dans ses
paramètres, les dépendances envers les bibliothèques partagées. Ces
dépendances sont ajoutées au fichier de variables de substitution
\fBdebian/substvars\fP sous la forme \fBshlibs:\fP\fIchamp\-dépendance\fP où
\fIchamp\-dépendance\fP est le nom du champ de dépendance. Toute autre variable
après \fIshlibs:\fP est supprimée du fichier.
.P
\fBdpkg\-shlibdeps\fP a deux sources possibles pour créer les informations
concernant les dépendances, soit les fichiers \fIsymbols\fP, soit les fichiers
\fIshlibs\fP. Pour chaque fichier binaire qu'il analyse, \fBdpkg\-shlibdeps\fP
recherche la liste des bibliothèques partagées qui lui sont liées. Puis,
pour chacune d'elles il analyse soit le fichier \fIsymbols\fP, soit le fichier
\fIshlibs\fP (si le premier n'existe pas ou si debian/shlibs.local contient les
dépendances appropriées). Ces deux fichiers sont censés être fournis par le
paquet de la bibliothèque et disponibles dans
%ADMINDIR%/info/\fIpaquet\fP.\fIsymbols\fP ou
%ADMINDIR%/info/\fIpaquet\fP.\fIshlibs\fP. Le nom du paquet est trouvé en deux
étapes\ : en cherchant le fichier de la bibliothèque sur le système, dans le
répertoire que \fBld.so\fP utiliserait, puis en utilisant \fBdpkg \-S
\fP\fIfichier\-bibliothèque\fP pour trouver le paquet qui fournit cette
bibliothèque.
.SS "Fichiers symboles"
Les fichiers symboles contiennent des informations de dépendances plus fines
en fournissant les dépendances minimales pour chaque symbole de la
bibliothèque exportée. Le script essaie de trouver un fichier de symboles
associé à un paquet de bibliothèque dans les emplacements suivants (le
premier trouvé est utilisé)\ :
.IP debian/*/DEBIAN/symbols
Les informations de bibliothèque partagée générée par l'actuel processus de
construction qui invoque aussi \fBdpkg\-shlibdeps\fP. Elles sont générées par
\fBdpkg\-gensymbols\fP(1) et ne sont utilisées que si la bibliothèque se trouve
dans l'arbre de construction d'un paquet. Le fichier des symboles qui
construit l'arbre s'appuie sur les fichiers de symboles d'autres paquets
binaires.
.IP %PKGCONFDIR%/symbols/\fIpaquet\fP.symbols.\fIarchitecture\fP
.IP %PKGCONFDIR%/symbols/\fIpaquet\fP.symbols
Les informations de dépendance de bibliothèque partagée principales par
système. \fIarch\fP est l'architecture du système actuel (obtenu par
\fBdpkg\-architecture \-qDEB_HOST_ARCH\fP).
.IP "Affichage de “\fBdpkg\-query \-\-control\-path\fP \fIpaquet\fP symbols”"
Les informations de dépendance de bibliothèque partagée fournies par le
paquet. Sauf indication contraire par le biais de \fB\-\-admindir\fP, ces
fichiers sont par défaut dans %ADMINDIR%.
.P
Lors de l'analyse des symboles utilisés par tous les binaires,
\fBdpkg\-shlibdeps\fP retient la (plus grande) version minimale nécessaire pour
chaque bibliothèque. À la fin du processus, il est capable d'écrire la
dépendance minimale pour toutes les bibliothèques utilisées (à condition que
l'information des fichiers \fIsymbols\fP soit exacte).
.P
Comme garde\-fou, un fichier de symboles peut fournir un champ
\fBBuild\-Depends\-Package\fP de méta\-information et \fBdpkg\-shlibdeps\fP en
extraira la version minimale requise par le paquet correspondant depuis ce
champ \fBBuild\-Depends\fP et utilisera cette version si elle est supérieure à
la version minimale calculée par l'examen des symboles.
.SS "Fichiers Shlibs"
Les fichiers Shlibs associent directement une bibliothèque à une dépendance
(sans regarder les symboles). C'est donc souvent plus puissant que les
besoins réels mais cela reste très sûr et facile à manipuler.
.P
Les dépendances d'une bibliothèque sont recherchées à plusieurs endroits. Le
premier fichier d'informations trouvé qui concerne la bibliothèque est
utilisé\ :
.IP debian/shlibs.local
Fichier particulier à un paquet remplaçant les informations qui concernent
les dépendances envers des bibliothèques partagées.
.IP %PKGCONFDIR%/shlibs.override
Fichier système remplaçant les informations qui concernent les dépendances
envers des bibliothèques partagées.
.IP debian/*/DEBIAN/shlibs
Information sur la bibliothèque partagée générée par le processus actuel de
construction qui invoque aussi \fBdpkg\-shlibdeps\fP. Il n'est utilisé que si la
bibliothèque se trouve dans l'arbre de construction du paquet. Le fichier
shlibs qui construit l'arbre a priorité sur les fichiers shlibs des autres
paquets binaires.
.IP "Affichage de «\ \fBdpkg\-query \-\-control\-path\fP \fIpaquet\fP shlibs\ »"
Les informations de dépendance de bibliothèque partagée fournies par le
paquet. Sauf indication contraire par le biais de \fB\-\-admindir\fP, ces
fichiers sont par défaut dans %ADMINDIR%.
.IP %PKGCONFDIR%/shlibs.default
Fichier système par défaut concernant les informations de dépendance envers
des bibliothèques partagées.
.P
Les dépendances trouvées sont ensuite directement utilisées (sauf si elles
sont filtrées parce qu'elles ont été identifiées comme étant en double, ou
d'un niveau plus faible qu'une autre dépendance).
.SH OPTIONS
\fBdpkg\-shlibdeps\fP interprète des arguments sans option comme des commandes
exécutables, comme si on avait simplement donné \fB\-e\fP\fIexécutable\fP.
.TP 
\fB\-e\fP\fIexécutable\fP
Cette option inclut les bonnes dépendances envers les bibliothèques
partagées que demande \fIexécutable\fP. Cette option peut être utilisée
plusieurs fois.
.TP 
\fB\-l\fP\fIrépertoire\fP
Ajoute \fIrépertoire\fP au début de la liste des répertoires où chercher des
bibliothèques partagées privées (depuis dpkg\ 1.17.0). Cette option peut être
utilisée plusieurs fois.

Note\ : Utilisez cette option plutôt que le réglage de \fBLD_LIBRARY_PATH\fP,
parce que cette variable d'environnement est utilisée pour contrôler
l'éditeur de liens d'exécution et se servir d'elle pour définir les chemins
des bibliothèques partagées au moment de la construction peut être
problématique, par exemple, lors d'une compilation croisée.
.TP 
\fB\-d\fP\fIchamp\-dépendance\fP
Cette option ajoute les dépendances destinées au champ «\ dépendance\ » du
fichier de contrôle \fIchamp\-dépendance.\fP (Les dépendances pour ce champ sont
dans la variable \fBshlibs:\fP\fIchamp\-dépendance\fP.)

L'option \fB\-d\fP\fIchamp\-dépendance\fP concerne tous les exécutables qui suivent
l'option, jusqu'à la prochaine option \fB\-d\fP\fIchamp\-dépendance\fP. Par défaut,
\fIchamp\-dépendance\fP vaut \fBDepends\fP.

Quand, dans plusieurs champs reconnus ayant trait aux dépendances comme les
champs \fBPre\-Depends\fP, \fBDepends\fP, \fBRecommends\fP, \fBEnhances\fP ou \fBSuggests\fP
apparaît la même entrée (ou bien un ensemble d'alternatives),
\fBdpkg\-shlibdeps\fP supprime automatiquement les dépendances dans tous les
champs sauf celui qui représente les dépendances les plus importantes.
.TP 
\fB\-p\fP\fIpréfixe\-pour\-le\-nom\-des\-variables\fP
Fait commencer les variables de substitution par
\fIpréfixe\-pour\-le\-nom\-des\-variables\fP\fB:\fP au lieu de \fBshlibs:\fP. De même,
toute variable de substitution commençant par
\fIpréfixe\-pour\-le\-nom\-des\-variables\fP\fB:\fP (au lieu de \fBshlibs:\fP) est enlevée
du fichier de substitution des variables.
.TP 
\fB\-O\fP[\fInom\-de\-fichier\fP]
Affiche les définitions des variables de substitution sur la sortie standard
(ou \fInom\-de\-fichier\fP si spécifié, depuis dpkg\ 1.17.2), plutôt que de les
ajouter dans le fichier de substitution des variables qui est par défaut
\fBdebian/substvars\fP.
.TP 
\fB\-t\fP\fItype\fP
Préférer les informations sur les dépendances des bibliothèques partagées
qui sont étiquetées pour un type de paquet donné. Si aucune information de
type n'est donnée, il n'utilisera pas d'information. Par défaut, le type de
paquet est \fBdeb\fP. On peut créer une étiquette pour ces informations en les
préfixant par le nom du type, un deux\-points et une espace.
.TP 
\fB\-L\fP\fIfichier\-local\-shlibs\fP
Lire les informations de remplacement concernant les dépendances envers les
bibliothèques partagées dans \fIfichier\-local\-shlibs\fP au lieu de
\fBdebian/shlibs.local\fP.
.TP 
\fB\-T\fP\fIfichier\-substvars\fP
Écrire les variables de substitution dans \fIfichier\-substvars\fP\ ; le fichier
par défaut est \fBdebian/substvars\fP.
.TP 
\fB\-v\fP
Active le mode bavard (depuis dpkg\ 1.14.8). De nombreux messages sont
affichés pour expliquer ce que \fBdpkg\-shlibdeps\fP fait.
.TP 
\fB\-x\fP\fIpackage\fP
Exclut le paquet des dépendances générées (depuis dpkg\ 1.14.8). Cela évite
les auto\-dépendances pour les paquets fournissant des exécutables ELF
(exécutables ou modules complémentaires de bibliothèque) qui utilisent une
bibliothèque incluse dans ce même paquet. Cette option peut être utilisée
plusieurs fois pour exclure plusieurs paquets.
.TP 
\fB\-S\fP\fIrépertoire\-construction\-paquet\fP
Recherche dans \fIrépertoire\-construction\-paquet\fP en premier et essaie de
trouver une bibliothèque (depuis dpkg\ 1.14.15). C'est utile lorsque le
paquet source construit plusieurs saveurs de la même bibliothèque et que
vous voulez vous assurer que vous obtiendrez la dépendance d'un paquet
binaire donné. Cette option peut être utilisée plusieurs fois\ : les
répertoires seront examinés dans le même ordre avant les répertoires
d'autres paquets binaires.
.TP 
\fB\-I\fP\fIrépertoire\-construction\-paquet\fP
Ignore \fIrépertoire\-construction\-paquet\fP lors de la recherche des fichiers
shlibs, de symboles et des bibliothèques partagées (depuis
dpkg\ 1.18.5). Cette option peut être utilisée plusieurs fois.
.TP 
\fB\-\-ignore\-missing\-info\fP
Pas d'échec si l'information de dépendance ne peut pas être trouvée pour une
bibliothèque partagée (depuis dpkg\ 1.14.8). L'utilisation de cette option
est déconseillée, toutes les bibliothèques devraient fournir leurs
informations de dépendance (que ce soit avec les fichiers shlibs, ou avec
les fichiers symboles), même si elles ne sont pas encore utilisées par
d'autres paquets.
.TP 
\fB\-\-warnings=\fP\fIvaleur\fP
\fIvaleur\fP est un champ de «\ bit\ » définissant l'ensemble des avertissements
qui peuvent être émis par \fBdpkg\-shlibdeps\fP (depuis dpkg\ 1.14.17). Le bit
\fB0\fP (valeur\ =\ 1) active l'avertissement «\ symbole \fIsym\fP utilisé par le
\fIbinaire\fP trouvé dans aucune des bibliothèques\ ». Le bit \fB1\fP (valeur\ =\ 2)
active l'avertissement «\ le paquet pourrait éviter une dépendance
inutile\ ». Le bit \fB2\fP (valeur\ =\ 4) active l'avertissement «\ Le \fIbinaire\fP
ne devrait pas être lié à \fIbibliothèque\fP\ ». La \fIvaleur\fP par défaut est
\fB3\fP\ : les deux premières mises en garde sont actives par défaut, la
dernière ne l'est pas. Positionnez la \fIvaleur\fP à\ 7 si vous souhaitez que
tous les avertissements soient actifs.
.TP 
\fB\-\-admindir\fP=\fIrépertoire\fP
Changer l'endroit où se trouve la base de données de \fBdpkg\fP (depuis
dpkg\ 1.14.0). Par défaut, c'est \fI%ADMINDIR%\fP.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH DIAGNOSTICS
.SS Avertissements
Depuis que \fBdpkg\-shlibdeps\fP analyse l'ensemble des symboles utilisés par
chaque binaire généré par le paquet, il est en mesure d'émettre des
avertissements dans plusieurs cas. Ils vous informent des choses qui peuvent
être améliorées dans le paquet. Dans la plupart des cas, ces améliorations
concernent directement les sources amont. Dans l'ordre d'importance
décroissant, voici les différents avertissements que vous pouvez
rencontrer\ :
.TP 
\fBsymbole\fP\fI sym\fP\fB utilisé par \fP\fIbinaire\fP\fB trouvé dans aucune des bibliothèques.\fP
Le symbole indiqué n'a pas été trouvé dans les bibliothèques liées au
binaire. Le \fIbinaire\fP est probablement plutôt une bibliothèque et il doit
être lié avec une bibliothèque supplémentaire durant le processus de
construction (l'option \fB\-l\fP\fIbibliothèque\fP de l'éditeur de liens).
.TP 
\fIbinary\fP\fB contient une référence non résolue au symbole \fP\fIsym\fP\ \fB: il s'agit probablement d'un greffon (plugin)\fP
Le symbole indiqué n'a pas été trouvé dans les bibliothèques liées avec le
fichier binaire. Le \fIbinaire\fP est très probablement un greffon (plugin) et
le symbole est probablement fourni par le programme qui charge ce
greffon. En théorie, un greffon n'a pas de «\ SONAME\ » mais ce binaire en
possède un et n'a pas pu être identifié en tant que tel. Cependant, le fait
que le binaire soit stocké dans un répertoire non public est une indication
forte qu'il ne s'agit pas d'une bibliothèque partagée normale. Si le binaire
est vraiment un greffon, vous pouvez ignorer cet avertissement. Il existe
cependant une possibilité qu'il s'agisse d'un vrai binaire et que les
programmes avec lequel il est lié utilisent un RPATH afin que le chargeur
dynamique le trouve. Dans ce cas, la bibliothèque est incorrecte et doit
être corrigée.
.TP 
\fBpaquet pourrait éviter une dépendance inutile si\fP \fIle binaire\fP \fBn'était pas lié avec\fP \fIbibliothèque\fP \fB(il ne fait usage d'aucun de ses symboles)\fP
Aucun des \fIbinaires\fP liés à la \fIbibliothèque\fP utilise les symboles qu'elle
fournit. En corrigeant tous les binaires, vous éviteriez la dépendance
associée à cette bibliothèque (à moins que la même dépendance soit également
liée à une autre bibliothèque qui est elle réellement utilisée).
.TP 
\fBpaquet pourrait éviter une dépendance inutile si\fP \fIles binaires\fP \fBn'étaient pas liés avec\fP \fIbibliothèque\fP \fB(ils ne font usage d'aucun de ses symboles)\fP
Identique à l'avertissement précédent, pour des binaires multiples.
.TP 
\fIle binaire\fP \fBne devrait pas être lié avec la\fP \fIbibliothèque\fP \fB(il ne fait usage d'aucun de ses symboles)\fP
Le \fIbinaire\fP est lié à une bibliothèque dont il n'a pas besoin. Ce n'est
pas un problème mais de petites améliorations de performance dans le temps
de chargement de celui\-ci peuvent être obtenues en ne le liant pas à cette
bibliothèque. Cet avertissement vérifie la même information que la
précédente mais elle le fait pour tous les binaires au lieu de ne faire le
contrôle qu'au niveau global sur tous les binaires analysés.
.SS Erreurs
\fBdpkg\-shlibdeps\fP échouera s'il ne peut pas trouver de bibliothèque publique
utilisée par un binaire ou si cette bibliothèque n'a pas d'informations sur
les dépendances associées (soit le fichier shlibs, soit le fichier des
symboles). Une bibliothèque publique a un SONAME et un numéro de version
(libsomething.so.\fIX\fP). Une bibliothèque privée (comme un module
additionnel) ne devrait pas avoir de SONAME et n'a pas besoin d'avoir de
version.
.TP 
\fBimpossible de trouver la bibliothèque\fP \fIlibrary\-soname\fP \fBdemandée par le\fP \fIbinaire\fP \fB(son RPATH est «\ \fP\fIrpath\fP\fB\ »)\fP
Le \fIbinaire\fP utilise une bibliothèque appelée \fIlibrary\-soname\fP mais
\fBdpkg\-shlibdeps\fP n'a pas été en mesure de trouver cette
bibliothèque. \fBdpkg\-shlibdeps\fP crée une liste de répertoires à vérifier de
la manière suivante\ : les répertoires énumérés dans le RPATH du binaire, les
répertoires ajoutés par l'option \fB\-l\fP, les répertoires listés dans la
variable d'environnement \fBLD_LIBRARY_PATH\fP, les répertoires croisés
multi\-architerctures (par exemple, /lib/arm64\-linux\-gnu,
/usr/lib/arm64\-linux\-gnu), les répertoires publics standard (/lib,
/usr/lib), les répertoires listés dans /etc/ld.so.conf et les répertoires
obsolètes multilib (/lib32, /usr/lib32, /lib64, /usr/lib64). Ensuite, il
vérifie les répertoires qui sont dans l'arbre de construction du paquet
binaire en cours d'analyse, dans l'arbre de construction du paquet indiqué
avec l'option de ligne de commande \fB\-S\fP, dans les autres arbres de paquets
qui contiennent un fichier DEBIAN/shlibs ou DEBIAN/symbols et enfin dans le
répertoire racine. Si la bibliothèque n'est pas trouvée dans l'un de ces
répertoires, alors ce message d'erreur est obtenu.

Si la bibliothèque non trouvée est cependant disponible dans le répertoire
privé de ce même paquet, alors il vous faut ajouter ce répertoire avec
\fB\-l\fP. S'il est dans un autre paquet binaire en cours de construction, alors
assurez\-vous que le fichier shlibs/symbols de ce paquet a déjà créé et que
\fB\-l\fP contient le répertoire approprié si c'est aussi un répertoire privé.
.TP 
\fBaucune information de dépendance trouvée pour\fP \fIla bibliothèque\fP \fB(utilisée par le\fP \fIbinaire\fP\fB).\fP
La bibliothèque nécessaire au \fIbinaire\fP a été trouvée par \fBdpkg\-shlibdeps\fP
dans \fIfichier\-bibliothèque\fP mais \fBdpkg\-shlibdeps\fP n'a pas été en mesure de
trouver d'informations de dépendance pour cette bibliothèque. Pour trouver
la dépendance, il a essayé de lier la bibliothèque à un paquet Debian avec
l'aide de \fBdpkg \-S \fP\fIfichier\-bibliothèque\fP. Puis, il a vérifié les shlibs
correspondants et les fichiers symboles de %ADMINDIR%/info/ et enfin les
différents arbres des paquets construits (debian/*/DEBIAN/).

Cet échec peut être causé par un shlibs ou un fichier de symboles qui serait
mauvais ou manquant dans le paquet. Une autre cause serait que la
bibliothèque soit construite au sein du même paquet source et que les
fichiers shlibs n'aient pas encore été créés (dans ce cas debian/rules doit
être modifié pour créer le shlibs avant l'appel de \fBdpkg\-shlibdeps\fP). Un
mauvais RPATH peut aussi conduire à ce que la bibliothèque soit trouvée sous
un nom non canonique (comme\ : /usr/lib/openoffice.org/../lib/libssl.so.0.9.8
au lieu de /usr/lib/libssl.so.0.9.8) qui n'est associé à aucun paquet,
\fBdpkg\-shlibdeps\fP essaie de contourner cela en se repliant vers un nom
canonique (en utilisant \fBrealpath\fP(3)), mais cela ne fonctionne pas
toujours. Il est toujours préférable de bien nettoyer le RPATH du binaire
afin d'éviter ces problèmes.

L'appel de \fBdpkg\-shlibdeps\fP en mode bavard (\fB\-v\fP) fournira beaucoup plus
d'informations sur l'endroit où il a essayé de trouver l'information sur les
dépendances. Cela peut être utile si vous ne comprenez pas pourquoi vous
obtenez cette erreur.
.SH "VOIR AUSSI"
\fBdeb\-shlibs\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-gensymbols\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
