.\" dpkg manual page - dpkg-mergechangelogs(1)
.\"
.\" Copyright © 2009-2010 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-mergechangelogs 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dpkg\-mergechangelogs \- Fusion triple de fichiers debian/changelog
.
.SH SYNOPSIS
\fBdpkg\-mergechangelogs\fP [\fIoption\fP...] \fIancien\fP \fInouveau\-a\fP \fInouveau\-b\fP
[\fIsortie\fP]
.
.SH DESCRIPTION
.P
Ce programme utilise les 3 versions fournies de journal des modifications
(«\ changelog\ ») Debian pour créer un fichier de journalisation fusionné. Le
résultat est placé dans le fichier \fIsortie\fP ou affiché sur la sortie
standard si ce paramètre est omis.
.P
Chaque entrée est identifiée par son numéro de version. Les entrées ne sont
pas censées entrer en conflit, mais sont simplement fusionnées dans le bon
ordre (par numéro de version décroissant). Si l'option
\fB\-\-merge\-prereleases\fP est utilisée, la partie de numéro de version qui suit
le dernier caractère tilde est omise\ ; les versions 1.0\-1~exp1 et 1.0\-1~exp5
sont ainsi considérées comme la même entrée. Quand la même version est
mentionnée dans \fInouveau\-a\fP et \fInouveau\-b\fP, une fusion «\ 3\-way\ » standard
est tentée (sous réserve que le module Algorithm::Merge soit disponible —\ il
est fourni par le paquet libalgorithm\-merge\-perl. Dans le cas contraire, un
conflit global est créé dans le contexte de cette entrée.
.
.SH OPTIONS
.TP 
\fB\-m\fP, \fB\-\-merge\-prereleases\fP
Omet la version qui suit le dernier caractère tilde dans les numéros de
versions, lors de la comparaison qui permet d'identifier si deux entrées
sont les mêmes ou pas.
.sp
Cette option est utile lorsqu'on conserve la même entrée de journal mais que
la version est incrémentée régulièrement. Par exemple, cela permet
d'utiliser les numéros 2.3\-1~exp1, 2.3\-1~exp2, etc., jusqu'à une publication
officielle numérotée 2.3\-1, toutes ces versions étant considérées comme
l'évolution dans le temps de la même version.
.TP 
\fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH LIMITATIONS
.P
Tout ce qui ne peut pas être analysé par Dpkg::Changelog est perdu lors de
la fusion. Cela peut comprendre des commentaires qui ne sont pas censés se
trouver là,\ etc.
.
.SH "INTÉGRATION AVEC GIT"
.P
Si vous souhaitez utiliser ce programme pour fusionner des journaux de
modifications Debian dans un dépôt git, vous devez tout d'abord enregistrer
un nouveau pilote de fusion dans \fB.git/config\fP ou \fB~/.gitconfig\fP\ :
.P
 [merge "dpkg\-mergechangelogs"]
     name = debian/changelog merge driver
     driver = dpkg\-mergechangelogs \-m %O %A %B %A
.P
Vous devez ensuite configurer l'attribut de fusion pour le fichier
debian/changelog, soit dans \fB.gitattributes\fP du dépôt lui\-même, soit dans
\&\fB.git/info/attributes\fP\ :
.P
 debian/changelog merge=dpkg\-mergechangelogs
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
