.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-gensymbols 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
dpkg\-gensymbols \- generate symbols files (shared library dependency information)
.
.SH SYNOPSIS
.B dpkg\-gensymbols
.RI [ option ...]
.
.SH DESCRIPTION
.B dpkg\-gensymbols
scans a temporary build tree (debian/tmp by default) looking for libraries
and generates a \fIsymbols\fR file describing them. This file, if
non-empty, is then installed in the DEBIAN subdirectory of the build tree
so that it ends up included in the control information of the package.
.P
When generating those files, it uses as input some symbols files
provided by the maintainer. It looks for the following files (and uses the
first that is found):
.IP • 4
debian/\fIpackage\fR.symbols.\fIarch\fR
.IP • 4
debian/symbols.\fIarch\fR
.IP • 4
debian/\fIpackage\fR.symbols
.IP • 4
debian/symbols
.P
The main interest of those files is to provide the minimal version
associated to each symbol provided by the libraries. Usually it
corresponds to the first version of that package that provided the symbol,
but it can be manually incremented by the maintainer if the ABI of the
symbol is extended without breaking backwards compatibility. It's the
responsibility of the maintainer to keep those files up-to-date and
accurate, but \fBdpkg\-gensymbols\fR helps with that.
.P
When the generated symbols files differ from the maintainer supplied
one, \fBdpkg\-gensymbols\fR will print a diff between the two versions.
Furthermore if the difference is too significant, it will even fail (you
can customize how much difference you can tolerate, see the \fB\-c\fR
option).
.SH MAINTAINING SYMBOLS FILES
The base interchange format of the symbols file is described in
\fBdeb\-symbols\fP(5), which is used by the symbols files included in
binary packages. These are generated from template symbols files
with a format based on the former, described in \fBdeb\-src\-symbols\fP(5)
and included in source packages.
.P
The symbols files are really useful only if they reflect the evolution of
the package through several releases. Thus the maintainer has to update
them every time that a new symbol is added so that its associated minimal
version matches reality.
.P
The diffs contained in the build logs can be used as a starting point,
but the maintainer, additionally, has to make sure that the behaviour
of those symbols has not changed in a way that would make anything
using those symbols and linking against the new version, stop working
with the old version.
.P
In most cases, the diff applies directly to the
debian/\fIpackage\fR.symbols file. That said, further tweaks are usually
needed: it's recommended for example to drop the Debian revision
from the minimal version so that backports with a lower version number
but the same upstream version still satisfy the generated dependencies.
If the Debian revision can't be dropped because the symbol really got
added by the Debian specific change, then one should suffix the version
with ‘\fB~\fP’.
.P
Before applying any patch to the symbols file, the maintainer should
double-check that it's sane. Public symbols are not supposed to disappear,
so the patch should ideally only add new lines.
.P
Note that you can put comments in symbols files.
.P
Do not forget to check if old symbol versions need to be increased.
There is no way \fBdpkg\-gensymbols\fP can warn about this. Blindly
applying the diff or assuming there is nothing to change if there is
no diff, without checking for such changes, can lead to packages with
loose dependencies that claim they can work with older packages they
cannot work with. This will introduce hard to find bugs with (partial)
upgrades.
.SS Good library management
.P
A well-maintained library has the following features:
.IP • 4
its API is stable (public symbols are never dropped, only new public
symbols are added) and changes in incompatible ways only when the SONAME
changes;
.IP • 4
ideally, it uses symbol versioning to achieve ABI stability despite
internal changes and API extension;
.IP • 4
it doesn't export private symbols (such symbols can be tagged optional as
workaround).
.P
While maintaining the symbols file, it's easy to notice appearance and
disappearance of symbols. But it's more difficult to catch incompatible
API and ABI change. Thus the maintainer should read thoroughly the
upstream changelog looking for cases where the rules of good library
management have been broken. If potential problems are discovered,
the upstream author should be notified as an upstream fix is always better
than a Debian specific work-around.
.SH OPTIONS
.TP
.BI \-P package-build-dir
Scan \fIpackage-build-dir\fR instead of debian/tmp.
.TP
.BI \-p package
Define the package name. Required if more than one binary package is listed in
debian/control (or if there's no debian/control file).
.TP
.BI \-v version
Define the package version. Defaults to the version extracted from
debian/changelog. Required if called outside of a source package tree.
.TP
.BI \-e library-file
Only analyze libraries explicitly listed instead of finding all public
libraries. You can use shell patterns used for pathname expansions (see
the \fBFile::Glob\fP(3perl) manual page for details) in \fIlibrary-file\fR
to match multiple libraries with a single argument (otherwise you need
multiple \fB\-e\fR).
.TP
.BI \-l directory
Prepend
.I directory
to the list of directories to search for private shared libraries
(since dpkg 1.19.1). This option can be used multiple times.

Note: Use this option instead of setting \fBLD_LIBRARY_PATH\fP,
as that environment variable is used to control the run-time linker
and abusing it to set the shared library paths at build-time can be
problematic when cross-compiling for example.
.TP
.BI \-I filename
Use \fIfilename\fR as reference file to generate the symbols file
that is integrated in the package itself.
.TP
.BR \-O [\fIfilename\fP]
Print the generated symbols file to standard output or to \fIfilename\fR
if specified, rather than to
.B debian/tmp/DEBIAN/symbols
(or
.IB package-build-dir /DEBIAN/symbols
if
.B \-P
was used). If \fIfilename\fR is pre-existing, its contents are used as
basis for the generated symbols file.
You can use this feature to update a symbols file so that it matches a
newer upstream version of your library.
.TP
.BI \-t
Write the symbol file in template mode rather than the format compatible with
\fBdeb\-symbols\fP(5). The main difference is that in the template mode symbol
names and tags are written in their original form contrary to the
post-processed symbol names with tags stripped in the compatibility mode.
Moreover, some symbols might be omitted when writing a standard
\fBdeb\-symbols\fP(5) file (according to the tag processing rules) while all
symbols are always written to the symbol file template.
.TP
.BI \-c [0-4]
Define the checks to do when comparing the generated symbols file with the
template file used as starting point. By default the level is 1. Increasing
levels do more checks and include all checks of lower levels. Level 0 never
fails. Level 1 fails if some symbols have disappeared. Level 2 fails if some
new symbols have been introduced. Level 3 fails if some libraries have
disappeared. Level 4 fails if some libraries have been introduced.

This value can be overridden by the environment variable
.BR DPKG_GENSYMBOLS_CHECK_LEVEL .
.TP
.BI \-q
Keep quiet and never generate a diff between generated symbols file and the
template file used as starting point or show any warnings about new/lost
libraries or new/lost symbols. This option only disables informational output
but not the checks themselves (see \fB\-c\fP option).
.TP
.BI \-a arch
Assume \fIarch\fR as host architecture when processing symbol files. Use this
option to generate a symbol file or diff for any architecture provided its
binaries are already available.
.TP
.BI \-d
Enable debug mode. Numerous messages are displayed to explain what
.B dpkg\-gensymbols
does.
.TP
.BI \-V
Enable verbose mode. The generated symbols file contains deprecated
symbols as comments. Furthermore in template mode, pattern symbols
are followed by comments listing real symbols that have matched the
pattern.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH ENVIRONMENT
.TP
.B DPKG_GENSYMBOLS_CHECK_LEVEL
Overrides the command check level, even if the \fB\-c\fP command-line
argument was given (note that this goes against the common convention
of command-line arguments having precedence over environment variables).
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH SEE ALSO
.BR https://people.redhat.com/drepper/symbol\-versioning
.br
.BR https://people.redhat.com/drepper/goodpractice.pdf
.br
.BR https://people.redhat.com/drepper/dsohowto.pdf
.br
.BR deb\-src\-symbol (5),
.BR deb\-symbols (5),
.BR dpkg\-shlibdeps (1).
