.\" dpkg manual page - deb-split(5)
.\"
.\" Copyright © 2009-2012 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-split 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
deb\-split \- Debian multi-part binary package format
.SH SYNOPSIS
.IB filename .deb
.SH DESCRIPTION
The multi-part \fB.deb\fP format is used to split big packages into smaller
pieces to ease transport in small media.
.SH FORMAT
The file is an \fBar\fP archive with a magic value of \fB!<arch>\fP.
The file names might contain a trailing slash (since dpkg 1.15.6).
.PP
The first member is named \fBdebian\-split\fP and contains a series
of lines, separated by newlines. Currently eight lines are present:
.IP • 4
The format version number, \fB2.1\fP at the time this manual page was
written.
.IP •
The package name.
.IP •
The package version.
.IP •
The md5sum of the package.
.IP •
The total size of the package.
.IP •
The maximum part size.
.IP •
The current part number, followed by a slash and the total amount of
parts (as in ‘1/10’).
.IP •
The package architecture (since dpkg 1.16.1).
.PP
Programs which read multi-part archives should be prepared for the minor
format version number to be increased and additional lines to be present,
and should ignore these if this is the case.
.PP
If the major format version number has changed, an incompatible change has
been made and the program should stop. If it has not, then the program should
be able to safely continue, unless it encounters an unexpected member
in the archive (except at the end), as described below.
.PP
The second, last required member is named \fBdata.\fP\fIN\fP, where \fIN\fP
denotes the part number. It contains the raw part data.
.PP
These members must occur in this exact order. Current implementations
should ignore any additional members after \fBdata.\fP\fIN\fP.
Further members may be defined in the future, and (if possible) will be
placed after these two.
.SH SEE ALSO
.BR deb (5),
.BR dpkg\-split (1).
