.\" dpkg manual page - deb-postrm(5)
.\"
.\" Copyright © 2016 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-postrm 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
deb\-postrm \- package post-removal maintainer script
.
.SH SYNOPSIS
postrm
.
.SH DESCRIPTION
A package can perform several post-removal actions via maintainer
scripts, by including an executable \fIpostrm\fP file in its control
archive (i.e. \fIDEBIAN/postrm\fP during package creation).
.PP
The script can be called in the following ways:
.TP
\fIpostrm\fP \fBremove\fP
After the package was removed.
.TP
\fIpostrm\fP \fBpurge\fP
After the package was purged.
.TP
\fIold-postrm\fP \fBupgrade\fP \fInew-version\fP
After the package was upgraded.
.TP
\fInew-postrm\fI \fBfailed-upgrade\fP \fIold-version new-version\fP
If the above \fBupgrade\fP call fails.
.TP
\fIpostrm\fP \fBdisappear\fP \fIoverwriter-package\fP \fIoverwriter-version\fP
After all of the packages files have been replaced.
.TP
\fInew-postrm\fP \fBabort-install\fP
If \fIpreinst\fP fails during install.
.TP
\fInew-postrm\fP \fBabort-install\fP \fIold-version new-version\fP
If \fIpreinst\fP fails during upgrade of removed package.
.TP
\fInew-postrm\fP \fBabort-upgrade\fP \fIold-version new-version\fP
If \fIpreinst\fP fails during upgrade.
.
.SH SEE ALSO
.BR dpkg (1).
