.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.ad l
.nh
.SH BEZEICHNUNG
dpkg\-gensymbols \- Symboldateien (Abhängigkeitsinformationen für
Laufzeitbibliotheken) erstellen
.
.SH ÜBERSICHT
\fBdpkg\-gensymbols\fP [\fIOption\fP …]
.
.SH BESCHREIBUNG
\fBdpkg\-gensymbols\fP durchsucht einen temporären Baubaum (standardmäßig
debian/tmp), sucht nach Bibliotheken und erstellt eine Datei \fIsymbols\fP, die
diese beschreibt. Diese Datei wird, falls sie nicht leer ist, in das
Unterverzeichnis DEBIAN des Baubaums installiert, so dass sie schlussendlich
in der Steuerinformation des Pakets auftaucht.
.P
Beim Erstellen dieser Dateien verwendet es als Eingabe einige vom Betreuer
bereitgestellte Symboldateien. Es sucht nach den folgenden Dateien (und
verwendet die erste, die gefunden wird):
.IP • 4
debian/\fIPaket\fP.symbols.\fIArchitektur\fP
.IP • 4
debian/symbols.\fIArchitektur\fP
.IP • 4
debian/\fIPaket\fP.symbols
.IP • 4
debian/symbols
.P
Der Hauptzweck dieser Dateien besteht darin, die minimale Version
bereitzustellen, die mit jedem von der Bibliothek bereitgestellten Symbol
verknüpft ist. Normalerweise entspricht dies der ersten Version des Pakets,
die dieses Symbol bereitgestellt hat, kann aber vom Betreuer erhöht werden,
falls die ABI des Symbols ohne Brechen der Rückwärtskompatibilität erweitert
wurde. Es liegt in der Verantwortung des Betreuers, diese Dateien aktuell zu
halten, aber \fBdpkg\-gensymbols\fP hilft dabei.
.P
Wenn die erstellten Symboldateien sich von denen, die der Betreuer
bereitgestellt hat, unterscheiden, wird \fBdpkg\-gensymbols\fP einen Diff
zwischen den zwei Versionen anzeigen. Falls die Unterschiede desweiteren zu
gravierend sind, wird es sogar fehlschlagen (Sie können einstellen, wie
große Unterschiede Sie tolerieren können, sehen Sie hierzu die Option
\fB\-c\fP).
.SH "SYMBOLDATEIEN PFLEGEN"
Das grundlegende Austauschformat der Symboldatei wird in \fBdeb\-symbols\fP(5)
beschrieben. Dies wird von den in Binärpaketen enthaltenen Symboldateien
verwandt. Diese werden aus Vorlage\-Symboldateien erstellt, deren Format auf
Ersterem basiert, in \fBdeb\-src\-symbols\fP(5) beschrieben und in Quellpaketen
enthalten ist.
.P
Die Symboldateien sind nur wirklich nützlich, falls sie die Entwicklung
eines Paketes über mehrere Veröffentlichungen hinweg wiedergeben. Daher muss
der Betreuer sie immer aktualisieren, wenn eine neues Symbol hinzugefügt
wird, so dass die zugeordnete minimale Version der Realität entspricht.
.P
Die in den Bauprotokollen enthaltenen Diffs können als Startpunkt benutzt
werden, aber zusätzlich hat der Betreuer sicherzustellen, dass sich das
Verhalten dieser Symbole nicht derart geändert hat, dass irgendetwas, was
diese Symbole verwendet und gegen die neue Version gelinkt ist, daran
hindern würde, mit der alten Version zu funktionieren.
.P
Meistens kann der Diff direkt auf die Datei debian/\fIPaket\fP.symbols
angewandt werden. Allerdings werden normalerweise weitere Anpassungen
notwendig: es wird beispielsweise empfohlen, die Debian\-Revision von der
minimalen Version zu entfernen, so dass Backports mit einer niedrigeren
Versionsnummer, aber der gleichen Version der Originalautoren immer noch die
erstellten Abhängigkeiten erfüllen. Falls die Debian\-Revision nicht entfernt
werden kann, da das Symbol wirklich von der Debian\-spezifischen Änderung
hinzugefügt wurde, dann sollte der Version ‚\fB~\fP’ angehängt werden.
.P
Bevor irgendein Patch auf die Symboldatei angewendet wird, sollte der
Betreuer zweimal prüfen, dass der Patch vernünftig ist. Öffentliche Symbole
sollten nicht verschwinden, daher sollte der Patch idealerweise nur neue
Zeilen hinzufügen.
.P
Beachten Sie, dass Sie in Symboldateien Kommentare verwenden können.
.P
Vergessen Sie nicht, zu überprüfen, ob alte Versionen aktualisiert werden
müssen. Es gibt für \fBdpkg\-gensymbols\fP keine Möglichkeit, hierzu eine
Warnung auszugeben. Wird der Diff blind akzeptiert oder wird angenommen,
dass nichts geändert werden muss, wenn es keinen Diff gibt, ohne auf
Änderungen zu prüfen, kann dies dazu führen, dass lockere Abhängigkeiten
erzeugt werden, laut deren mit älteren Versionen gearbeitet werden kann,
obwohl dies nicht möglich ist. Dies wird zu schwer zu findenden Fehlern bei
(teilweisen) Upgrades führen.
.SS "Gute Bibliotheksverwaltung"
.P
Eine gut verwaltete Bibliothek hat die folgenden Eigenschaften:
.IP • 4
ihre API ist stabil (öffentliche Symbole entfallen nie, nur neue öffentliche
Symbole werden hinzugefügt) und inkompatible Änderungen erfolgen nur, wenn
sich der SONAME ändert,
.IP • 4
idealerweise verwendet sie Symbolversionierung, um ABI\-Stabilität trotz
interner Änderungen und API\-Erweiterungen zu erreichen,
.IP • 4
sie exportiert nie private Symbole (als Hilfslösung können diese als
optional gekennzeichnet werden).
.P
Bei der Verwaltung der Symboldatei kann das Auftauchen und Verschwinden von
Symbolen leicht bemerkt werden. Es ist aber schwieriger, inkompatbile API\-
und ABI\-Änderungen zu bemerken. Daher sollte der Betreuer intensiv die
Changelog\-Einträge der Originalautoren durchschauen und nach Fällen suchen,
in denen die Regeln der guten Bibliotheksverwaltung gebrochen wurden. Falls
mögliche Probleme entdeckt wurden, sollten der Originalautor informiert
werden, da eine Korrektur vom Originalautor immer besser als eine
Debian\-spezifische Hilfslösung ist.
.SH OPTIONEN
.TP 
\fB\-P\fP\fIPaketbauverzeichnis\fP
Sucht nach \fIPaketbauverzeichnis\fP statt nach debian/tmp.
.TP 
\fB\-p\fP\fIPaket\fP
Definiert den Paketnamen. Wird benötigt, falls mehr als ein binäres Paket in
debian/control aufgeführt ist (oder falls es keine Datei debian/control
gibt).
.TP 
\fB\-v\fP\fIVersion\fP
Definiert die Paketversion. Standardmäßig wird die Version aus
\fIdebian/changelog\fP entnommen. Benötigt, falls der Aufruf außerhalb des
Quellpaketbaums erfolgt.
.TP 
\fB\-e\fP\fIBibliotheksdatei\fP
Untersucht nur die explizit aufgeführten Bibliotheken, statt nach allen
öffentlichen Bibliotheken zu suchen. Sie können Shell\-Muster, die zur
Expansion von Pfadnamen verwandt werden (siehe die Handbuchseite
\fBFile::Glob\fP(3perl) für weitere Details) in \fIBibliotheksdatei\fP verwenden,
um mehrere Bibliotheken mit einem einzelnen Argument abzugleichen
(andernfalls benötigen Sie mehrere \fB\-e\fP).
.TP 
\fB\-l\fP\fIVerzeichnis\fP
Stellt \fIVerzeichnis\fP der Liste der zu durchsuchenden privaten
Laufzeitbibliotheken voran (seit Dpkg 1.19.1). Diese Option kann mehrfach
angegeben werden.

Hinweis: Verwenden Sie diese Variable, statt \fBLD_LIBRARY_PATH\fP zu setzen,
da diese Umgebungsvariable verwandt wird, um den Laufzeit\-Linker zu steuern
und ihr Missbrauch zum Setzen von Pfaden zu Laufzeitbibliotheken zur Bauzeit
kann beispielsweise beim Cross\-Kompilieren problematisch werden.
.TP 
\fB\-I\fP\fIDateiname\fP
Verwendet \fIDateiname\fP als Referenzdatei, um die Symboldatei zu erstellen,
die dann im Paket selbst integriert wird.
.TP 
\fB\-O\fP[\fIDateiname\fP]
Die erstellte Symbols\-Datei auf die Standardausgabe oder nach \fIDateiname\fP,
falls angegeben, ausgeben statt in \fBdebian/tmp/DEBIAN/symbols\fP (oder
\fIPaket\-Bauverzeichnis\fP\fB/DEBIAN/symbols\fP, falls \fB\-P\fP verwandt
wurde). Falls \fIDateiname\fP bereits existiert, wird deren Inhalt als
Grundlage für die erstellte Symboldatei verwandt. Sie können diese
Funktionalität benutzen, um eine Symboldatei zu aktualisieren, so dass sie
zu einer neueren Version der Originalautoren Ihrer Bibliothek passt.
.TP 
\fB\-t\fP
Schreibt die Symboldatei im Vorlagenmodus statt im zu \fBdeb\-symbols\fP(5)
kompatiblen Format. Der Hauptunterschied besteht darin, dass im
Vorlagenmodus die Symbolnamen und Kennzeichnungen in ihrer Originalform
geschrieben werden, im Gegensatz zu den verarbeiteten Symbolnamen mit
entfernten Kennzeichnungen im Kompatibilitätsmodus. Desweiteren könnten
einige Symbole beim Schreiben einer Standard\-\fBdeb\-symbols\fP(5)\-Datei
entfernt werden (gemäß der Verarbeitungsregeln für Kennzeichen), während in
der Symboldateivorlage immer alle Symbole geschrieben werden.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Definiert die Prüfungen, die beim Vergleich der erstellten Symboldatei mit
der Vorlagendatei als Startpunkt erfolgen sollen. Standardstufe ist
1. Zunehmende Stufen führen mehr Prüfungen durch und enthalten alle
Prüfungen der niedrigeren Stufen. Stufe 0 schlägt nie fehl. Stufe 1 schlägt
fehl, wenn einige Symbole verschwunden sind. Stufe 2 schlägt fehl, falls
einige neue Symbole eingeführt wurden. Stufe 3 schlägt fehl, falls einige
Bibliotheken verschwunden sind. Stufe 4 schlägt fehl, falls einige
Bibliotheken hinzugekommen sind.

Dieser Wert kann von der Umgebungsvariablen \fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
außer Kraft gesetzt werden.
.TP 
\fB\-q\fP
Ruhig verhalten und nie einen Diff zwischen der erstellten Symboldatei und
der als Startpunkt verwandten Vorlagendatei erstellen oder keine Warnungen
bezüglich neuer/verschwundener Bibliotheken oder neuer/verschwundener
Symbole ausgeben. Diese Option deaktiviert nur die informative Ausgabe, aber
nicht die Prüfungen selbst (sehen Sie hierzu die Option \fB\-c\fP).
.TP 
\fB\-a\fP\fIArchitektur\fP
Nimmt \fIArch\fP als Host\-Architektur beim Verarbeiten der Symboldateien
an. Verwenden Sie diese Option, um Symboldateien oder Diffs für beliebige
Architekturen zu erstellen, vorausgesetzt, die Binärprogramme sind bereits
verfügbar.
.TP 
\fB\-d\fP
Debug\-Modus aktivieren. Eine Vielzahl von Meldungen wird angezeigt, um zu
erklären, was \fBdpkg\-gensymbols\fP durchführt.
.TP 
\fB\-V\fP
Ausführlichen Modus aktivieren. Die erstellte Symboldatei enthält veraltete
Symbole als Kommentare. Im Vorlagenmodus werden Mustersymbole desweiteren
von Kommentaren gefolgt, die die echten Symbole aufführen, die auf dieses
Muster passen.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeigt einen Hinweis zum Aufruf und beendet das Programm.
.TP 
\fB\-\-version\fP
Gibt die Version aus und beendet das Programm.
.
.SH UMGEBUNG
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Setzt die Befehlsüberprüfungsstufe außer Kraft, selbst wenn das
Befehlszeilenargument \fB\-c\fP übergeben wurde (beachten Sie, dass dies der
üblichen Konvention widerspricht, demnach Befehlszeilenargumente Vorrang
gegenüber Umgebungsvariablen haben).
.TP 
\fBDPKG_COLORS\fP
Setzt den Farbmodus (seit Dpkg 1.18.5). Die derzeit unterstützten Werte
sind: \fBauto\fP (Vorgabe), \fBalways\fP und \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Falls dies gesetzt ist, wird es zur Entscheidung, ob Native Language
Support, auch als Unterstützung für Internationalisierung (oder i18n)
bekannt, aktiviert wird (seit Dpkg 1.19.0). Die akzeptierten Werte sind:
\fB0\fP und \fB1\fP (Vorgabe).
.
.SH "SIEHE AUCH"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-src\-symbol\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2020 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
