.\" dpkg manual page - dsc(5)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dsc 5 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
dsc \- Indeling van het controlebestand van Debian\-broncodepakketten
.
.SH OVERZICHT
\fIbestandsnaam\fP\fB.dsc\fP
.
.SH BESCHRIJVING
Elk Debian broncodepakket bevat een .dsc\-controlebestand dat uit een aantal
velden bestaat. Ieder veld begint met een markering, zoals \fBSource\fP of
\fBBinary\fP (niet hoofdlettergevoelig), gevolgd door een dubbele punt en de
tekstinhoud van het veld. Velden worden enkel door veldmarkeringen
begrensd. De tekstinhoud van het veld kan met andere woorden verschillende
regels lang zijn, maar de installatiegereedschappen zullen bij het verwerken
van de tekstinhoud de regels gewoonlijk samenvoegen (behalve in het geval
van de multiregel\-velden \fBPackage\-List\fP, \fBFiles\fP, \fBChecksums\-Sha1\fP en
\fBChecksums\-Sha256\fP; zie hierna)
.PP
De controle\-data mogen ingesloten liggen in een OpenPGP\-handtekening met
ASCII\-harnas volgens de specificatie RFC4880.
.
.SH VELDEN
.TP 
\fBFormat:\fP \fIindelingsversie\fP (verplicht)
The value of this field declares the format version of the source package.
The field value is used by programs acting on a source package to interpret
the list of files in the source package and determine how to unpack it.  The
syntax of the field value is a numeric major revision (“0\-9”), a period
(“.”), a numeric minor revision (“0\-9”), and then an optional subtype after
whitespace (“\ \et”), which if specified is a lowercase alphanumeric
(“a\-z0\-9”) word in parentheses (“()”).  The subtype is optional in the
syntax but may be mandatory for particular source format revisions.

De indelingen van de broncode die momenteel ondersteund worden door \fBdpkg\fP
zijn \fB1.0\fP, \fB2.0\fP, \fB3.0 (native)\fP, \fB3.0 (quilt)\fP, \fB3.0 (git)\fP, \fB3.0
(bzr)\fP en \fB3.0 (custom)\fP. Raadpleeg \fBdpkg\-source\fP(1) voor de beschrijving
ervan.
.TP 
\fBSource:\fP \fIbroncode\-naam\fP (verplicht)
De waarde van dit veld bepaalt de pakketnaam en wordt door de meeste
installatiegereedschappen gebruikt om bestandsnamen te genereren.
.TP 
\fBBinary:\fP\fI lijst\-van\-binaire\-pakketten\fP
Dit gevouwen veld somt, door komma's van elkaar gescheiden, de binaire
pakketten op die door dit broncodepakket gebouwd kunnen worden.

Dit veld is nu vervangen door het veld \fBPackage\-List\fP dat voldoende
informatie geeft over welke binaire pakketten op welke architecturen
geproduceerd worden, over bouwprofielen en over andere restricties die van
belang zijn.
.TP 
\fBArchitecture:\fP \fIarch\-lijst\fP (aanbevolen)
Een lijst van door spaties van elkaar gescheiden architecturen en
architectuurjokertekens die aangeven voor welk type hardware dit pakket
gecompileerd kan worden. Gebruikelijke architectuurnamen en
architectuurjokertekens zijn \fBamd64\fP, \fBarmel\fP, \fBi386\fP, \fBlinux\-any\fP,
\fBany\-amd64\fP, enz.

Merk op dat de waarde \fBall\fP bedoeld is voor pakketten die
architectuuronafhankelijk zijn en \fBany\fP voor pakketten die
architectuurafhankelijk zijn. De lijst mag de speciale waarde  \fBall\fP
bevatten (of er uitsluitend uit bestaan). Wanneer de lijst het
architectuurjokerteken \fBany\fP bevat, is \fBall\fP de enige andere toegelaten
waarde in de lijst.

De waarde van dit veld wordt gewoonlijk gegenereerd op basis van de
\fBArchitecture\fP\-velden in het bestand \fIdebian/control\fP van het
broncodepakket.
.TP 
\fBVersion:\fP \fIversie\-tekenreeks\fP (verplicht)
Gewoonlijk is dit het originele versienummer van het pakket, welke vorm de
auteur van het programma er ook voor gebruikt. Het kan ook een
Debian\-revisienummer bevatten (voor niet uit Debian stammende pakketten). De
exacte indeling en het sorteringsalgoritme worden beschreven in
\fBdeb\-version\fP(7).
.TP 
\fBOrigin:\fP\fI naam\fP
De naam van de distributie waaruit dit pakket afkomstig is.
.TP 
\fBMaintainer:\fP \fIvolledige\-naam\-en\-e\-mail\fP (aanbevolen)
Moet opgemaakt worden volgens de indeling “Joe Bloggs
<jbloggs@foo.com>”, en is gewoonlijk de persoon die het pakket
maakte, in tegenstelling tot de auteur van de verpakte software.
.TP 
\fBUploaders:\fP\fI lijst van volledige\-namen\-en\-e\-mailadressen\fP
Somt al de namen en de e\-mailadressen op van de personen die het pakket mee
onderhouden volgens dezelfde indeling als van het veld
\fBMaintainer\fP. Meerdere mede\-onderhouders moeten onderling door een komma
gescheiden worden.
.TP 
\fBDescription:\fP \fIkorte\-beschrijving\fP
.TQ
\fB \fP\fIuitgebreide\-beschrijving\fP
De indeling van een pakketbeschrijving bestaat uit een beknopte korte
samenvatting op de eerste regel (na de veldmarkering \fBDescription\fP). De
daaropvolgende regels moeten gebruikt worden voor een langere, meer
gedetailleerde beschrijving. Elke regel van de uitgebreide beschrijving moet
voorafgegaan worden door een spatie, en lege regels in de uitgebreide
beschrijving moeten één enkele ‘\fB.\fP’ bevatten die volgt op de eraan
voorafgaande spatie.
.TP 
\fBHomepage:\fP\fI URL\fP
De \fIURL\fP van de homepage van het toeleverend project (upstream).
.TP 
\fBStandards\-Version:\fP \fIversietekenreeks\fP (aanbevolen)
Dit documenteert de meest recente versie van de normen die vastgelegd werden
in de richtlijnen van de distributie en waaraan dit pakket voldoet.
.TP 
\fBVcs\-Browser:\fP\fI URL\fP
De \fIurl\fP van een webinterface waarmee door de opslagruimte van het
versiecontrolesysteem kan gebladerd worden.
.TP 
\fBVcs\-Arch:\fP\fI URL\fP
.TQ
\fBVcs\-Bzr:\fP\fI URL\fP
.TQ
\fBVcs\-Cvs:\fP\fI URL\fP
.TQ
\fBVcs\-Darcs:\fP\fI URL\fP
.TQ
\fBVcs\-Git:\fP\fI URL\fP
.TQ
\fBVcs\-Hg:\fP\fI URL\fP
.TQ
\fBVcs\-Mtn:\fP\fI URL\fP
.TQ
\fBVcs\-Svn:\fP\fI URL\fP
Deze velden declareren de \fIurl\fP van de opslagruimte van het
versiecontrolesysteem dat gebruikt wordt om dit pakket te onderhouden. Zie
\fBdeb\-src\-control\fP(5) voor verdere informatie.
.TP 
\fBTestsuite:\fP\fI namenlijst\fP
Dit veld declareert dat het broncodepakket de opgegeven testsuites bevat. De
waarde is een lijst van onderling door komma's gescheiden testsuites. Indien
de waarde \fBautopkgtest\fP bestaat, wordt verondersteld dat het bestand
\fIdebian/tests/control\fP bestaat. Indien het bestand bestaat, maar de waarde
niet, dan zal \fBdpkg\-source\fP die automatisch toevoegen met behoud van de
vroegere waarden.
.TP 
\fBTestsuite\-Triggers:\fP\fI pakketlijst\fP
This field declares the comma\-separated union of all test dependencies
(\fBDepends\fP fields in \fIdebian/tests/control\fP file), with all restrictions
removed, and OR dependencies flattened (that is, converted to separate AND
relationships), except for binaries generated by this source package and its
meta\-dependency equivalent \fB@\fP.

Motivering: dit veld is noodzakelijk omdat anders elk broncodepakket
uitgepakt zou moeten worden om de testvereisten te kunnen achterhalen.
.TP 
\fBBuild\-Depends:\fP\fI pakketlijst\fP
.TQ
\fBBuild\-Depends\-Arch:\fP\fI pakketlijst\fP
.TQ
\fBBuild\-Depends\-Indep:\fP\fI pakketlijst\fP
.TQ
\fBBuild\-Conflicts:\fP\fI pakketlijst\fP
.TQ
\fBBuild\-Conflicts\-Arch:\fP\fI pakketlijst\fP
.TQ
\fBBuild\-Conflicts\-Indep:\fP\fI pakketlijst\fP
Deze velden declareren de relaties tussen het broncodepakket en de pakketten
die gebruikt worden om het te bouwen. Zij worden besproken in de man\-pagina
\fBdeb\-src\-control\fP(5).
.TP 
\fBPackage\-List:\fP
.TQ
 \fIpakket\fP \fIpakkettype\fP \fIsectie\fP \fIprioriteit\fP \fItrefwoord\-waarde\-lijst\fP
Dit multiregel\-veld bevat een lijst van binaire pakketten die door dit
broncodepakket gegenereerd worden.

Het element \fIpakket\fP is de naam van het binaire pakket.

Het element \fIpakket\-type\fP is het type van het binaire pakket, meestal
\fBdeb\fP; een andere gebruikelijke waarde is \fBudeb\fP.

De elementen \fIsectie\fP (section) en \fIprioriteit\fP (priority) komen overeen
met de velden met dezelfde naam van het binaire pakket.

Het element \fItrefwoord\-waarde\-lijst\fP is een lijst van door spaties
gescheiden \fItrefwoord\fP\fB=\fP\fIwaarde\fP en de momenteel herkende optionele
trefwoorden zijn:

.RS
.TP 
\fBarch\fP
De architectuurrestrictie uit het veld \fBArchitecture\fP van het binaire
pakket, waarbij spaties naar ‘,’ geconverteerd worden.
.TP 
\fBprofile\fP
De genormaliseerde bouwprofiel\-restrictieformule uit het veld
\fBBuild\-Profile\fP van het binaire pakket, waarbij OR's omgezet worden naar
‘+’ en AND's naar ‘,’.
.TP 
\fBessential\fP
Indien het binaire pakket essentieel (essential) is, zal dit trefwoord de
waarde hebben van het veld \fBEssential\fP en dat is de waarde \fByes\fP.
.RE
.TP 
\fBFiles:\fP (verplicht)
.TQ
\fBChecksums\-Sha1:\fP (verplicht)
.TQ
\fBChecksums\-Sha256:\fP (verplicht)
.TQ
 \fIcontrolesom\fP \fIgrootte\fP \fIbestandsnaam\fP
Deze multiregel\-velden bevatten een lijst van bestanden met voor elk van hen
een controlesom en een grootte. Deze velden hebben een identieke syntaxis en
verschillen onderling enkel inzake het gebruikte algoritme voor de
controlesom: MD5 voor \fBFiles\fP, SHA\-1 voor \fBChecksums\-Sha1\fP en SHA\-256 voor
\fBChecksums\-Sha256\fP.

De eerste regel van de veldwaarde (het deel dat op dezelfde regel staat als
de door een dubbele punt gevolgde veldnaam) is steeds leeg. De inhoud van
het veld wordt in de vervolgregels verwoord, één regel per bestand. Elke
regel bestaat uit de controlesom, een spatie, de bestandsgrootte, een spatie
en de bestandsnaam.

Deze velden sommen alle bestanden op die deel uitmaken van het
broncodepakket. De lijst bestanden in deze velden moet overeenkomen met de
lijst bestanden in de andere verwante velden.
.
.\" .SH EXAMPLE
.\" .RS
.\" .nf
.\" .fi
.\" .RE
.
.SH BUGS
Het veld \fBFormat\fP combineert de indeling van het \fB.dsc\fP\-bestand zelf en de
indeling van het uitgepakte broncodepakket.
.SH "ZIE OOK"
\fBdeb\-src\-control\fP(5), \fBdeb\-version\fP(7), \fBdpkg\-source\fP(1).
