.\" dpkg manual page - dpkg-architecture(1)
.\"
.\" Copyright © 2005 Marcus Brinkmann <brinkmd@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2009-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-architecture 1 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
dpkg\-architecture \- de architectuur voor het bouwen van pakketten instellen
en vaststellen
.
.SH OVERZICHT
\fBdpkg\-architecture\fP [\fIoptie\fP...] [\fIcommando\fP]
.PP
.
.SH BESCHRIJVING
\fBdpkg\-architecture\fP biedt een mogelijkheid om de bouw\- en host\-architectuur
voor het bouwen van pakketten vast te stellen en in te stellen.
.PP
De bouwarchitectuur wordt steeds bepaald door een externe aanroep van
\fBdpkg\fP(1) en kan niet ingesteld worden aan de commandoregel.
.PP
U kunt de host\-architectuur specificeren door een van of allebei de opties
\fB\-\-host\-arch\fP en \fB\-\-host\-type\fP op te geven. Wat de standaard is, wordt
vastgesteld door een externe aanroep van \fBgcc\fP(1) of, als zowel \fBCC\fP als
gcc onbeschikbaar zijn, gelijkgesteld aan de bouwarchitectuur. Een van
beide, \fB\-\-host\-arch\fP of \fB\-\-host\-type\fP, volstaat. De andere waarde zal op
een gebruikelijke standaardwaarde ingesteld worden. Het is inderdaad
dikwijls beter om slechts één waarde op te geven, vermits
\fBdpkg\-architecture\fP een waarschuwing zal geven als de keuze die u maakt
niet met de standaardwaarde overeenkomt.
.
.SH COMMANDO'S
.TP 
\fB\-l\fP, \fB\-\-list\fP
Geef de omgevingsvariabelen, per regel één, weer volgens de indeling
\fIVARIABELE=waarde\fP. Dit is de standaardactie.
.TP 
\fB\-e\fP, \fB\-\-equal\fP \fIarchitectuur\fP
Ga na of de architecturen gelijk zijn (sinds dpkg 1.13.13). Het vergelijkt
de huidige of opgegeven Debian host\-architectuur met \fIarchitectuur\fP om na
te gaan of ze gelijk zijn. Deze actie zal geen architectuurjokertekens
verwerken. Het commando sluit af met een afsluitstatus 0 bij gelijkheid en 1
bij ongelijkheid.

.TP 
\fB\-i\fP, \fB\-\-is\fP \fIarchitectuurjokerteken\fP
Ga na of de architecturen gelijk zijn (sinds dpkg 1.13.13). Het vergelijkt
de huidige of opgegeven Debian host\-architectuur met
\fIarchitectuurjokerteken\fP, nadat dit als een architectuurjokerteken verwerkt
werd, om na te gaan of beide gelijk zijn. Het commando sluit af met een
afsluitstatus 0 bij gelijkheid en 1 bij ongelijkheid.
.TP 
\fB\-q\fP, \fB\-\-query\fP \fIvariabelenaam\fP
Toon de waarde van één enkele variabele.
.TP 
\fB\-s\fP, \fB\-\-print\-set\fP
Toon een export\-commando. Dit kan gebruikt worden om de omgevingsvariabelen
met behulp van eval in te stellen.
.TP 
\fB\-u\fP, \fB\-\-print\-unset\fP
Toon een commando dat vergelijkbaar is met \fB\-\-print\-unset\fP, maar om alle
variabelen leeg te maken.
.TP 
\fB\-c\fP, \fB\-\-command\fP \fIcommando\-tekenreeks\fP
Voer een \fIcommando\-tekenreeks\fP uit in een omgeving waarin alle variabelen
ingesteld zijn op de vastgelegde waarde.
.TP 
\fB\-L\fP, \fB\-\-list\-known\fP
Toon een lijst van geldige architectuurbenamingen. Kan eventueel ingeperkt
worden met een of meer van de vergelijkingsopties \fB\-\-match\-wildcard\fP,
\fB\-\-match\-bits\fP of \fB\-\-match\-endian\fP (sinds dpkg 1.17.14).
.TP 
\fB\-?\fP, \fB\-\-help\fP
Toon info over het gebruik en sluit af.
.TP 
\fB\-\-version\fP
Toon de versie en sluit af.
.
.SH OPTIES
.TP 
\fB\-a\fP, \fB\-\-host\-arch\fP \fIarchitectuur\fP
Stel de Debian\-architectuur in voor de host.
.TP 
\fB\-t\fP, \fB\-\-host\-type\fP \fIgnu\-systeemtype\fP
Stel het GNU\-systeemtype in voor de host.
.TP 
\fB\-A\fP, \fB\-\-target\-arch\fP \fIarchitectuur\fP
Stel de Debian\-architectuur in voor het doel (sinds dpkg 1.17.14).
.TP 
\fB\-T\fP, \fB\-\-target\-type\fP \fIgnu\-systeemtype\fP
Stel het GNU\-systeemtype in voor het doel (sinds dpkg 1.17.14).
.TP 
\fB\-W\fP, \fB\-\-match\-wildcard\fP \fIarchitectuurjokerteken\fP
Beperk de architecturen die door \fB\-\-list\-known\fP weergegeven worden tot die
welke beantwoorden aan het opgegeven architectuurjokerteken (sinds dpkg
1.17.14).
.TP 
\fB\-B\fP, \fB\-\-match\-bits\fP \fIarchitectuur\-bits\fP
Beperk de architecturen die door \fB\-\-list\-known\fP weergegeven worden tot die
met de opgegeven CPU\-bits (sinds dpkg 1.17.14). Ofwel \fB32\fP ofwel \fB64\fP.
.TP 
\fB\-E\fP, \fB\-\-match\-endian\fP \fIarchitectuur\-bytevolgorde\fP
Beperk de architecturen die door \fB\-\-list\-known\fP weergegeven worden tot die
met de opgegeven bytevolgorde (endianness) (sinds dpkg 1.17.14). Ofwel
\fBlittle\fP ofwel \fBbig\fP.
.TP 
\fB\-f\fP, \fB\-\-force\fP
Waarden die door bestaande omgevingsvariabelen ingesteld zijn en die
dezelfde naam hebben als die welke door de scripts gebruikt worden, worden
gehonoreerd (d.w.z. gebruikt door \fBdpkg\-architecture\fP), behalve wanneer
deze forceer\-vlag gebruikt wordt. Dit laat de gebruiker toe om een waarde te
vervangen, zelfs als het aanroepen van \fBdpkg\-architecture\fP ingebed zit in
een ander script (bijvoorbeeld \fBdpkg\-buildpackage\fP(1)).
.
.SH TERMINOLOGIE
.IP bouwmachine 4
De machine waarop het pakket gebouwd wordt.
.IP hostmachine 4
De machine waarvoor het pakket gebouwd wordt.
.IP doelmachine 4
De machine waarvoor de compiler bouwt. Dit is enkel nodig bij het bouwen van
een kruisgereedschapskist (cross\-toolchain), een gereedschapskist die
gebouwd zal worden op de bouwarchitectuur om uitgevoerd te worden op de
hostarchitectuur en code moet bouwen voor de doelarchitectuur.
.IP Debian\-architectuur 4
De tekenreeks waarmee de Debian\-architectuur aangeduid wordt en die ook de
boomstructuur met de binaire pakketten in het FTP\-archief
specificeert. Voorbeelden: i386, sparc, hurd\-i386.
.IP Debian\-architectuurtupel 4
Een Debian\-architectuurtupel is de volledige unieke architectuurnaam met de
expliciete  vermelding van alle componenten. Dit verschilt minstens daarin
van een Debian architectuur dat de component \fIcpu\fP niet de \fIabi\fP
impliceert. Het huidige tupel heeft als vorm
\fIabi\fP\-\fIlibc\fP\-\fIos\fP\-\fIcpu\fP. Voorbeelden: base\-gnu\-linux\-amd64,
eabihf\-musl\-linux\-arm.
.IP Debian\-architectuurjokerteken 4
Een Debian\-architectuurjokerteken is een speciale architectuurtekenreeks die
een overeenkomst oplevert met elke echte architectuur die er onder hoort. De
algemene vorm is een Debian\-architectuurtupel met vier of minder elementen
en waarvan er minstens een \fBany\fP is. Ontbrekende elementen van de tupel
worden impliciet als \fBany\fP voorgevoegd, en dus zijn de volgende koppels
equivalent:
.nf
    \fBany\fP\-\fBany\fP\-\fBany\fP\-\fBany\fP = \fBany\fP
    \fBany\fP\-\fBany\fP\-\fIos\fP\-\fBany\fP = \fIos\fP\-\fBany\fP
    \fBany\fP\-\fIlibc\fP\-\fBany\fP\-\fBany\fP = \fIlibc\fP\-\fBany\fP\-\fBany\fP
.fi
Voorbeelden: linux\-any, any\-i386, hurd\-any, eabi\-any\-any\-arm, musl\-any\-any.
.IP GNU\-systeemtype 4
Een tekenreeks die een architectuurspecificatie inhoudt en bestaat uit twee
delen met daartussen een koppelteken: cpu en systeem. Voorbeelden:
i586\-linux\-gnu, sparc\-linux\-gnu, i686\-gnu, x86_64\-netbsd.
.IP multiarch\-triplet 4
Het uitgezuiverde GNU\-systeemtype dat voor bestandssysteempaden gebruikt
wordt. Dit triplet verandert zelfs niet wanneer het referentie\-ISA verhoogd
wordt, waardoor de resulterende paden stabiel blijven door de tijd. Het
enige verschil met het GNU\-systeemtype is momenteel dat voor op i386
gebaseerde systemen het CPU\-gedeelte steeds i386 is. Voorbeelden:
i386\-linux\-gnu, x86_64\-linux\-gnu. Voorbeelden van paden:
/lib/powerpc64le\-linux\-gnu/, /usr/lib/i386\-kfreebsd\-gnu/.
.
.SH VARIABELEN
The following variables are set by \fBdpkg\-architecture\fP (see the \fBTERMS\fP
section for a description of the naming scheme):
.IP \fBDEB_BUILD_ARCH\fP 4
De Debian architectuur van de bouwmachine.
.IP \fBDEB_BUILD_ARCH_ABI\fP 4
De Debian abi\-naam van de bouwmachine (sinds dpkg 1.18.11).
.IP \fBDEB_BUILD_ARCH_LIBC\fP 4
De Debian libc\-naam van de bouwmachine (sinds dpkg 1.18.11).
.IP \fBDEB_BUILD_ARCH_OS\fP 4
De Debian systeemnaam van de bouwmachine (sinds dpkg 1.13.2).
.IP \fBDEB_BUILD_ARCH_CPU\fP 4
De Debian CPU\-naam van de bouwmachine (sinds dpkg 1.13.2).
.IP \fBDEB_BUILD_ARCH_BITS\fP 4
De pointergrootte van de bouwmachine (in bits; sinds dpkg 1.15.4).
.IP \fBDEB_BUILD_ARCH_ENDIAN\fP 4
De bytevolgorde (endianness) van de bouwmachine (little / big; sinds dpkg
1.15.4).
.IP \fBDEB_BUILD_GNU_CPU\fP 4
Het CPU\-gedeelte van \fBDEB_BUILD_GNU_TYPE\fP.
.IP \fBDEB_BUILD_GNU_SYSTEM\fP 4
Het systeemgedeelte van \fBDEB_BUILD_GNU_TYPE\fP.
.IP \fBDEB_BUILD_GNU_TYPE\fP 4
Het GNU\-systeemtype van de bouwmachine.
.IP \fBDEB_BUILD_MULTIARCH\fP 4
Het uitgezuiverde GNU\-systeemtype van de bouwmachine, dat gebruikt wordt
voor bestandssysteempaden (sinds dpkg 1.16.0).
.IP \fBDEB_HOST_ARCH\fP 4
De Debian architectuur van de hostmachine.
.IP \fBDEB_HOST_ARCH_ABI\fP 4
De Debian abi\-naam van de hostmachine (sinds dpkg 1.18.11).
.IP \fBDEB_HOST_ARCH_LIBC\fP 4
De Debian libc\-naam van de hostmachine (sinds dpkg 1.18.11).
.IP \fBDEB_HOST_ARCH_OS\fP 4
De Debian systeemnaam van de hostmachine (sinds dpkg 1.13.2).
.IP \fBDEB_HOST_ARCH_CPU\fP 4
De Debian CPU\-naam van de hostmachine (sinds dpkg 1.13.2).
.IP \fBDEB_HOST_ARCH_BITS\fP 4
De pointergrootte van de hostmachine (in bits; sinds dpkg 1.15.4).
.IP \fBDEB_HOST_ARCH_ENDIAN\fP 4
De bytevolgorde (endianness) van de hostmachine (little / big; sinds dpkg
1.15.4).
.IP \fBDEB_HOST_GNU_CPU\fP 4
Het CPU\-gedeelte van \fBDEB_HOST_GNU_TYPE\fP.
.IP \fBDEB_HOST_GNU_SYSTEM\fP 4
The systeemgedeelte van \fBDEB_HOST_GNU_TYPE\fP.
.IP \fBDEB_HOST_GNU_TYPE\fP 4
Het GNU\-systeemtype van de hostmachine.
.IP \fBDEB_HOST_MULTIARCH\fP 4
Het uitgezuiverde GNU\-systeemtype van de hostmachine, dat gebruikt wordt
voor bestandssysteem\-paden (sinds dpkg 1.16.0).
.IP \fBDEB_TARGET_ARCH\fP 4
De Debian architectuur van de doelmachine (sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_ABI\fP 4
De Debian abi\-naam van de doelmachine (sinds dpkg 1.18.11).
.IP \fBDEB_TARGET_ARCH_LIBC\fP 4
De Debian libc\-naam van de doelmachine (sinds dpkg 1.18.11).
.IP \fBDEB_TARGET_ARCH_OS\fP 4
De Debian systeemnaam van de doelmachine (sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_CPU\fP 4
De Debian CPU\-naam van de doelmachine (sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_BITS\fP 4
De pointergrootte van de doelmachine (in bits; sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_ARCH_ENDIAN\fP 4
De bytevolgorde (endianness) van de doelmachine (little / big; sinds dpkg
1.17.14).
.IP \fBDEB_TARGET_GNU_CPU\fP 4
Het CPU\-gedeelte van \fBDEB_TARGET_GNU_TYPE\fP (sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_SYSTEM\fP 4
Het systeemgedeelte van \fBDEB_TARGET_GNU_TYPE\fP (sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_GNU_TYPE\fP 4
Het GNU\-systeemtype van de doelmachine (sinds dpkg 1.17.14).
.IP \fBDEB_TARGET_MULTIARCH\fP 4
Het uitgezuiverde GNU\-systeemtype van de doelmachine, dat gebruikt wordt
voor bestandssysteempaden (sinds dpkg 1.17.14).
.
.SH BESTANDEN
.SS Architectuurtabellen
Al deze bestanden moeten aanwezig zijn, wil \fBdpkg\-architecture\fP kunnen
werken. Hun locatie kan veranderd worden bij de programmauitvoering met de
omgevingsvariabele \fBDPKG_DATADIR\fP. Deze tabellen bevatten op hun eerste
regel een pseudo\-veld format \fBVersion\fP om hun indeling aan te geven, zodat
ontleders kunnen nagaan of zij ermee kunnen omgaan, zoals "# Version=1.0".
.TP 
\fI%PKGDATADIR%/cputable\fP
Tabel met gekende CPU\-namen en hun omzetting naar een GNU\-naam. Indeling
versie 1.0 (sinds dpkg 1.13.2).
.TP 
\fI%PKGDATADIR%/ostable\fP
Tabel van gekende namen van besturingssystemen en hun omzetting naar een
GNU\-naam. Indeling versie 2.0 (sinds dpkg 1.18.11).
.TP 
\fI%PKGDATADIR%/tupletable\fP
Omzetting tussen Debian architectuurtupels en Debian
architectuurnamen. Indeling versie 1.0 (sinds dpkg 1.18.11).
.TP 
\fI%PKGDATADIR%/abitable\fP
Tabel van Debian architectuur\-ABI\-attribuutvervangingen. Indeling versie 2.0
(sinds dpkg 1.18.11).
.SS "Ondersteuning bij het maken van een pakket"
.TP 
\fI%PKGDATADIR%/architecture.mk\fP
Makefile\-fragment dat alle variabelen die \fBdpkg\-architecture\fP uitvoert,
behoorlijk instelt en exporteert (sinds dpkg 1.16.1).
.
.SH VOORBEELDEN
\fBdpkg\-buildpackage\fP kan gebruikt worden met de optie \fB\-a\fP en geeft die
door aan \fBdpkg\-architecture\fP. Andere voorbeelden:
.IP
CC=i386\-gnu\-gcc dpkg\-architecture \-c debian/rules build
.IP
eval \`dpkg\-architecture \-u\`
.PP
Verifieer of de huidige of opgegeven hostarchitectuur gelijk is aan een
architectuur:
.IP
dpkg\-architecture \-elinux\-alpha
.IP
dpkg\-architecture \-amips \-elinux\-mips
.PP
Verifieer of de huidige of opgegeven hostarchitectuur een Linux\-systeem is:
.IP
dpkg\-architecture \-ilinux\-any
.IP
dpkg\-architecture \-ai386 \-ilinux\-any
.
.SS "Het gebruik in debian/rules"
De omgevingsvariabelen die door \fBdpkg\-architecture\fP ingesteld worden,
worden doorgegeven aan \fIdebian/rules\fP als variabelen voor make (zie de
documentatie van make). U mag er echter niet op vertrouwen, aangezien dit
het handmatig uitvoeren van het script verhindert. In de plaats daarvan zou
u ze altijd moeten initialiseren met door \fBdpkg\-architecture\fP met de optie
\fB\-q\fP te gebruiken. Hier volgen enkele voorbeelden die ook illustreren hoe u
in uw pakket ondersteuning voor cross\-compilatie kunt verbeteren:
.PP
Het opvragen van het GNU\-systeemtype en dit doorgeven aan ./configure:
.PP
.RS 4
.nf
DEB_BUILD_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_HOST_GNU_TYPE)
[...]
ifeq ($(DEB_BUILD_GNU_TYPE), $(DEB_HOST_GNU_TYPE))
  confflags += \-\-build=$(DEB_HOST_GNU_TYPE)
else
  confflags += \-\-build=$(DEB_BUILD_GNU_TYPE) \e
               \-\-host=$(DEB_HOST_GNU_TYPE)
endif
[...]
\&./configure $(confflags)
.fi
.RE
.PP
Iets enkel voor een specifieke architectuur doen:
.PP
.RS 4
.nf
DEB_HOST_ARCH ?= $(shell dpkg\-architecture \-qDEB_HOST_ARCH)

ifeq ($(DEB_HOST_ARCH),alpha)
  [...]
endif
.fi
.RE
.PP
of indien u enkel dient te controleren wat het type CPU of OS is, moet u de
variabele \fBDEB_HOST_ARCH_CPU\fP of \fBDEB_HOST_ARCH_OS\fP gebruiken.
.PP
Merk op dat u ook kunt betrouwen op een extern Makefile\-fragment om al de
variabelen behoorlijk in te stellen die door \fBdpkg\-architecture\fP kunnen
aangeleverd worden:
.PP
.RS 4
.nf
include %PKGDATADIR%/architecture.mk

ifeq ($(DEB_HOST_ARCH),alpha)
  [...]
endif
.fi
.RE
.PP
In ieder geval moet u nooit \fBdpkg \-\-print\-architecture\fP gebruiken om
architectuurinformatie te bekomen tijdens het bouwen van een pakket.
.
.SH OMGEVING
.TP 
\fBDPKG_DATADIR\fP
Indien deze variabele een waarde heeft, zal ze gebruikt worden als de
data\-map van \fBdpkg\fP waarin zich de architectuurtabellen bevinden (sinds
dpkg 1.14.17). Staat standaard ingesteld op «%PKGDATADIR%».
.TP 
\fBDPKG_COLORS\fP
Stelt de kleurmodus in (sinds dpkg 1.18.5). Waarden die momenteel gebruikt
mogen worden zijn: \fBauto\fP (standaard), \fBalways\fP en \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Indien dit ingesteld is, zal het gebruikt worden om te beslissen over het
activeren van moedertaalondersteuning, ook gekend als
internationaliseringsondersteuning (of i18n) (sinds dpkg 1.19.0). Geldige
waarden zijn: \fB0\fP and \fB1\fP (standaard).
.
.SH OPMERKINGEN
Alle lange commando\- en optienamen kunnen slechts sinds dpkg 1.17.17
gebruikt worden.
.
.SH "ZIE OOK"
\fBdpkg\-buildpackage\fP(1).
