.\" dpkg manual page - dpkg-gencontrol(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006, 2012-2013, 2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gencontrol 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-gencontrol \- Créer des fichiers de contrôle Debian.
.
.SH SYNOPSIS
\fBdpkg\-gencontrol\fP [\fIoption\fP...]
.
.SH DESCRIPTION
\fBdpkg\-gencontrol\fP lit les informations contenues dans une arborescence
Debian dépaquetée et crée le fichier «\ control\ » d'un paquet binaire (par
défaut, c'est le fichier debian/tmp/DEBIAN/control)\ ; durant cette action il
y a simplification des champs de relations.
.sp
\fBPre\-Depends\fP, \fBDepends\fP, \fBRecommends\fP et \fBSuggests\fP sont simplifiés
dans cet ordre pour supprimer les dépendances qui sont connues pour être
vérifiées par la plus forte dépendance déjà traitée. Sont aussi supprimées
toutes les auto\-dépendances (dans les faits, cela supprime les dépendances
qui sont déjà validées par la version du paquet déjà installé). Logiquement,
il conserve les correspondances entre plusieurs dépendances dans le même
paquet. L'ordre des dépendances est conservé du mieux possible\ : si une
dépendance doit être supprimée à cause d'une autre dépendance qui se trouve
dans un champ suivant, la dépendance remplaçante prendra la place de celle
éliminée.
.sp
Les autres champs (\fBEnhances\fP, \fBConflicts\fP, \fBBreaks\fP, \fBReplaces\fP et
\fBProvides\fP) sont également simplifiés individuellement par l'analyse des
différentes dépendances lorsque un paquet est indiqué plusieurs fois dans le
champ.
.sp
\fBdpkg\-gencontrol\fP ajoute aussi une entrée pour un paquet binaire dans
\fBdebian/files\fP.
.
.SH OPTIONS
.TP 
\fB\-v\fP\fIversion\fP
Fixe le numéro de version du paquet binaire qui sera créé.
.TP 
\fB\-V\fP\fInom\fP\fB=\fP\fIvaleur\fP
Fixe la valeur d'une variable de substitution. Consultez \fBdeb\-substvars\fP(5)
pour une discussion sur la valeur de substitution.
.TP 
\fB\-T\fP\fIfichier/substvars\fP
Read substitution variables in \fIsubstvars\-file\fP; the default is
\fBdebian/substvars\fP.  This option can be used multiple times to read
substitution variables from multiple files (since dpkg 1.15.6).
.TP 
\fB\-D\fP\fIchamp\fP\fB=\fP\fIvaleur\fP
Remplace ou ajoute en sortie un champ dans le fichier de contrôle.
.TP 
\fB\-U\fP\fIchamp\fP
Supprime en sortie un champ dans le fichier de contrôle.
.TP 
\fB\-c\fP\fIfichier\-de\-contrôle\fP
Indique le principal fichier de contrôle des sources où trouver des
renseignements. Par défaut, c'est le fichier \fBdebian/control\fP.
.TP 
\fB\-l\fP\fIfichier\-des\-changements\fP
Indique le fichier des changements où trouver des renseignements. Par
défaut, c'est le fichier \fBdebian/changelog\fP.
.TP 
\fB\-f\fP\fIfichier/liste\-des\-fichiers\fP
Lit ou écrit la liste des fichiers qui doivent être envoyés vers l'archive
dans ce fichier plutôt que dans le fichier \fBdebian/files\fP.
.TP 
\fB\-F\fP\fIformat\-du\-fichiers\-des\-changements\fP
Indique le format du fichier des changements. Voir \fBdpkg\-parsechangelog\fP(1)
pour plus d'informations à propos des formats gérés.
.TP 
\fB\-p\fP\fIpaquet\fP
Cette option produit les informations concernant le paquet binaire
\fIpaquet\fP.Si le fichier de contrôle des sources liste un seul paquet
binaire, on peut omettre cette option\ ; sinon il est indispensable
d'indiquer le paquet pour lequel on veut produire les informations.
.TP 
\fB\-n\fP\fInom\-de\-fichier\fP
Le nom du paquet est \fInom\-de\-fichier\fP au lieu de l'habituel\ :
paquet_version_arch.deb.
.TP 
\fB\-is\fP, \fB\-ip\fP, \fB\-isp\fP
Ces options, conservées pour compatibilité avec les anciennes versions des
scripts de construction de dpkg, sont maintenant déconseillées. Elles
servaient à dire à \fBdpkg\-gencontrol\fP d'inclure les champs «\ Section\ » et
«\ Priority\ » dans le fichier «\ control\ ». C'est maintenant le comportement
par défaut. Si vous voulez l'ancien comportement, vous pouvez utiliser
l'option \fB\-U\fP pour supprimer ces champs du fichier «\ control\ ».
.TP 
\fB\-P\fP\fIrépertoire\-construction\-paquet\fP
Cette option indique à \fBdpkg\-source\fP que le répertoire de construction du
paquet est \fIrep\-de\-construction\-du\-paquet\fP au lieu de \fBdebian/tmp\fP. Cette
valeur sert à trouver la valeur par défaut de la variable de substitution
\fBInstalled\-Size\fP et celle du champ correspondant dans le fichier de
contrôle (on utilise la commande \fBdu\fP)\ ; elle donne aussi l'emplacement par
défaut pour le fichier de sortie.
.TP 
\fB\-O\fP[\fInom\-de\-fichier\fP]
Print the control file to standard output (or \fIfilename\fP if specified,
since dpkg 1.17.2), rather than to \fBdebian/tmp/DEBIAN/control\fP (or
\fIpackage\-build\-dir\fP\fB/DEBIAN/control\fP if \fB\-P\fP was used).
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Sets the color mode (since dpkg 1.18.5).  The currently accepted values are:
\fBauto\fP (default), \fBalways\fP and \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
If set, it will be used to decide whether to activate Native Language
Support, also known as internationalization (or i18n) support (since dpkg
1.19.0).  The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH FICHIERS
.TP 
\fBdebian/control\fP
Le principal fichier d'information sur les sources\ ; il donne des
renseignements qui ne dépendent pas d'une version concernant le paquet
source et les paquets binaires qui peuvent être créés.
.TP 
\fBdebian/files\fP
La liste des fichiers créés qui font partie de ceux qui seront envoyés sur
le serveur. \fBdpkg\-gencontrol\fP ajoute les noms présumés des fichiers des
paquets binaires à partir des fichiers «\ control\ » qu'il crée.
.SH "VOIR AUSSI"
.ad l
\fBdeb\-substvars\fP(5), \fBdeb\-src\-control\fP(5), \fBdeb\-changelog\fP(5),
\fBdeb\-control\fP(5).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
