.\" dpkg manual page - dpkg-query(1)
.\"
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-query 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dpkg\-query \- ein Werkzeug, um die dpkg\-Datenbank abzufragen
.
.SH ÜBERSICHT
\fBdpkg\-query\fP [\fIOption\fP …] \fIBefehl\fP
.
.SH BESCHREIBUNG
\fBdpkg\-query\fP ist ein Werkzeug, um Informationen über Pakete zu zeigen, die
in der \fBdpkg\fP\-Datenbank aufgeführt sind.
.
.SH BEFEHLE
.TP 
\fB\-l\fP, \fB\-\-list\fP [\fIPaketname\-Muster\fP …]
List all known packages matching one or more patterns, regardless of their
status, which includes any real or virtual package referenced in any
dependency relationship field (such as \fBBreaks\fP, \fBEnhances\fP, etc.).  If no
\fIpackage\-name\-pattern\fP is given, list all packages in \fI%ADMINDIR%/status\fP,
excluding the ones marked as not\-installed (i.e.  those which have been
previously purged).  Normal shell wildcard characters are allowed in
\fIpackage\-name\-pattern\fP.  Please note you will probably have to quote
\fIpackage\-name\-pattern\fP to prevent the shell from performing filename
expansion.  For example this will list all package names starting with
\*(lqlibc6\*(rq:

.nf
  \fBdpkg\-query \-l 'libc6*'\fP
.fi

Die ersten drei Spalten der Ausgabe zeigen die gewünschte Aktion, den
Paketstatus und Fehler, in dieser Reihenfolge.

Gewünschte Aktion:
.nf
  u = Unbekannt
  i = Installieren
  h = Halten
  r = Entfernen
  p = Vollständig Löschen
.fi

Paketstatus:
.nf
  n = Nicht installiert
  c = Config\-Datei
  H = Halb installiert
  U = Entpackt
  F = Fehlgeschl. Konfiguration
  W = Trigger erWartet
  t = Trigger anhängig
  i = Installiert
.fi

Fehler\-Schalter:
.nf
  <leer> = (kein)
  R = Neuinstallation notwendig
.fi

Ein Großbuchstabe als Status oder Fehler zeigt an, dass das Paket
wahrscheinlich schwere Fehler verursachen wird. Bitte lesen Sie \fBdpkg\fP(1)
über die oben genannten Zustände und Schalter.

Das Ausgabeformat dieser Option kann nicht konfiguriert werden, variiert
aber automatisch mit der Terminalbreite. Die Ausgabe ist für menschliche
Leser gedacht und nicht leicht maschinenlesbar. Lesen Sie über die Optionen
\fB\-W\fP (\fB\-\-show\fP) und \fB\-\-showformat\fP, um das Ausgabeformat zu
konfigurieren.
.TP 
\fB\-W\fP, \fB\-\-show\fP [\fIPaketname\-Muster\fP …]
Genau wie die \fB\-\-list\fP\-Option wird dies alle Pakete, die auf das angegebene
Muster passen, aufführen. Allerdings kann die Ausgabe mit der
\fB\-\-showformat\fP\-Option angepasst werden. Im Standardausgabeformat wird eine
Zeile pro passendem Paket ausgegeben, wobei in jeder Zeile Name (erweitert
mit der Architektur\-Spezifizierung für \fBMulti\-Arch\fP\-\fBsame\fP\-Pakete) und
installierte Version des Pakets getrennt durch einen Tabulator enthalten
sind.
.TP 
\fB\-s\fP, \fB\-\-status\fP [\fIPaketname\fP …]
Berichte Zustand des angegebenen Paketes. Dies zeigt nur den Eintrag in der
Datenbank der Zustände der installierten Pakete. Falls kein \fIPaketname\fP
festgelegt ist, werden alle Paketeinträge in der Statusdatenbank angezeigt
(seit dpkg 1.19.1). Wenn mehrere \fIPaketname\fP\-Einträge aufgeführt sind,
werden die angeforderten Statuseinträge durch Leerzeilen getrennt, wobei die
Reihenfolge identisch zu der in der Argumentenliste ist.
.TP 
\fB\-L\fP, \fB\-\-listfiles\fP \fIPaketname\fP …
Aufführen von Dateien, die durch \fIPaketname\fP installiert wurden. Wenn
mehrere \fIPaketname\fP aufgeführt sind, werden die angeforderten Dateilisten
durch Leerzeilen getrennt, wobei die Reihenfolge identisch zu der in der
Argumentenliste ist. Beachten Sie aber, dass Dateien, die durch
Paket\-spezifische Installationsskripte angelegt wurden, nicht aufgeführt
werden.
.TP 
\fB\-\-control\-list\fP \fIPaketname\fP
Aufführen von Steuerdateien, die auf Ihrem System von \fIPaketname\fP
installiert wurden (seit Dpkg 1.16.5). Diese können als Eingabeargumente für
\fB\-\-control\-show\fP verwandt werden.
.TP 
\fB\-\-control\-show\fP \fIPaketname\fP \fISteuerdatei\fP
Die \fISteuerdatei\fP, die auf Ihrem System von \fIPaketname\fP installiert wurde,
auf der Standardausgabe ausgeben (seit Dpkg 1.16.5).
.TP 
\fB\-c\fP, \fB\-\-control\-path\fP \fIPaketname\fP [\fISteuerdatei\fP]
Listet die Pfade für Steuerdateien auf, die von \fIPaketname\fP auf Ihrem
System installiert wurden (seit Dpkg 1.15.4). Falls \fISteuerdatei\fP angegeben
wurde, liste nur den Pfad für diese Steuerdatei auf, falls sie existiert.

\fBWarnung\fP: Dieser Befehl ist veraltet, da er direkten Zugriff auf die
interne Dpkg\-Datenbank gibt. Bitte wechseln Sie stattdessen zu
\fB\-\-control\-list\fP und \fB\-\-control\-show\fP für alle Fälle, in denen diese
Befehle die gleichen Ergebnisse geben. Solange es noch mindestens einen Fall
gibt, in dem dieser Befehl benötigt wird (d.h. wenn ein beschädigendes
Postrm\-Betreuerskript entfernt werden muss), und solange es keine gute
Lösung dafür gibt wird dieser Befehl nicht entfernt.
.TP 
\fB\-S\fP, \fB\-\-search\fP \fIDateiname\-Suchmuster\fP …
Suche nach Paketen, denen Paketen, die auf ein bestimmtes Muster passen,
gehören. Die normalen Jokerzeichen (»wildcards«) der Shell können in diesem
Muster verwandt werden, wobei der Stern (\fB*\fP) und das Fragezeichen (\fB?\fP)
auf einen Schrägstrich passen und der inverse Schrägstrich (\fB\e\fP) als
Maskierzeichen verwandt wird.

Falls das erste Zeichen im \fIDateiname\-Suchmuster\fP keines aus ‚\fB*[?/\fP’ ist,
dann wird es als Teilzeichenkette\-Suche betrachtet und implizit durch ‚\fB*\fP’
eingeschlossen (wie in \fB*\fP\fIDateiname\-Suchmuster\fP\fB*\fP). Falls die
nachfolgende Zeichenkette etwas aus ‚\fB*[?\e\fP’ enthält, dann wird dies wie
ein Glob\-Muster behandelt, andernfalls werden alle abschließenden ‚\fB/\fP’
oder ‚\fB/.\fP’ entfernt und ein »literal path lookup« durchgeführt.

Dieser Befehl wird weder die zusätzlichen Dateien, die durch
Betreuer\-Skripte angelegt wurden, noch Alternativen aufführen.
.TP 
\fB\-p\fP, \fB\-\-print\-avail\fP [\fIPaketname\fP …]
Zeige Details über Pakete an, wie diese in \fI%ADMINDIR%/available\fP
vorliegen. Falls kein \fIPaketname\fP festgelegt ist, werden alle in der
Datenbank \fIavailable\fP verfügbaren Paketeinträge angezeigt (seit Dpkg
1.19.1). Wenn mehrere \fIPaketname\fP aufgeführt sind, werden die angeforderten
\fIavailable\fP\-Einträge durch Leerzeilen getrennt, wobei die Reihenfolge
identisch zu der in der Argumentenliste ist.

Benutzer APT\-basierter Oberflächen sollten \fBapt\-cache show\fP \fIPaketname\fP
verwenden, da die Datei \fIavailable\fP nur bei der Benutzung von \fBdselect\fP
aktuell bleibt.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeige den Bedienungshinweis und beende.
.TP 
\fB\-\-version\fP
Gebe die Version aus und beende sich.
.
.SH OPTIONEN
.TP 
\fB\-\-admindir=\fP\fIVerz\fP
Ändert den Ablageort der \fBdpkg\fP\-Datenbank. Der Standardort ist
\fI%ADMINDIR%\fP.
.TP 
\fB\-\-load\-avail\fP
Auch die »available«\-Datei laden, wenn die Befehle \fB\-\-show\fP und \fB\-\-list\fP
verwandt werden, die jetzt standardmnäßig nur die Statusdatei laden (seit
Dpkg 1.16.2).
.TP 
\fB\-\-no\-pager\fP
Deaktiviert die Verwendung jeglichen Pagers bei der Anzeige von
Informationen (seit Dpkg 1.19.2).
.TP 
\fB\-f\fP, \fB\-\-showformat=\fP\fIFormat\fP
This option is used to specify the format of the output \fB\-\-show\fP will
produce (short option since dpkg 1.13.1).  The format is a string that will
be output for each package listed.

In der Formatzeichenkette leitet „\fB\e\fP“ Escape\-Sequenzen ein:

.nf
    \fB\en\fP  Zeilenumbruch
    \fB\er\fP  Wagenrücklauf
    \fB\et\fP  Tabulator
.fi

„\fB\e\fP“ vor einem anderen Zeichen unterdrückt jede spezielle Bedeutung des
folgenden Zeichens. Dies ist für „\fB\e\fP“ und „\fB$\fP“ nützlich.

Paketinformationen können einbezogen werden, indem Variablenreferenzen auf
Paketfelder eingefügt werden. Hierbei wird folgende Syntax verwendet:
„\fB${\fP\fIFeld\fP[\fB;\fP\fIBreite\fP]\fB}\fP“. Felder werden rechtsbündig ausgegeben,
falls die Breite nicht negativ ist und somit linksbündige Ausgabe
erfolgt. Die folgenden \fIFeld\fPer werden verstanden, sind aber nicht
notwendigerweise in der Status\-Datei verfügbar (nur interne Felder oder
Felder, die im Binärpaket abgespeichert sind, landen dort):

.nf
    \fBArchitecture\fP
    \fBBugs\fP
    \fBConffiles\fP (intern)
    \fBConfig\-Version\fP (intern)
    \fBConflicts\fP
    \fBBreaks\fP
    \fBDepends\fP
    \fBDescription\fP
    \fBEnhances\fP
    \fBEssential\fP
    \fBFilename\fP (intern, Oberflächen\-bezogen)
    \fBHomepage\fP
    \fBInstalled\-Size\fP
    \fBMD5sum\fP (intern, Oberflächen\-bezogen)
    \fBMSDOS\-Filename\fP (intern, Oberflächen\-bezogen)
    \fBMaintainer\fP
    \fBOrigin\fP
    \fBPackage\fP
    \fBPre\-Depends\fP
    \fBPriority\fP
    \fBProvides\fP
    \fBRecommends\fP
    \fBReplaces\fP
    \fBRevision\fP (veraltet)
    \fBSection\fP
    \fBSize\fP (intern, Oberflächen\-bezogen)
    \fBSource\fP
    \fBStatus\fP (intern)
    \fBSuggests\fP
    \fBTag\fP (normalerweise nicht im .deb sondern in Packages\-Dateien des Depots)
    \fBTriggers\-Awaited\fP (intern)
    \fBTriggers\-Pending\fP (intern)
    \fBVersion\fP
    \fBshow:Summary\fP (virtuell)
    \fBshow:Status\-Abbrev\fP (virtuell)
.fi

Die folgenden Felder sind virtuell, sie werden von \fBdpkg\-query\fP aus Werten
aus anderen Feldern erstellt (beachten Sie, dass diese keine gültigen Namen
für Felder in Steuerdateien benutzen):
.RS
.TP 
\fBbinary:Package\fP
Es enthält den Binärpaketnamen mit einer möglichen
Architektur\-Spezifizierung wie „libc6:amd64“ (seit Dpkg 1.16.2). Eine
Architektur\-Spezifizierung dient dazu, einen eindeutigen Paketnamen zu
erzeugen, falls beispielsweise das Paket ein Feld \fBMulti\-Arch\fP mit dem Wert
\fBsame\fP hat oder das Paket für eine fremde Architektur ist.
.TP 
\fBbinary:Synopsis\fP
Es enthält die Kurzbeschreibung des Pakets (seit Dpkg 1.19.1).
.TP 
\fBbinary:Summary\fP
Dies ist ein Alias für \fBbinary:Synopsis\fP (seit Dpkg 1.16.2).
.TP 
\fBdb:Status\-Abbrev\fP
Es enthält den abgekürzten Paketstatus (als drei Zeichen) wie „ii “ oder
„iHR“ (seit Dpkg 1.16.2). Lesen Sie die Beschreibung von \fB\-\-list\fP für
weitere Details.
.TP 
\fBdb:Status\-Want\fP
Es enthält den gewünschten Status des Pakets, Teil des Statusfeldes (seit
Dpkg 1.17.11).
.TP 
\fBdb:Status\-Status\fP
Es enthält das Paketstatuswort, Teil des Statusfeldes (seit Dpkg 1.17.11).
.TP 
\fBdb:Status\-Eflag\fP
Es enthält den Paketstatusfehlerschalter, Teil des Statusfeldes (seit Dpkg
1.17.11).
.TP 
\fBdb\-fsys:Files\fP
It contains the list of the package filesystem entries separated by newlines
(since dpkg 1.19.3).
.TP 
\fBdb\-fsys:Last\-Modified\fP
It contains the timestamp in seconds of the last time the package filesystem
entries were modified (since dpkg 1.19.3).
.TP 
\fBsource:Package\fP
Es enthält den Quellpaketnamen für dieses Binärpaket (seit Dpkg 1.16.2).
.TP 
\fBsource:Version\fP
Es enthält die Quellpaketversion für dieses Binärpaket (seit Dpkg 1.16.2).
.TP 
\fBsource:Upstream\-Version\fP
Es enthält die Quellpaketversion der Originalautoren für dieses Binärpaket
(seit Dpkg 1.18.16).
.RE
.IP
Die Standard\-Formatzeichenkette ist
„\fB${binary:Package}\et${Version}\en\fP“. Tatsächlich können auch alle anderen
Felder, die in der Statusdatei gefunden werden können
(d.h. benutzerdefinierte Felder), abgefragt werden. Sie werden so
dargestellt, wie sie gefunden werden, es erfolgt keine Umwandlung oder
Fehlerüberprüfung. Um den Namen des \fBdpkg\fP\-Betreuers und die installierte
Version zu erhalten, könnten Sie folgendes ausführen:

.nf
  \fBdpkg\-query \-W \-f='${binary:Package} ${Version}\et${Maintainer}\en' dpkg\fP
.fi
.
.SH RÜCKGABEWERT
.TP 
\fB0\fP
Die angeforderte Abfrage wurde erfolgreich ausgeführt.
.TP 
\fB1\fP
Die angeforderte Abfrage schlug entweder ganz oder teilweise fehl, da keine
Datei oder kein Paket gefunden wurde (außer für \fB\-\-control\-path\fP,
\fB\-\-control\-list\fP und \fB\-\-control\-show\fP, bei denen solche Fehler fatal
sind).
.TP 
\fB2\fP
Fataler oder nicht behebbarer Fehler aufgrund ungültiger
Befehlszeilenverwendung oder Interaktionen mit dem System, wie Zugriffe auf
die Datenbank, Speicherzuweisungen usw.
.
.SH UMGEBUNG
.SS "Externe Umgebung"
.TP 
\fBSHELL\fP
Setzt das auszuführende Programm, wenn ein Befehl über eine Shell ausgeführt
wird (seit Dpkg 1.19.2).
.TP 
\fBPAGER\fP
.TQ
\fBDPKG_PAGER\fP
Setzt den zu verwendenen Pager\-Befehl (seit Dpkg 1.19.1), der mit »\fB$SHELL
\-c\fP« ausgeführt wird. Falls \fBSHELL\fP nicht gesetzt ist, wird stattdessen
»\fBsh\fP« verwandt. \fBDPKG_PAGER\fP setzt die Umgebungsvariable \fBPAGER\fP außer
Kraft (seit Dpkg 1.19.2).
.TP 
\fBDPKG_ADMINDIR\fP
Falls gesetzt und die Option \fB\-\-admindir\fP nicht verwandt wurde, wird dies
als Datenverzeichnis von \fBdpkg\fP verwandt.
.TP 
\fBDPKG_COLORS\fP
Setzt den Farbmodus (seit Dpkg 1.18.5). Die derzeit unterstützten Werte
sind: \fBauto\fP (Vorgabe), \fBalways\fP und \fBnever\fP.
.SS "Interne Umgebung"
.TP 
\fBLESS\fP
Von \fBdpkg\-query\fP auf »\fB\-FRSXMQ\fP« definiert, falls es nicht bereits gesetzt
ist oder wenn ein Pager gestartet wird (seit Dpkg 1.19.2). Um das
Vorgabeverhalten zu verändern, kann diese Variable auf einen anderen Wert
einschließlich der leeren Zeichenkette voreingestellt werden oder die
Variablen \fBPAGER\fP oder \fBDPKG_PAGER\fP können gesetzt werden, um bestimmte
Optionen mit »\fB\-+\fP« zu deaktivieren, beispielsweise \fBDPKG_PAGER="less
\-+F"\fP.
.
.SH "SIEHE AUCH"
\fBdpkg\fP(1).

.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2018 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
