.\" dpkg manual page - dpkg-name(1)
.\"
.\" Copyright © 1995-1996 Erick Branderhorst
.\" Copyright © 2007-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-name 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOME
dpkg\-name \- rinomina i pacchetti Debian in nomi completi di pacchetto
.
.SH SINTASSI
\fBdpkg\-name\fP [\fIopzione\fP...] [\fB\-\-\fP] \fIfile\fP...
.
.SH DESCRIZIONE
.PP
Questa pagina di manuale documenta il programma \fBdpkg\-name\fP, che fornisce
un modo facile per rinominare i pacchetti \fBDebian\fP nei loro nomi di
pacchetto completi. Un nome di pacchetto completo ha la forma
\fIpacchetto\fP\fB_\fP\fIversione\fP\fB_\fP\fIarchitettura\fP\fB.\fP\fItipo\-pacchetto\fP, così
come specificato nel file control del pacchetto. La parte \fIversione\fP del
nome del file è formata dall'informazione sulla versione originale del
software seguita facoltativamente da un trattino e dalle informazioni sulla
revisione. La parte \fItipo\-pacchetto\fP viene presa dal campo «package\-type»
se esiste, altrimenti viene usato il valore predefinito \fBdeb\fP.
.
.SH OPZIONI
.TP 
\fB\-a\fP, \fB\-\-no\-architecture\fP
Il nome del file di destinazione non conterrà le informazioni
sull'architettura.
.TP 
\fB\-k\fP, \fB\-\-symlink\fP
Crea un collegamento simbolico, invece di spostare.
.TP 
\fB\-o\fP, \fB\-\-overwrite\fP
I file esistenti verranno sovrascritti se hanno lo stesso nome del file di
destinazione.
.TP 
\fB\-s\fP, \fB\-\-subdir\fP [\fIdir\fP]
Files will be moved into a subdirectory. If the directory given as argument
exists the files will be moved into that directory otherwise the name of the
target directory is extracted from the section field in the control part of
the package. The target directory will be
«unstable/binary\-\fIarchitecture\fP/\fIsection\fP».  If the section is not found
in the control, then \fBno\-section\fP is assumed, and in this case, as well as
for sections \fBnon\-free\fP and \fBcontrib\fP the target directory is
«\fIsection\fP/binary\-\fIarchitecture\fP».  The section field is not required so a
lot of packages will find their way to the \fBno\-section\fP area.  Use this
option with care, it's messy.
.TP 
\fB\-c\fP, \fB\-\-create\-dir\fP
Questa opzione può essere usata insieme all'opzione \fB\-s\fP. Se non viene
trovata una directory target, verrà creata automaticamente. \fBUsare questa
opzione con cautela.\fP
.TP 
\fB\-?\fP, \fB\-\-help\fP
Mostra il messaggio sull'uso ed esce.
.TP 
\fB\-v\fP, \fB\-\-version\fP
Mostra la versione ed esce.
.
.SH BUG
Alcuni pacchetti non seguono la struttura dei nomi
\fIpacchetto\fP\fB_\fP\fIversione\fP\fB_\fP\fIarchitettura\fP\fB.deb\fP. I pacchetti
rinominati con \fBdpkg\-name\fP seguiranno questa struttura. Generalmente ciò
non ha effetto su come i pacchetti vengono installati da \fBdselect\fP(1) o
\fBdpkg\fP(1), ma altri strumenti di installazione possono fare affidamento su
questa struttura dei nomi.
.
.SH ESEMPI
.TP 
\fBdpkg\-name pinco\-pallo.deb\fP
The file \fBbar\-foo.deb\fP will be renamed to bar\-foo_1.0\-2_i386.deb or
something similar (depending on whatever information is in the control part
of \fBbar\-foo.deb\fP).
.TP 
\fBfind /root/debian/ \-name '*.deb' | xargs \-n 1 dpkg\-name \-a\fP
All files with the extension \fBdeb\fP in the directory /root/debian and its
subdirectory's will be renamed by \fBdpkg\-name\fP if required into names with
no architecture information.
.TP 
\fBfind \-name '*.deb' | xargs \-n 1 dpkg\-name \-a \-o \-s \-c\fP
\fBNon usarlo.\fP Se lo si fa, il proprio archivio verrà completamente
stravolto perché molti pacchetti vengono forniti senza l'informazione sulla
sezione. \fBNon usarlo.\fP
.TP 
\fBdpkg\-deb \-\-build debian\-tmp && dpkg\-name \-o \-s .. debian\-tmp.deb\fP
Questo può essere usato quando si creano nuovi pacchetti.
.
.SH "VEDERE ANCHE"
\fBdeb\fP(5), \fBdeb\-control\fP(5), \fBdpkg\fP(1), \fBdpkg\-deb\fP(1), \fBfind\fP(1),
\fBxargs\fP(1).
