/* -*-C-*- ux2mac.c */
/*-->ux2mac*/
/**********************************************************************/
/****************************** ux2mac ********************************/
/**********************************************************************/

/***********************************************************************
Convert one or more files from UNIX to Apple Macintosh format (\n -> \r),
preserving time stamps.

Usage:
	ux2mac filelist

[08-Mar-2002] -- Add support for --?, --help, and --version.
[20-Sep-1997] -- Adapt for GNU automake and autoconf.
[04-Feb-1995] -- original version
***********************************************************************/

#include "headers.h"

RCSID("$Id: ux2mac.c,v 1.1 1996/10/27 16:41:25 beebe Exp beebe $")

#define TMPFILE "ux2mac.$$$"

int		main ARGS((int argc_, char *argv_[]));
static int	ux2mac ARGS((const char *file_, int dummy));

int
#if STDC
main(
int argc,
char  *argv[]
)
#else /* NOT STDC */
main(argc,argv)
int argc;
char  *argv[];
#endif /* STDC */
{
    exit(do_args(argv,argc,ux2mac) ? EXIT_FAILURE : EXIT_SUCCESS);
    return (0);
}

static int
#if STDC
ux2mac(
const char  *file,
int dummy
)
#else /* NOT STDC */
ux2mac(file, dummy)
const char  *file;
int dummy;
#endif /* STDC */
{
    FILE  *fpin;
    FILE  *fpout;
    int c;

    (void)fprintf(stderr,"%s",file);

    if ((fpin = fopen(file,RB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," - [FAILED]\n");
	return (1);
    }
    if ((fpout = fopen(TMPFILE,WB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",TMPFILE);
	return (1);
    }

    while ((c = getc(fpin)) != EOF)
    {
	if (c == '\n')
	    c = '\r';
	(void)putc(c,fpout);
    }

    return (finish_file(fpin,file,fpout,TMPFILE));
}
