/* -*-C-*- mac2dos.c */
/*-->mac2dos*/
/**********************************************************************/
/****************************** mac2dos ********************************/
/**********************************************************************/

/***********************************************************************
Convert one or more files from Macintosh to IBM PC DOS format (\r -> \r\n),
preserving time stamps.

Usage:
	mac2dos filelist

[20-Sep-1997] -- Adapt for GNU automake and autoconf.
[15-Aug-1994] -- original version
***********************************************************************/

#include "headers.h"

RCSID("$Id: mac2dos.c,v 1.3 1995/07/22 19:59:21 beebe Exp beebe $")

#define TMPFILE "mac2dos.$$$"

static int	mac2dos ARGS((const char *file_, int dummy_));
int		main ARGS((int argc_, char *argv_[]));

int
#if STDC
main(
int argc,
char  *argv[]
)
#else /* NOT STDC */
main(argc,argv)
int argc;
char  *argv[];
#endif /* STDC */
{
    exit(do_args(argv,argc,mac2dos) ? EXIT_FAILURE : EXIT_SUCCESS);
    return (0);
}

static int
#if STDC
mac2dos(
const char  *file,
int dummy
)
#else /* NOT STDC */
mac2dos(file,dummy)
const char  *file;
int dummy;
#endif /* STDC */
{
    FILE  *fpin;
    FILE  *fpout;
    int c;

    (void)fprintf(stderr,"%s",file);

    if ((fpin = fopen(file,RB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," - [FAILED]\n");
	return (1);
    }
    if ((fpout = fopen(TMPFILE,WB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",TMPFILE);
	return (1);
    }

    while ((c = getc(fpin)) != EOF)
    {
	(void)putc(c,fpout);
	if (c == '\r')
	    (void)putc('\n',fpout);
    }

    return (finish_file(fpin,file,fpout,TMPFILE));
}
