; master library - heap
;
; Description:
;	heap̃TCYύX
;
; Function/Procedures:
;	unsigned hmem_reallocbyte( unsigned oseg, unsigned bytesize ) ;
;	unsigned hmem_realloc( unsigned oseg, unsigned parasize ) ;
;
; Parameters:
;	oseg	  ]hmemubN
;	bytesize  V傫(oCgP)
;	parasize  V傫(pOtP)
;
; Returns:
;	VZOgʒu
;
; Binding Target:
;	Microsoft-C / Turbo-C / Turbo Pascal
;
; Running Target:
;	8086
;
; Requiring Resources:
;	CPU: 8086
;
; Notes:
;	
;
; Assembly Language Note:
;	AXȊÕWX^ۑ܂B
;
; Compiler/Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Author:
;	ˏF
;
; Revision History:
;	94/ 1/ 1 Initial: hmemreal.asm/master.lib 0.22
;	95/ 2/14 [M0.22k] mem_AllocIDΉ
;	95/ 3/19 [M0.22k] VTCY(mem_OutSeg-mem_EndMark)ȏȂ
;			hmem_allocɓnăG[ɂ悤ɂ
;	95/ 3/21 [M0.22k] BUGFIX e]ʂ܂ĂȂ

	.MODEL SMALL
	include func.inc
	.DATA
	EXTRN mem_TopSeg:WORD
	EXTRN mem_OutSeg:WORD
	EXTRN mem_TopHeap:WORD
	EXTRN mem_FirstHole:WORD
	EXTRN mem_EndMark:WORD
	EXTRN mem_AllocID:WORD		; mem.asm

	.CODE
	EXTRN HMEM_ALLOC:CALLMODEL
	EXTRN HMEM_FREE:CALLMODEL

MEMHEAD STRUC
using	dw	?
nextseg	dw	?
mem_id	dw	?
MEMHEAD	ENDS

	oseg = (RETSIZE+2)*2

func HMEM_REALLOCBYTE	; hmem_reallocbyte() {
	push	BX
	mov	BX,SP
	push	CX
	;
	bytesize = (RETSIZE+1)*2
	mov	CX,SS:[BX+oseg]
	mov	BX,SS:[BX+bytesize]
	add	BX,15
	rcr	BX,1
	shr	BX,1
	shr	BX,1
	shr	BX,1
	jmp	short hmem_reallocb
endfunc			; }

NEW_ALLOC proc CALLMODEL	; oseg=0̂Ƃ́AVKm
	push	BX
	call	HMEM_ALLOC
	pop	CX
	pop	BX
	ret	4
NEW_ALLOC endp

OLD_FREE proc CALLMODEL		; bytesize|parasize = 0̂Ƃ́AJ
	push	BX
	call	HMEM_FREE
	xor	AX,AX
	mov	mem_AllocID,AX
	pop	CX
	pop	BX
	ret	4
OLD_FREE endp

func HMEM_REALLOC	; hmem_realloc() {
	push	BX
	mov	BX,SP
	push	CX
	;
	parasize = (RETSIZE+1)*2

	mov	CX,SS:[BX+oseg]
	mov	BX,SS:[BX+parasize]
hmem_reallocb:
	mov	AX,mem_OutSeg
	sub	AX,mem_EndMark
	cmp	BX,AX
	jae	short NEW_ALLOC	; ł hmem_alloc ɃG[ɂ
	jcxz	short NEW_ALLOC
	test	BX,BX
	jz	short OLD_FREE

	dec	CX
	push	ES
	push	SI
	xor	SI,SI		; 0

	inc	BX

	; house keeping
	cmp	CX,mem_TopHeap	; Œq[vႢȂ zero return
	jb	short NO_GOOD
	cmp	CX,mem_OutSeg	; ōq[vAhX荂Ȃ zero return
	jae	short NO_GOOD
	mov	ES,CX
	cmp	ES:[SI].using,1	; usingtOugp(1)vłȂ zero ret
	jne	short NO_GOOD

	; Ė{
	mov	AX,ES:[SI].mem_id	; ID]ʂĂ
	mov	mem_AllocID,AX

	mov	AX,ES:[SI].nextseg ; AX=nextseg
	add	BX,CX		; BX= v傫ɂƂ̎ɂȂʒu
	jc	short OTHER_PLACE	; carryłȂΊgő̏ꏊ
	cmp	AX,BX
	jae	short SHRINK

	; 傫ȂƂ
	cmp	AX,mem_OutSeg
	jae	short OTHER_PLACE	; ŏIubNȂړ邵Ȃ
	mov	ES,AX
	cmp	ES:[SI].using,SI
	jne	short OTHER_PLACE	; ̃ubNgpȂ͂ړ

	; ɋԂ
	cmp	ES:[SI].nextseg,BX
	jb	short OTHER_PLACE	; ̋Ԃ𑫂ĂȂ?
	; ꍇ
	cmp	AX,mem_FirstHole
	jne	short CONNECT
	; FirstHoleԂ߂ɁAmۂ̂
	sub	AX,ES:[SI].nextseg
	not	AX			; (nextseg - freeseg) - 1
	push	AX
	call	HMEM_ALLOC
CONNECT:
	mov	AX,ES:[SI].nextseg
	mov	ES,CX
	mov	ES:[SI].nextseg,AX	; 
	cmp	AX,BX
SHRINK:
	je	short HOP_OK		; vOK
IF 0
	; in: ES=CX=݂seg
	inc	BX
	cmp	AX,BX
	je	short HOP_OK		; ړI̖+1=ݖȂA͂OK
	dec	BX
ENDIF

	; k߂
	mov	ES:[SI].nextseg,BX	; BX(z̎ʒu)
	mov	ES,BX
	mov	ES:[SI].nextseg,AX	; ̒n_̎ʒu
	mov	ES:[SI].using,1		; gp̃ubNɕf
	inc	BX			; (J邩mem_AllocID͕sv)
	push	BX
	call	HMEM_FREE
HOP_OK:	jmp	short OK

NO_GOOD:			; ŝƂ 0 Ԃ̂͂
	xor	AX,AX
	jmp	short RETURN

	; ɌԂȂAʂ̏ꏊɍĊmۂ
OTHER_PLACE:
	; CX=݂̃ubN̈ʒu
	; BX=CXɗvꂽV傫̈ʒu
	; AX=݂̎̈ʒu( ɗȂ BX > AX )
	cmp	CX,mem_TopHeap
	jne	short RE_ALLOC
	; 擪Ȃ΁AȂ傫Oɖ߂Ηǂ
	sub	BX,AX	; BX=Ȃ
	sub	CX,BX	; CX=̕߂ʒu
	jb	short RE_ALLOC1		; 95/3/22
	cmp	CX,mem_EndMark
	jb	short RE_ALLOC1		; ς葫Ȃꍇ
	mov	ES,CX
	mov	ES:[SI].nextseg,AX
	mov	ES:[SI].using,1
	push	mem_AllocID
	pop	ES:[SI].mem_id
	mov	mem_TopHeap,CX
	add	BX,CX
	sub	AX,BX
	; CX=Vʒu(Ǘ̈̈ʒu)
	; BX=Âʒu(V)
	; AX=Â傫(ĝƂ̏AɐV傫菬)
	jmp	short TRANS
	EVEN

	; ^Ɋg債悤ƂĂłȂƂ̏
	; E擪̃ubNȂOɊg傷B
	; EꂪłȂƂ́Aʂ̈ʒuɐVKmۂB
	; EǂɂAVʒuɈȑO̓e]ʂB

	
	; AX=݂̎̈ʒu
	; BX=Ȃ()
	; CX=̕߂ʒu
RE_ALLOC1:
	add	CX,BX
	add	BX,AX

	; CX=݂̃ubN̈ʒu
	; BX=CXɗvꂽV傫̈ʒu
	; AX=݂̎̈ʒu( ɗȂ BX > AX )

RE_ALLOC:
	sub	AX,CX		; AX=Â傫
	sub	BX,CX		; BX=V傫
	xchg	AX,BX		; AX=V傫, BX=Â傫
	xchg	BX,CX		; BX=Âʒu, CX=Â傫
	dec	AX
	push	AX
	call	HMEM_ALLOC
	jc	short NO_GOOD
	dec	AX
	xchg	AX,CX
	push	AX
	lea	AX,[BX+1]
	push	AX
	call	HMEM_FREE	; ɊJႤ
	pop	AX

	; ȑO̓e]ʂB
	; CX=Vʒu(Ǘ̈̈ʒu)
	; BX=Âʒu(V)
	; AX=Â傫(ĝƂ̏AɐV傫菬)
TRANS:	push	CX
	push	DI
	push	DS
	CLD
TRANSLOOP:				; 蔲̓](^^;
	inc	CX
	inc	BX
	mov	ES,CX
	mov	SI,0
	mov	DS,BX
	mov	DI,SI
	mov	CX,16/2
	rep	movsw
	mov	CX,ES
	dec	AX
	jnz	short TRANSLOOP
	pop	DS
	pop	DI
	pop	CX
OK:
	inc	CX
	mov	AX,CX
RETURN:
	mov	mem_AllocID,0
	pop	SI
	pop	ES
	pop	CX
	pop	BX
	ret	4
endfunc		; }

END
