/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSAttributeGroup;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSIdentityConstraint;
import org.apache.ws.jaxme.xs.XSKeyRef;
import org.apache.ws.jaxme.xs.XSNotation;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSObjectFactory;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.types.XSAnySimpleType;
import org.apache.ws.jaxme.xs.types.XSAnyType;
import org.apache.ws.jaxme.xs.types.XSAnyURI;
import org.apache.ws.jaxme.xs.types.XSBase64Binary;
import org.apache.ws.jaxme.xs.types.XSBoolean;
import org.apache.ws.jaxme.xs.types.XSByte;
import org.apache.ws.jaxme.xs.types.XSDate;
import org.apache.ws.jaxme.xs.types.XSDateTime;
import org.apache.ws.jaxme.xs.types.XSDecimal;
import org.apache.ws.jaxme.xs.types.XSDouble;
import org.apache.ws.jaxme.xs.types.XSDuration;
import org.apache.ws.jaxme.xs.types.XSEntities;
import org.apache.ws.jaxme.xs.types.XSEntity;
import org.apache.ws.jaxme.xs.types.XSFloat;
import org.apache.ws.jaxme.xs.types.XSGDay;
import org.apache.ws.jaxme.xs.types.XSGMonth;
import org.apache.ws.jaxme.xs.types.XSGMonthDay;
import org.apache.ws.jaxme.xs.types.XSGYear;
import org.apache.ws.jaxme.xs.types.XSGYearMonth;
import org.apache.ws.jaxme.xs.types.XSHexBinary;
import org.apache.ws.jaxme.xs.types.XSID;
import org.apache.ws.jaxme.xs.types.XSIDREF;
import org.apache.ws.jaxme.xs.types.XSIDREFs;
import org.apache.ws.jaxme.xs.types.XSInt;
import org.apache.ws.jaxme.xs.types.XSInteger;
import org.apache.ws.jaxme.xs.types.XSLanguage;
import org.apache.ws.jaxme.xs.types.XSLong;
import org.apache.ws.jaxme.xs.types.XSNCName;
import org.apache.ws.jaxme.xs.types.XSNMToken;
import org.apache.ws.jaxme.xs.types.XSNMTokens;
import org.apache.ws.jaxme.xs.types.XSName;
import org.apache.ws.jaxme.xs.types.XSNegativeInteger;
import org.apache.ws.jaxme.xs.types.XSNonNegativeInteger;
import org.apache.ws.jaxme.xs.types.XSNonPositiveInteger;
import org.apache.ws.jaxme.xs.types.XSNormalizedString;
import org.apache.ws.jaxme.xs.types.XSPositiveInteger;
import org.apache.ws.jaxme.xs.types.XSQName;
import org.apache.ws.jaxme.xs.types.XSShort;
import org.apache.ws.jaxme.xs.types.XSString;
import org.apache.ws.jaxme.xs.types.XSTime;
import org.apache.ws.jaxme.xs.types.XSToken;
import org.apache.ws.jaxme.xs.types.XSUnsignedByte;
import org.apache.ws.jaxme.xs.types.XSUnsignedInt;
import org.apache.ws.jaxme.xs.types.XSUnsignedLong;
import org.apache.ws.jaxme.xs.types.XSUnsignedShort;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSSchemaImpl
implements XSSchema {
    private static final XSType[] BUILTIN_TYPES = new XSType[]{XSAnySimpleType.getInstance(), XSAnyURI.getInstance(), XSBase64Binary.getInstance(), XSBoolean.getInstance(), XSByte.getInstance(), XSDate.getInstance(), XSDateTime.getInstance(), XSDecimal.getInstance(), XSDouble.getInstance(), XSDuration.getInstance(), XSEntities.getInstance(), XSEntity.getInstance(), XSFloat.getInstance(), XSGDay.getInstance(), XSGMonth.getInstance(), XSGMonthDay.getInstance(), XSGYear.getInstance(), XSGYearMonth.getInstance(), XSHexBinary.getInstance(), XSID.getInstance(), XSIDREF.getInstance(), XSIDREFs.getInstance(), XSInt.getInstance(), XSInteger.getInstance(), XSLanguage.getInstance(), XSLong.getInstance(), XSName.getInstance(), XSNCName.getInstance(), XSNegativeInteger.getInstance(), XSNMToken.getInstance(), XSNMTokens.getInstance(), XSNonNegativeInteger.getInstance(), XSNonPositiveInteger.getInstance(), XSNormalizedString.getInstance(), org.apache.ws.jaxme.xs.types.XSNotation.getInstance(), XSPositiveInteger.getInstance(), XSQName.getInstance(), XSShort.getInstance(), XSString.getInstance(), XSTime.getInstance(), XSToken.getInstance(), XSUnsignedByte.getInstance(), XSUnsignedInt.getInstance(), XSUnsignedLong.getInstance(), XSUnsignedShort.getInstance(), XSAnyType.getInstance()};
    private final XSContext context;
    private final XsESchema syntaxSchema;
    private final List childs = new ArrayList(1);
    private final Map types = new HashMap(1);
    private final Map builtinTypes = new HashMap(1);
    private final Map groups = new HashMap(1);
    private final Map attributeGroups = new HashMap(1);
    private final Map attributes = new HashMap(1);
    private final Map elements = new HashMap(1);
    private final Attributes openAttrs;
    private final Map identityConstraintsMap = new HashMap(1);
    private final Map keyRefsMap = new HashMap(1);
    private final Map immutableIdentityConstraintsMap = Collections.unmodifiableMap(this.identityConstraintsMap);
    private final Map immutableKeyRefsMap = Collections.unmodifiableMap(this.keyRefsMap);
    private boolean isValidated;

    public XSSchemaImpl(XSContext pContext, XsESchema pSchema) {
        this.context = pContext;
        this.syntaxSchema = pSchema;
        for (int i = 0; i < BUILTIN_TYPES.length; ++i) {
            this.builtinTypes.put(BUILTIN_TYPES[i].getName(), BUILTIN_TYPES[i]);
        }
        this.openAttrs = pSchema.getOpenAttributes();
    }

    public XSContext getContext() {
        return this.context;
    }

    public boolean isTopLevelObject() {
        return true;
    }

    public XSObject getParentObject() {
        return null;
    }

    public XSObjectFactory getXSObjectFactory() {
        return this.context.getXSObjectFactory();
    }

    public Locator getLocator() {
        return this.syntaxSchema.getLocator();
    }

    public XSSchema getXSSchema() {
        return this;
    }

    protected XsESchema getXsESchema() {
        return this.syntaxSchema;
    }

    protected void addChild(Object pChild) {
        this.childs.add(pChild);
    }

    protected void replace(Object pOldChild, Object pNewChild) {
        ListIterator<Object> iter = this.childs.listIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!o.equals(pOldChild)) continue;
            iter.set(pNewChild);
            return;
        }
        throw new NoSuchElementException();
    }

    public XSAnnotation[] getAnnotations() {
        ArrayList result = new ArrayList();
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSAnnotation)) continue;
            result.add(o);
        }
        return result.toArray(new XSAnnotation[result.size()]);
    }

    public XSType[] getTypes() {
        ArrayList result = new ArrayList();
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSType)) continue;
            result.add(o);
        }
        return result.toArray(new XSType[result.size()]);
    }

    public XSType[] getBuiltinTypes() {
        return BUILTIN_TYPES;
    }

    public XSType getType(XsQName pName) {
        XSType result = (XSType)this.types.get(pName);
        if (result == null) {
            result = (XSType)this.builtinTypes.get(pName);
        }
        return result;
    }

    public XSGroup[] getGroups() {
        ArrayList result = new ArrayList();
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSGroup)) continue;
            result.add(o);
        }
        return result.toArray(new XSGroup[result.size()]);
    }

    public XSGroup getGroup(XsQName pName) {
        return (XSGroup)this.groups.get(pName);
    }

    public XSAttributeGroup[] getAttributeGroups() {
        ArrayList result = new ArrayList();
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSAttributeGroup)) continue;
            result.add(o);
        }
        return result.toArray(new XSAttributeGroup[result.size()]);
    }

    public XSAttributeGroup getAttributeGroup(XsQName pName) {
        return (XSAttributeGroup)this.attributeGroups.get(pName);
    }

    public XSElement[] getElements() {
        ArrayList result = new ArrayList();
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSElement)) continue;
            result.add(o);
        }
        return result.toArray(new XSElement[result.size()]);
    }

    public XSElement getElement(XsQName pName) {
        return (XSElement)this.elements.get(pName);
    }

    public Map getIdentityConstraints() {
        return this.immutableIdentityConstraintsMap;
    }

    public Map getKeyRefs() {
        return this.immutableKeyRefsMap;
    }

    public void add(XSIdentityConstraint ic) throws SAXException {
        String name = ic.getName();
        if (name == null) {
            throw new LocSAXException("An identity constraint must have a 'name' attribute.", ic.getLocator());
        }
        if (this.identityConstraintsMap.put(name, ic) != null) {
            throw new LocSAXException("No two identity constraints may share the same name.", ic.getLocator());
        }
        this.identityConstraintsMap.put(name, ic);
    }

    public void add(XSKeyRef rf) throws SAXException {
        String name = rf.getName();
        if (name == null) {
            throw new LocSAXException("A key ref must have a 'name' attribute.", rf.getLocator());
        }
        if (this.keyRefsMap.put(name, rf) != null) {
            throw new LocSAXException("No two key refs may share the same name.", rf.getLocator());
        }
        this.keyRefsMap.put(name, rf);
    }

    public XSAttribute[] getAttributes() {
        ArrayList result = new ArrayList();
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSAttribute)) continue;
            result.add(o);
        }
        return result.toArray(new XSAttribute[result.size()]);
    }

    public XSAttribute getAttribute(XsQName pQName) {
        return (XSAttribute)this.attributes.get(pQName);
    }

    public void add(XSAnnotation pAnnotation) {
        this.addChild(pAnnotation);
    }

    public void add(XSType pType) throws SAXException {
        XsQName name = pType.getName();
        if (name == null) {
            throw new LocSAXException("A global type must have a 'name' attribute.", pType.getLocator());
        }
        if (this.types.containsKey(name)) {
            throw new LocSAXException("A global type " + name + " is already defined.", pType.getLocator());
        }
        this.types.put(name, pType);
        pType.setGlobal(true);
        this.addChild(pType);
    }

    public void redefine(XSType pType) throws SAXException {
        XsQName name = pType.getName();
        if (name == null) {
            throw new LocSAXException("A global type must have a 'name' attribute.", pType.getLocator());
        }
        Object oldType = this.types.get(name);
        if (oldType == null) {
            throw new LocSAXException("The global type " + name + " cannot be redefined, as it doesn't yet exist.", pType.getLocator());
        }
        this.types.put(name, pType);
        pType.setGlobal(true);
        this.replace(oldType, pType);
    }

    public void add(XSGroup pGroup) throws SAXException {
        XsQName name = pGroup.getName();
        if (name == null) {
            throw new LocSAXException("A global group must have a 'name' attribute.", pGroup.getLocator());
        }
        if (this.groups.containsKey(name)) {
            throw new LocSAXException("A global group " + name + " is already defined.", pGroup.getLocator());
        }
        this.groups.put(name, pGroup);
        this.addChild(pGroup);
        pGroup.setGlobal(true);
    }

    public void redefine(XSGroup pGroup) throws SAXException {
        XsQName name = pGroup.getName();
        if (name == null) {
            throw new LocSAXException("A global group must have a 'name' attribute.", pGroup.getLocator());
        }
        Object oldGroup = this.groups.get(name);
        if (oldGroup == null) {
            throw new LocSAXException("The global group " + name + " cannot be redefined, as it doesn't yet exist.", pGroup.getLocator());
        }
        this.groups.put(name, pGroup);
        this.replace(oldGroup, pGroup);
    }

    public void add(XSAttributeGroup pGroup) throws SAXException {
        XsQName name = pGroup.getName();
        if (name == null) {
            throw new LocSAXException("A global attribute group must have a 'name' attribute.", pGroup.getLocator());
        }
        if (this.attributeGroups.containsKey(name)) {
            throw new LocSAXException("A global attribute group " + name + " is already defined.", pGroup.getLocator());
        }
        this.attributeGroups.put(name, pGroup);
        this.addChild(pGroup);
    }

    public void redefine(XSAttributeGroup pGroup) throws SAXException {
        XsQName name = pGroup.getName();
        if (name == null) {
            throw new LocSAXException("A global attribute group must have a 'name' attribute.", pGroup.getLocator());
        }
        Object oldGroup = this.attributeGroups.get(name);
        if (!this.attributeGroups.containsKey(name)) {
            throw new LocSAXException("The global attribute group " + name + " cannot be redefined, as it doesn't yet exist.", pGroup.getLocator());
        }
        this.attributeGroups.put(name, pGroup);
        this.replace(oldGroup, pGroup);
    }

    public void add(XSAttribute pAttribute) throws SAXException {
        XsQName name = pAttribute.getName();
        if (name == null) {
            throw new LocSAXException("A global attribute must have a 'name' attribute.", pAttribute.getLocator());
        }
        if (this.attributes.containsKey(name)) {
            throw new LocSAXException("A global attribute " + name + " is already defined.", pAttribute.getLocator());
        }
        this.attributes.put(name, pAttribute);
        this.addChild(pAttribute);
    }

    public void add(XSElement pElement) throws SAXException {
        XsQName name = pElement.getName();
        if (name == null) {
            throw new LocSAXException("A global attribute group must have a 'name' attribute.", pElement.getLocator());
        }
        if (this.elements.containsKey(name)) {
            throw new LocSAXException("A global group " + name + " is already defined.", pElement.getLocator());
        }
        this.elements.put(name, pElement);
        this.addChild(pElement);
    }

    public void add(XSNotation pNotation) {
        this.addChild(pNotation);
    }

    public Object[] getChilds() {
        return this.childs.toArray();
    }

    protected void validate(Object pChild) throws SAXException {
        if (!(pChild instanceof XSObject)) {
            throw new IllegalStateException("Unable to validate the child " + pChild + ", perhaps you should overwrite the method " + this.getClass().getName() + ".validate(Object).");
        }
        ((XSObject)pChild).validate();
    }

    protected boolean isValidated() {
        return this.isValidated;
    }

    public void validate() throws SAXException {
        if (this.isValidated()) {
            return;
        }
        this.isValidated = true;
        Object[] myChilds = this.getChilds();
        for (int i = 0; i < myChilds.length; ++i) {
            this.validate(myChilds[i]);
        }
    }

    public Attributes getOpenAttributes() {
        return this.openAttrs;
    }
}

