/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import java.util.ArrayList;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSAttributeGroup;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSWildcard;
import org.apache.ws.jaxme.xs.impl.XSObjectImpl;
import org.apache.ws.jaxme.xs.impl.XSOpenAttrsImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsGAttrDecls;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTAttribute;
import org.apache.ws.jaxme.xs.xml.XsTAttributeGroup;
import org.apache.ws.jaxme.xs.xml.XsTAttributeGroupRef;
import org.apache.ws.jaxme.xs.xml.XsTWildcard;
import org.xml.sax.SAXException;

public class XSAttributeGroupImpl
extends XSOpenAttrsImpl
implements XSAttributeGroup {
    private final XsQName name;
    private boolean isValidated;
    private XSAttributable[] attributes;

    protected XsTAttributeGroup getXsTAttributeGroup() {
        return (XsTAttributeGroup)this.getXsObject();
    }

    protected boolean isReference() {
        return this.getXsTAttributeGroup().getRef() != null;
    }

    protected XSAttributeGroupImpl(XSObject pParent, XsTAttributeGroup pBaseGroup) throws SAXException {
        super(pParent, pBaseGroup);
        XsQName qName;
        if (this.isReference()) {
            qName = this.getXsTAttributeGroup().getRef();
        } else {
            XsNCName myName = pBaseGroup.getName();
            if (myName == null) {
                throw new LocSAXException("Invalid attribute group: Neither of its 'name' or 'ref' attributes are set.", pBaseGroup.getLocator());
            }
            XsESchema schema = pBaseGroup.getXsESchema();
            qName = new XsQName(schema.getTargetNamespace(), myName.toString(), schema.getTargetNamespacePrefix());
        }
        this.name = qName;
    }

    public XsQName getName() {
        return this.name;
    }

    public void validate() throws SAXException {
        if (this.isValidated) {
            return;
        }
        this.isValidated = true;
        if (this.isReference()) {
            XSAttributeGroup referencedGroup = this.getXSSchema().getAttributeGroup(this.getName());
            if (referencedGroup == null) {
                throw new LocSAXException("Invalid attribute group: Unknown attribute group " + this.name + " referenced", this.getLocator());
            }
            referencedGroup.validate();
            this.attributes = referencedGroup.getAttributes();
        } else {
            XsTAttributeGroup attributeGroup = (XsTAttributeGroup)this.getXsObject();
            this.attributes = XSAttributeGroupImpl.getAttributes(this, attributeGroup);
        }
    }

    public XSAttributable[] getAttributes() {
        return this.attributes;
    }

    protected static XSAttributable[] getAttributes(XSObjectImpl pObject, XsGAttrDecls pAttrDecls) throws SAXException {
        ArrayList<XSAttributable> attributes = new ArrayList<XSAttributable>();
        Object[] allAttributes = pAttrDecls.getAllAttributes();
        for (int i = 0; i < allAttributes.length; ++i) {
            Object o = allAttributes[i];
            if (o == null) {
                throw new NullPointerException("Null attribute detected.");
            }
            if (o instanceof XsTAttribute) {
                XSAttribute attribute = pObject.getXSSchema().getXSObjectFactory().newXSAttribute(pObject, (XsTAttribute)o);
                attribute.validate();
                attributes.add(attribute);
                continue;
            }
            if (o instanceof XsTAttributeGroupRef) {
                XsTAttributeGroupRef agRef = (XsTAttributeGroupRef)o;
                XsQName ref = agRef.getRef();
                if (ref == null) {
                    throw new LocSAXException("Invalid attribute group: Missing 'ref' attribute", pObject.getLocator());
                }
                XSAttributeGroup attributeGroup = pObject.getXSSchema().getAttributeGroup(ref);
                if (attributeGroup == null) {
                    throw new LocSAXException("Unknown attribute group name: " + ref, pObject.getLocator());
                }
                attributeGroup.validate();
                XSAttributable[] agAttributes = attributeGroup.getAttributes();
                for (int j = 0; j < agAttributes.length; ++j) {
                    attributes.add(agAttributes[j]);
                }
                continue;
            }
            if (o instanceof XsTAttributeGroup) {
                XsTAttributeGroup ag = (XsTAttributeGroup)o;
                XSAttributable[] agAttributes = XSAttributeGroupImpl.getAttributes(pObject, ag);
                for (int j = 0; j < agAttributes.length; ++j) {
                    attributes.add(agAttributes[j]);
                }
                continue;
            }
            if (o instanceof XsTWildcard) {
                XSWildcard wildcard = pObject.getXSSchema().getXSObjectFactory().newXSWildcard(pObject, (XsTWildcard)o);
                wildcard.validate();
                attributes.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unknown attribute type: " + o.getClass().getName());
        }
        return attributes.toArray(new XSAttributable[attributes.size()]);
    }
}

