/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.util.ClassLoader;
import org.apache.ws.jaxme.util.NamespaceResolver;
import org.apache.ws.jaxme.util.NamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Configurator
implements ContentHandler,
NamespaceResolver {
    private static final Class[] zeroClasses = new Class[0];
    private static final Object[] zeroObjects = new Object[0];
    private static final Class[] oneClassString = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Configurator.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] oneClassAttributes = new Class[]{class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = Configurator.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes};
    private String[] namespaces;
    private List beans = new ArrayList();
    private List names = new ArrayList();
    private Object currentBean;
    private String currentName;
    private Locator locator;
    private Object beanFactory;
    private Object rootObject;
    private Object resultBean;
    private int ignoreLevel = 0;
    private NamespaceSupport nss = new NamespaceSupport();
    boolean nssNeedsContext;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$Attributes;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;

    public void setNamespace(String pNamespace) {
        this.setNamespaces(new String[]{pNamespace});
    }

    public void setNamespaces(String[] pNamespaces) {
        this.namespaces = pNamespaces;
    }

    public String[] getNamespaces() {
        return this.namespaces;
    }

    public void setDocumentLocator(Locator pLocator) {
        this.locator = pLocator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setBeanFactory(Object pFactory) {
        this.beanFactory = pFactory;
    }

    public Object getBeanFactory() {
        return this.beanFactory == null ? this : this.beanFactory;
    }

    public void setRootObject(Object pRootObject) {
        this.rootObject = pRootObject;
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    public void startDocument() throws SAXException {
        this.currentBean = null;
        this.currentName = null;
        this.beans.clear();
        this.names.clear();
        this.ignoreLevel = 0;
        this.nss.reset();
        this.nssNeedsContext = true;
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        this.nss.declarePrefix(pPrefix, pURI);
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        this.nss.undeclarePrefix(pPrefix);
    }

    protected boolean isNamespaceMatching(String pNamespace) {
        String[] myNamespaces;
        if (pNamespace == null) {
            pNamespace = "";
        }
        if ((myNamespaces = this.getNamespaces()) == null || myNamespaces.length == 0) {
            return pNamespace.length() == 0;
        }
        for (int i = 0; i < myNamespaces.length; ++i) {
            String s = myNamespaces[i];
            if (s == null) {
                s = "";
            }
            if (!s.equals(pNamespace)) continue;
            return true;
        }
        return false;
    }

    protected String getMethodNameFor(String pPrefix, String pName) {
        StringBuffer result = new StringBuffer(pPrefix);
        for (int i = 0; i < pName.length(); ++i) {
            char c = pName.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    result.append(Character.toUpperCase(c));
                    continue;
                }
                result.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    public void startElement(String pNamespaceURI, String pQName, String pLocalName, Attributes pAttr) throws SAXException {
        Object o;
        if (this.ignoreLevel > 0) {
            ++this.ignoreLevel;
            return;
        }
        if (!this.isNamespaceMatching(pNamespaceURI)) {
            if (this.currentBean == null) {
                String[] myNamespaces = this.getNamespaces();
                if (myNamespaces == null || myNamespaces.length == 0) {
                    throw new SAXParseException("The document element must have the default namespace.", this.getDocumentLocator());
                }
                StringBuffer sb = new StringBuffer("The document element must have either of the namespaces: ");
                for (int i = 0; i < myNamespaces.length; ++i) {
                    String s;
                    if (i > 0) {
                        sb.append(",");
                    }
                    if ((s = myNamespaces[i]) == null) {
                        s = "";
                    }
                    sb.append('\"').append(s).append("'");
                }
                throw new SAXParseException(sb.toString(), this.getDocumentLocator());
            }
            ++this.ignoreLevel;
            return;
        }
        if (this.currentBean == null && this.rootObject != null) {
            o = this.rootObject;
        } else {
            String methodName;
            Object factory;
            block57: {
                o = null;
                factory = this.currentBean == null ? this.beanFactory : this.currentBean;
                methodName = this.getMethodNameFor("create", pLocalName);
                try {
                    o = this.invokeMethod(methodName, factory, oneClassAttributes, new Object[]{pAttr});
                }
                catch (SAXParseException e2) {
                    Object e2;
                    if (e2.getException() != null && e2.getException() instanceof NoSuchMethodException) {
                        try {
                            o = this.invokeMethod(methodName, factory, zeroClasses, zeroObjects);
                            e2 = null;
                        }
                        catch (SAXParseException f) {
                            if (f.getException() != null && f.getException() instanceof NoSuchMethodException) {
                                if (this.currentBean == null) {
                                    throw new SAXParseException("Invalid document element: " + pQName, this.getDocumentLocator());
                                }
                                throw new SAXParseException("Invalid child element name: " + pQName, this.getDocumentLocator());
                            }
                            throw f;
                        }
                    }
                    if (e2 == null) break block57;
                    throw e2;
                }
            }
            if (o == null) {
                throw new SAXParseException("Method " + methodName + " of class " + factory.getClass().getName() + " did not return an object.", this.getDocumentLocator());
            }
        }
        if (this.currentBean == null) {
            this.resultBean = o;
        } else {
            this.beans.add(this.currentBean);
            this.names.add(this.currentName);
        }
        this.currentBean = o;
        this.currentName = pQName;
        if (pAttr != null) {
            for (int i = 0; i < pAttr.getLength(); ++i) {
                String uri = pAttr.getURI(i);
                if (uri != null && uri.length() != 0 && !this.isNamespaceMatching(uri)) continue;
                String value = pAttr.getValue(i);
                String qName = pAttr.getQName(i);
                String setMethodName = this.getMethodNameFor("set", pAttr.getLocalName(i));
                Method[] methods = this.currentBean.getClass().getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    Class<?>[] argClasses;
                    Method method = methods[j];
                    if (!setMethodName.equals(method.getName()) || (argClasses = method.getParameterTypes()).length != 1) continue;
                    Object[] args = null;
                    if (argClasses[0] == (class$java$lang$String == null ? Configurator.class$("java.lang.String") : class$java$lang$String)) {
                        args = new Object[]{value};
                    } else {
                        if (argClasses[0] == (class$java$lang$Integer == null ? Configurator.class$("java.lang.Integer") : class$java$lang$Integer) || argClasses[0] == Integer.TYPE) {
                            try {
                                args = new Object[]{new Integer(value)};
                            }
                            catch (Exception e) {
                                throw new SAXParseException("Attribute " + qName + " contains an invalid Integer value: " + value, this.getDocumentLocator());
                            }
                        }
                        if (argClasses[0] == (class$java$lang$Long == null ? Configurator.class$("java.lang.Long") : class$java$lang$Long) || argClasses[0] == Long.TYPE) {
                            try {
                                args = new Object[]{new Long(value)};
                            }
                            catch (Exception e) {
                                throw new SAXParseException("Attribute " + qName + " contains an invalid Long value: " + value, this.getDocumentLocator());
                            }
                        }
                        if (argClasses[0] == (class$java$lang$Short == null ? Configurator.class$("java.lang.Short") : class$java$lang$Short) || argClasses[0] == Short.TYPE) {
                            try {
                                args = new Object[]{new Short(value)};
                            }
                            catch (Exception e) {
                                throw new SAXParseException("Attribute " + qName + " contains an invalid Short value: " + value, this.getDocumentLocator());
                            }
                        }
                        if (argClasses[0] == (class$java$lang$Byte == null ? Configurator.class$("java.lang.Byte") : class$java$lang$Byte) || argClasses[0] == Byte.TYPE) {
                            try {
                                args = new Object[]{new Byte(value)};
                            }
                            catch (Exception e) {
                                throw new SAXParseException("Attribute " + qName + " contains an invalid Byte value: " + value, this.getDocumentLocator());
                            }
                        }
                        if (argClasses[0] == (class$java$lang$Boolean == null ? Configurator.class$("java.lang.Boolean") : class$java$lang$Boolean) || argClasses[0] == Boolean.TYPE) {
                            try {
                                args = new Object[]{Boolean.valueOf(value)};
                            }
                            catch (Exception e) {
                                throw new SAXParseException("Attribute " + qName + " contains an invalid Boolean value: " + value, this.getDocumentLocator());
                            }
                        }
                        if (argClasses[0] == (class$java$lang$Character == null ? Configurator.class$("java.lang.Character") : class$java$lang$Character) || argClasses[0] == Character.TYPE) {
                            if (value.length() != 1) {
                                throw new SAXParseException("Attribute " + qName + " contains an invalid Character value: " + value, this.getDocumentLocator());
                            }
                            args = new Object[]{new Character(value.charAt(0))};
                        } else if (argClasses[0] == (class$java$lang$Class == null ? Configurator.class$("java.lang.Class") : class$java$lang$Class)) {
                            Class c;
                            try {
                                c = ClassLoader.getClass(value);
                            }
                            catch (Exception e) {
                                throw new SAXParseException("Failed to load class " + value, this.getDocumentLocator(), e);
                            }
                            args = new Object[]{c};
                        } else {
                            if (argClasses[0] == (class$javax$xml$namespace$QName == null ? Configurator.class$("javax.xml.namespace.QName") : class$javax$xml$namespace$QName)) {
                                try {
                                    QName name = QName.valueOf(value);
                                    args = new Object[]{name};
                                }
                                catch (Exception e) {
                                    throw new SAXParseException("Failed to parse QName " + value, this.getDocumentLocator());
                                }
                            }
                            try {
                                Constructor<?> con = argClasses[0].getConstructor(oneClassString);
                                args = new Object[]{con.newInstance(value)};
                            }
                            catch (InvocationTargetException e) {
                                Throwable t = e.getTargetException();
                                throw new SAXParseException("Failed to invoke constructor of class " + argClasses[0].getClass().getName(), this.getDocumentLocator(), t instanceof Exception ? (Exception)t : e);
                            }
                            catch (NoSuchMethodException e) {
                                throw new SAXParseException("Attribute " + qName + " has an invalid type: " + argClasses[0].getClass().getName(), this.getDocumentLocator());
                            }
                            catch (IllegalAccessException e) {
                                throw new SAXParseException("Illegal access to constructor of class " + argClasses[0].getClass().getName(), this.getDocumentLocator(), e);
                            }
                            catch (InstantiationException e) {
                                throw new SAXParseException("Failed to instantiate class " + argClasses[0].getClass().getName(), this.getDocumentLocator(), e);
                            }
                        }
                    }
                    try {
                        method.invoke(this.currentBean, args);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new SAXParseException("Illegal access to method " + setMethodName + " of class " + this.currentBean.getClass().getName(), this.getDocumentLocator(), e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        throw new SAXParseException("Failed to invoke method " + setMethodName + " of class " + this.currentBean.getClass().getName(), this.getDocumentLocator(), t instanceof Exception ? (Exception)t : e);
                    }
                }
            }
        }
    }

    protected Object invokeMethod(String pMethodName, Object pBean, Class[] pSignature, Object[] pArgs) throws SAXException {
        try {
            Method m = pBean.getClass().getMethod(pMethodName, pSignature);
            return m.invoke(pBean, pArgs);
        }
        catch (IllegalAccessException e) {
            throw new SAXParseException("Illegal access to method " + pMethodName + " of class " + pBean.getClass().getName(), this.getDocumentLocator(), e);
        }
        catch (NoSuchMethodException e) {
            throw new SAXParseException("No such method in class " + pBean.getClass().getName() + ": " + pMethodName, this.getDocumentLocator(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new SAXParseException("Failed to invoke method " + pMethodName + " of class " + pBean.getClass().getName(), this.getDocumentLocator(), t instanceof Exception ? (Exception)t : e);
        }
    }

    public void endElement(String namespaceURI, String qName, String localName) throws SAXException {
        block5: {
            if (this.ignoreLevel > 0) {
                --this.ignoreLevel;
                return;
            }
            Object previousBean = this.currentBean;
            if (this.beans.size() > 0) {
                this.currentBean = this.beans.remove(this.beans.size() - 1);
                this.currentName = this.names.remove(this.names.size() - 1).toString();
            } else {
                this.currentBean = null;
                this.currentName = null;
            }
            try {
                this.invokeMethod("finish", previousBean, zeroClasses, zeroObjects);
            }
            catch (SAXParseException e) {
                if (e.getException() != null && e.getException() instanceof NoSuchMethodException) break block5;
                throw e;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreLevel > 0) {
            return;
        }
        String s = new String(ch, start, length);
        try {
            this.invokeMethod("addText", this.currentBean, oneClassString, new String[]{s});
        }
        catch (SAXParseException e) {
            if (e.getException() != null && e.getException() instanceof NoSuchMethodException) {
                boolean allWhitespace = true;
                for (int i = 0; i < length; ++i) {
                    if (Character.isWhitespace(ch[start + i])) continue;
                    allWhitespace = false;
                    break;
                }
                if (!allWhitespace) {
                    throw new SAXParseException("Element " + this.currentName + " doesn't support embedded text.", this.getDocumentLocator());
                }
            }
            throw e;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public Object getResult() {
        return this.resultBean;
    }

    public boolean processName(String pName, String[] parts) {
        int offset = pName.indexOf(58);
        if (offset == -1) {
            String uri = this.nss.getNamespaceURI("");
            parts[0] = uri == null ? "" : uri;
            parts[1] = pName;
            parts[2] = pName;
            return true;
        }
        String uri = this.nss.getNamespaceURI(pName.substring(0, offset));
        if (uri == null) {
            return false;
        }
        parts[0] = uri;
        parts[1] = pName.substring(offset + 1);
        parts[2] = pName;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

