/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.ws.jaxme.JMElement;
import org.apache.ws.jaxme.JMMarshaller;
import org.apache.ws.jaxme.JMXmlSerializer;
import org.apache.ws.jaxme.XMLWriter;
import org.apache.ws.jaxme.impl.JMControllerImpl;
import org.apache.ws.jaxme.util.DOMBuilder;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JMMarshallerImpl
extends JMControllerImpl
implements JMMarshaller {
    public static final String DEFAULT_JAXB_ENCODING = "UTF-8";
    public static final String DEFAULT_JAXME_INDENTATION_STRING = "  ";
    public static final String DEFAULT_JAXME_INDENTATION_SEPARATOR = "\n";
    public static final String JAXME_INDENTATION_STRING = "jaxme.indentation.string";
    public static final String JAXME_INDENTATION_SEPARATOR = "jaxme.indentation.separator";
    public static final String JAXME_XML_DECLARATION = "jaxme.xml.declaration";
    public static final String JAXME_XML_WRITER = "jaxme.xml.writer";
    private static final Class xmlWriterClassDefault;
    private String encoding = "UTF-8";
    private boolean indentation = true;
    private String indentationString = "  ";
    private String indentationSeparator = "\n";
    private boolean xmlDeclaration;
    private Class xmlWriterClass;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$CharSetXMLWriter;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$XMLWriterImpl;
    static /* synthetic */ Class class$org$apache$ws$jaxme$XMLWriter;

    public void setEncoding(String pEncoding) throws PropertyException {
        this.encoding = pEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setXMLWriterClass(Class pClass) throws PropertyException {
        if (pClass == null) {
            this.xmlWriterClass = null;
        } else if ((class$org$apache$ws$jaxme$XMLWriter == null ? (class$org$apache$ws$jaxme$XMLWriter = JMMarshallerImpl.class$("org.apache.ws.jaxme.XMLWriter")) : class$org$apache$ws$jaxme$XMLWriter).isAssignableFrom(pClass) && !pClass.isInterface()) {
            this.xmlWriterClass = pClass;
        } else {
            throw new PropertyException("The class " + pClass.getName() + " is not implementing " + (class$org$apache$ws$jaxme$XMLWriter == null ? (class$org$apache$ws$jaxme$XMLWriter = JMMarshallerImpl.class$("org.apache.ws.jaxme.XMLWriter")) : class$org$apache$ws$jaxme$XMLWriter).getName());
        }
    }

    public Class getXMLWriterClass() {
        return this.xmlWriterClass == null ? xmlWriterClassDefault : this.xmlWriterClass;
    }

    public void setIndentation(boolean pIndentation) {
        this.indentation = pIndentation;
    }

    public boolean getIndentation() {
        return this.indentation;
    }

    public void setXmlDeclaration(boolean pDeclaration) {
        this.xmlDeclaration = pDeclaration;
    }

    public boolean getXmlDeclaration() {
        return this.xmlDeclaration;
    }

    public void setIndentationString(String pStr) {
        this.indentationString = pStr;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public void setIndentationSeparator(String pStr) {
        this.indentationSeparator = pStr;
    }

    public String getIndentationSeparator() {
        return this.indentationSeparator;
    }

    public void setProperty(String pProperty, Object pValue) throws PropertyException {
        if (pProperty.startsWith("jaxb.")) {
            if ("jaxb.encoding".equals(pProperty)) {
                this.setEncoding((String)pValue);
                return;
            }
            if ("jaxb.formatted.output".equals(pProperty)) {
                this.setIndentation((Boolean)pValue);
                return;
            }
        } else if (pProperty.startsWith("jaxme.")) {
            if (JAXME_XML_WRITER.equals(pProperty)) {
                this.setXMLWriterClass((Class)pValue);
                return;
            }
            if (JAXME_XML_DECLARATION.equals(pProperty)) {
                this.setXmlDeclaration((Boolean)pValue);
                return;
            }
            if (JAXME_INDENTATION_SEPARATOR.equals(pProperty)) {
                this.setIndentationSeparator((String)pValue);
                return;
            }
            if (JAXME_INDENTATION_STRING.equals(pProperty)) {
                this.setIndentationString((String)pValue);
                return;
            }
        }
        super.setProperty(pProperty, pValue);
    }

    public Object getProperty(String pProperty) throws PropertyException {
        if (pProperty.startsWith("jaxb.")) {
            if ("jaxb.encoding".equals(pProperty)) {
                return this.getEncoding();
            }
            if ("jaxb.formatted.output".equals(pProperty)) {
                return new Boolean(this.getIndentation());
            }
        } else if (pProperty.startsWith("jaxme.")) {
            if (JAXME_INDENTATION_STRING.equals(pProperty)) {
                return this.getIndentationString();
            }
            if (JAXME_XML_WRITER.equals(pProperty)) {
                return this.getXMLWriterClass();
            }
            if (JAXME_XML_DECLARATION.equals(pProperty)) {
                return this.getEncoding();
            }
            if (JAXME_INDENTATION_SEPARATOR.equals(pProperty)) {
                return this.getIndentationSeparator();
            }
        }
        return super.getProperty(pProperty);
    }

    public void marshal(Object pObject, OutputStream pStream) throws JAXBException {
        OutputStreamWriter writer;
        try {
            writer = new OutputStreamWriter(pStream, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new MarshalException("Unsupported encoding: " + this.getEncoding(), (Throwable)e);
        }
        this.marshal(pObject, writer);
        try {
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object pObject, ContentHandler pHandler) throws JAXBException {
        JMElement element = (JMElement)pObject;
        try {
            JMXmlSerializer serializer = this.getJAXBContextImpl().getJMXmlSerializer(element.getQName());
            serializer.marshal(serializer.getData(this, pHandler), element.getQName(), element);
        }
        catch (SAXException e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object pObject, Writer pWriter) throws JAXBException {
        XMLWriter w;
        if (this.getXmlDeclaration()) {
            try {
                pWriter.write("<?xml version='1.0' encoding='" + this.getEncoding() + "'?>");
                if (this.getIndentation()) {
                    pWriter.write(this.getIndentationSeparator());
                }
            }
            catch (IOException e) {
                throw new MarshalException((Throwable)e);
            }
        }
        Class c = this.getXMLWriterClass();
        try {
            w = (XMLWriter)c.newInstance();
        }
        catch (Exception e) {
            throw new JAXBException("Failed to instantiate XMLWriter class " + c.getName(), (Throwable)e);
        }
        w.init(this);
        w.setWriter(pWriter);
        this.marshal(pObject, w);
    }

    public void marshal(Object pObject, Node pNode) throws JAXBException {
        DOMBuilder db = new DOMBuilder();
        db.setTarget(pNode);
        this.marshal(pObject, db);
    }

    public void marshal(Object pObject, Result pResult) throws JAXBException {
        if (pResult instanceof SAXResult) {
            ContentHandler ch = ((SAXResult)pResult).getHandler();
            if (ch == null) {
                throw new MarshalException("The SAXResult doesn't have its ContentHandler set.");
            }
            this.marshal(pObject, ch);
        } else if (pResult instanceof StreamResult) {
            StreamResult sr = (StreamResult)pResult;
            Writer w = sr.getWriter();
            if (w == null) {
                OutputStream s = sr.getOutputStream();
                if (s == null) {
                    throw new MarshalException("The StreamResult doesn't have its Writer or OutputStream set.");
                }
                this.marshal(pObject, s);
            } else {
                this.marshal(pObject, w);
            }
        } else if (pResult instanceof DOMResult) {
            Node node = ((DOMResult)pResult).getNode();
            if (node == null) {
                throw new MarshalException("The DOMResult doesn't have its Node set.");
            }
            this.marshal(pObject, node);
        } else {
            throw new MarshalException("Unknown type of Result: " + pResult.getClass().getName() + ", only SAXResult, StreamResult and DOMResult are supported.");
        }
    }

    public Node getNode(Object contentTree) throws JAXBException {
        throw new UnsupportedOperationException("JaxMe doesn't support live DOM views");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean haveCharset = false;
        try {
            Class.forName("java.nio.charset.Charset");
            haveCharset = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Class clazz = haveCharset ? (class$org$apache$ws$jaxme$impl$CharSetXMLWriter == null ? (class$org$apache$ws$jaxme$impl$CharSetXMLWriter = JMMarshallerImpl.class$("org.apache.ws.jaxme.impl.CharSetXMLWriter")) : class$org$apache$ws$jaxme$impl$CharSetXMLWriter) : (class$org$apache$ws$jaxme$impl$XMLWriterImpl == null ? (class$org$apache$ws$jaxme$impl$XMLWriterImpl = JMMarshallerImpl.class$("org.apache.ws.jaxme.impl.XMLWriterImpl")) : class$org$apache$ws$jaxme$impl$XMLWriterImpl);
        xmlWriterClassDefault = clazz;
    }
}

